/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.jndi;

import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.migrate.jndi.JNDIExtendedResponse;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import javax.naming.NamingException;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JNDIExtendedRequest
implements javax.naming.ldap.ExtendedRequest {
    private static final long serialVersionUID = -8502230539753937274L;
    private final ExtendedRequest r;

    public JNDIExtendedRequest(ExtendedRequest r) {
        this.r = r;
    }

    public JNDIExtendedRequest(javax.naming.ldap.ExtendedRequest r) throws NamingException {
        this.r = JNDIExtendedRequest.toSDKExtendedRequest(r);
    }

    public String getID() {
        return this.r.getOID();
    }

    public byte[] getEncodedValue() {
        ASN1OctetString value = this.r.getValue();
        if (value == null) {
            return null;
        }
        return value.encode();
    }

    public JNDIExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        return new JNDIExtendedResponse(id, berValue, offset, length);
    }

    public ExtendedRequest toSDKExtendedRequest() {
        return this.r;
    }

    public static ExtendedRequest toSDKExtendedRequest(javax.naming.ldap.ExtendedRequest r) throws NamingException {
        ASN1OctetString value;
        if (r == null) {
            return null;
        }
        byte[] valueBytes = r.getEncodedValue();
        if (valueBytes == null) {
            value = null;
        } else {
            try {
                value = ASN1OctetString.decodeAsOctetString(valueBytes);
            }
            catch (ASN1Exception ae) {
                throw new NamingException(StaticUtils.getExceptionMessage(ae));
            }
        }
        return new ExtendedRequest(r.getID(), value);
    }

    public String toString() {
        return this.r.toString();
    }
}

