/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ssl.SSLUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;

final class ConnectThread
extends Thread {
    private final AtomicBoolean connected;
    private final AtomicReference<Socket> socket;
    private final AtomicReference<Thread> thread;
    private final AtomicReference<Throwable> exception;
    private final CountDownLatch startLatch;
    private final int port;
    private final SocketFactory socketFactory;
    private final InetAddress address;

    ConnectThread(SocketFactory socketFactory, InetAddress address, int port) {
        super("Background connect thread for " + address + ':' + port);
        this.setDaemon(true);
        this.socketFactory = socketFactory;
        this.address = address;
        this.port = port;
        this.connected = new AtomicBoolean(false);
        this.socket = new AtomicReference();
        this.thread = new AtomicReference();
        this.exception = new AtomicReference();
        this.startLatch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.thread.set(Thread.currentThread());
        this.startLatch.countDown();
        try {
            try {
                boolean connectNeeded;
                Socket s;
                try {
                    s = this.socketFactory.createSocket();
                    connectNeeded = true;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    s = this.socketFactory.createSocket(this.address, this.port);
                    connectNeeded = false;
                }
                this.socket.set(s);
                if (connectNeeded) {
                    s.connect(new InetSocketAddress(this.address, this.port));
                }
                SSLUtil.applyEnabledSSLProtocols(s);
                this.connected.set(true);
            }
            catch (Throwable t) {
                Debug.debugException(t);
                this.exception.set(t);
                Object var5_6 = null;
                this.thread.set(null);
            }
            Object var5_5 = null;
            this.thread.set(null);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.thread.set(null);
            throw throwable;
        }
    }

    Socket getConnectedSocket(long timeoutMillis) throws LDAPException {
        Thread t;
        while (this.startLatch.getCount() > 0L) {
            try {
                this.startLatch.await();
                break;
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
            }
        }
        if ((t = this.thread.get()) != null) {
            try {
                t.join(timeoutMillis);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        if (this.connected.get()) {
            return this.socket.get();
        }
        try {
            if (t != null) {
                t.interrupt();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            Socket s = this.socket.get();
            if (s != null) {
                s.close();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        Throwable cause = this.exception.get();
        if (cause == null) {
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONNECT_THREAD_TIMEOUT.get(this.address, this.port, timeoutMillis));
        }
        throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_CONNECT_THREAD_EXCEPTION.get(this.address, this.port, StaticUtils.getExceptionMessage(cause)), cause);
    }
}

