/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldif;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.ldif.LDIFRecord;
import com.unboundid.ldif.LDIFWriterEntryTranslator;
import com.unboundid.util.Base64;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPSDKThreadFactory;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.parallel.ParallelProcessor;
import com.unboundid.util.parallel.Processor;
import com.unboundid.util.parallel.Result;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDIFWriter {
    private static final byte[] VERSION_1_HEADER_BYTES = StaticUtils.getBytes("version: 1" + StaticUtils.EOL);
    private static final int DEFAULT_BUFFER_SIZE = 131072;
    private final BufferedOutputStream writer;
    private final ByteStringBuffer buffer;
    private final LDIFWriterEntryTranslator entryTranslator;
    private int wrapColumn = 0;
    private int wrapColumnMinusTwo = -2;
    private final ParallelProcessor<LDIFRecord, ByteStringBuffer> toLdifBytesInvoker;

    public LDIFWriter(String path) throws IOException {
        this(new FileOutputStream(path));
    }

    public LDIFWriter(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public LDIFWriter(OutputStream outputStream) {
        this(outputStream, 0);
    }

    public LDIFWriter(OutputStream outputStream, int parallelThreads) {
        this(outputStream, parallelThreads, null);
    }

    public LDIFWriter(OutputStream outputStream, int parallelThreads, final LDIFWriterEntryTranslator entryTranslator) {
        Validator.ensureNotNull(outputStream);
        Validator.ensureTrue(parallelThreads >= 0, "LDIFWriter.parallelThreads must not be negative.");
        this.entryTranslator = entryTranslator;
        this.buffer = new ByteStringBuffer();
        this.writer = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, 131072);
        if (parallelThreads == 0) {
            this.toLdifBytesInvoker = null;
        } else {
            LDAPSDKThreadFactory threadFactory = new LDAPSDKThreadFactory("LDIFWriter Worker", true, null);
            this.toLdifBytesInvoker = new ParallelProcessor<LDIFRecord, ByteStringBuffer>(new Processor<LDIFRecord, ByteStringBuffer>(){

                @Override
                public ByteStringBuffer process(LDIFRecord input) throws IOException {
                    LDIFRecord r;
                    if (entryTranslator != null && input instanceof Entry) {
                        r = entryTranslator.translateEntryToWrite((Entry)input);
                        if (r == null) {
                            return null;
                        }
                    } else {
                        r = input;
                    }
                    ByteStringBuffer b = new ByteStringBuffer(200);
                    r.toLDIF(b, LDIFWriter.this.wrapColumn);
                    return b;
                }
            }, threadFactory, parallelThreads, 5);
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.toLdifBytesInvoker != null) {
                try {
                    this.toLdifBytesInvoker.shutdown();
                }
                catch (InterruptedException e) {
                    Debug.debugException(e);
                }
            }
        }
        finally {
            this.writer.close();
        }
    }

    public int getWrapColumn() {
        return this.wrapColumn;
    }

    public void setWrapColumn(int wrapColumn) {
        this.wrapColumn = wrapColumn;
        this.wrapColumnMinusTwo = wrapColumn - 2;
    }

    public void writeVersionHeader() throws IOException {
        this.writer.write(VERSION_1_HEADER_BYTES);
    }

    public void writeEntry(Entry entry) throws IOException {
        this.writeEntry(entry, null);
    }

    public void writeEntry(Entry entry, String comment) throws IOException {
        Entry e;
        Validator.ensureNotNull(entry);
        if (this.entryTranslator == null) {
            e = entry;
        } else {
            e = this.entryTranslator.translateEntryToWrite(entry);
            if (e == null) {
                return;
            }
        }
        if (comment != null) {
            this.writeComment(comment, false, false);
        }
        Debug.debugLDIFWrite(e);
        this.writeLDIF(e);
    }

    public void writeChangeRecord(LDIFChangeRecord changeRecord) throws IOException {
        Validator.ensureNotNull(changeRecord);
        Debug.debugLDIFWrite(changeRecord);
        this.writeLDIF(changeRecord);
    }

    public void writeChangeRecord(LDIFChangeRecord changeRecord, String comment) throws IOException {
        Validator.ensureNotNull(changeRecord);
        Debug.debugLDIFWrite(changeRecord);
        if (comment != null) {
            this.writeComment(comment, false, false);
        }
        this.writeLDIF(changeRecord);
    }

    public void writeLDIFRecord(LDIFRecord record) throws IOException {
        this.writeLDIFRecord(record, null);
    }

    public void writeLDIFRecord(LDIFRecord record, String comment) throws IOException {
        LDIFRecord r;
        Validator.ensureNotNull(record);
        if (this.entryTranslator != null && record instanceof Entry) {
            r = this.entryTranslator.translateEntryToWrite((Entry)record);
            if (r == null) {
                return;
            }
        } else {
            r = record;
        }
        Debug.debugLDIFWrite(r);
        if (comment != null) {
            this.writeComment(comment, false, false);
        }
        this.writeLDIF(r);
    }

    public void writeLDIFRecords(List<? extends LDIFRecord> ldifRecords) throws IOException, InterruptedException {
        if (this.toLdifBytesInvoker == null) {
            for (LDIFRecord lDIFRecord : ldifRecords) {
                this.writeLDIFRecord(lDIFRecord);
            }
        } else {
            ArrayList<Result<? extends LDIFRecord, ByteStringBuffer>> results = this.toLdifBytesInvoker.processAll(ldifRecords);
            for (Result result : results) {
                LDIFWriter.rethrow(result.getFailureCause());
                ByteStringBuffer encodedBytes = (ByteStringBuffer)result.getOutput();
                if (encodedBytes == null) continue;
                encodedBytes.write(this.writer);
                this.writer.write(StaticUtils.EOL_BYTES);
            }
        }
    }

    public void writeComment(String comment, boolean spaceBefore, boolean spaceAfter) throws IOException {
        Validator.ensureNotNull(comment);
        if (spaceBefore) {
            this.writer.write(StaticUtils.EOL_BYTES);
        }
        if (comment.indexOf(10) < 0) {
            this.writeSingleLineComment(comment);
        } else {
            String[] lines;
            for (String line : lines = comment.split("\\r?\\n")) {
                this.writeSingleLineComment(line);
            }
        }
        if (spaceAfter) {
            this.writer.write(StaticUtils.EOL_BYTES);
        }
    }

    private void writeSingleLineComment(String comment) throws IOException {
        int commentWrapMinusTwo = this.wrapColumn <= 0 ? 77 : this.wrapColumnMinusTwo;
        this.buffer.clear();
        int length = comment.length();
        if (length <= commentWrapMinusTwo) {
            this.buffer.append("# ");
            this.buffer.append(comment);
            this.buffer.append(StaticUtils.EOL_BYTES);
        } else {
            int minPos = 0;
            while (minPos < length) {
                int pos;
                int spacePos;
                if (length - minPos <= commentWrapMinusTwo) {
                    this.buffer.append("# ");
                    this.buffer.append(comment.substring(minPos));
                    this.buffer.append(StaticUtils.EOL_BYTES);
                    break;
                }
                boolean spaceFound = false;
                for (spacePos = pos = minPos + commentWrapMinusTwo; spacePos > minPos; --spacePos) {
                    if (comment.charAt(spacePos) != ' ') continue;
                    spaceFound = true;
                    break;
                }
                if (!spaceFound) {
                    for (spacePos = pos + 1; spacePos < length; ++spacePos) {
                        if (comment.charAt(spacePos) != ' ') continue;
                        spaceFound = true;
                        break;
                    }
                    if (!spaceFound) {
                        this.buffer.append("# ");
                        this.buffer.append(comment.substring(minPos));
                        this.buffer.append(StaticUtils.EOL_BYTES);
                        break;
                    }
                }
                this.buffer.append("# ");
                this.buffer.append(comment.substring(minPos, spacePos));
                this.buffer.append(StaticUtils.EOL_BYTES);
                for (minPos = spacePos + 1; minPos < length && comment.charAt(minPos) == ' '; ++minPos) {
                }
            }
        }
        this.buffer.write(this.writer);
    }

    private void writeLDIF(LDIFRecord record) throws IOException {
        this.buffer.clear();
        record.toLDIF(this.buffer, this.wrapColumn);
        this.buffer.append(StaticUtils.EOL_BYTES);
        this.buffer.write(this.writer);
    }

    public static List<String> wrapLines(int wrapColumn, String ... ldifLines) {
        return LDIFWriter.wrapLines(wrapColumn, Arrays.asList(ldifLines));
    }

    public static List<String> wrapLines(int wrapColumn, List<String> ldifLines) {
        if (wrapColumn <= 2) {
            return new ArrayList<String>(ldifLines);
        }
        ArrayList<String> newLines = new ArrayList<String>(ldifLines.size());
        block0: for (String s : ldifLines) {
            int length = s.length();
            if (length <= wrapColumn) {
                newLines.add(s);
                continue;
            }
            newLines.add(s.substring(0, wrapColumn));
            for (int pos = wrapColumn; pos < length; pos += wrapColumn - 1) {
                if (length - pos + 1 <= wrapColumn) {
                    newLines.add(' ' + s.substring(pos));
                    continue block0;
                }
                newLines.add(' ' + s.substring(pos, pos + wrapColumn - 1));
            }
        }
        return newLines;
    }

    public static String encodeNameAndValue(String name, ASN1OctetString value) {
        StringBuilder buffer = new StringBuilder();
        LDIFWriter.encodeNameAndValue(name, value, buffer);
        return buffer.toString();
    }

    public static void encodeNameAndValue(String name, ASN1OctetString value, StringBuilder buffer) {
        LDIFWriter.encodeNameAndValue(name, value, buffer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encodeNameAndValue(String name, ASN1OctetString value, StringBuilder buffer, int wrapColumn) {
        int bufferStartPos = buffer.length();
        try {
            buffer.append(name);
            buffer.append(':');
            byte[] valueBytes = value.getValue();
            int length = valueBytes.length;
            if (length == 0) {
                buffer.append(' ');
                Object var9_7 = null;
                if (wrapColumn <= 2) return;
                int length2 = buffer.length() - bufferStartPos;
                if (length2 <= wrapColumn) return;
                String EOL_PLUS_SPACE = StaticUtils.EOL + ' ';
                buffer.insert(bufferStartPos + wrapColumn, EOL_PLUS_SPACE);
                for (int pos = bufferStartPos + 2 * wrapColumn + EOL_PLUS_SPACE.length() - 1; pos < buffer.length(); pos += wrapColumn - 1 + EOL_PLUS_SPACE.length()) {
                    buffer.insert(pos, EOL_PLUS_SPACE);
                }
                return;
            }
            switch (valueBytes[0]) {
                case 32: 
                case 58: 
                case 60: {
                    buffer.append(": ");
                    Base64.encode(valueBytes, buffer);
                    Object var9_8 = null;
                    if (wrapColumn <= 2) return;
                    int length2 = buffer.length() - bufferStartPos;
                    if (length2 <= wrapColumn) return;
                    String EOL_PLUS_SPACE = StaticUtils.EOL + ' ';
                    buffer.insert(bufferStartPos + wrapColumn, EOL_PLUS_SPACE);
                    for (int pos = bufferStartPos + 2 * wrapColumn + EOL_PLUS_SPACE.length() - 1; pos < buffer.length(); pos += wrapColumn - 1 + EOL_PLUS_SPACE.length()) {
                        buffer.insert(pos, EOL_PLUS_SPACE);
                    }
                    return;
                }
            }
            if (valueBytes[length - 1] == 32) {
                buffer.append(": ");
                Base64.encode(valueBytes, buffer);
                Object var9_9 = null;
                if (wrapColumn <= 2) return;
                int length2 = buffer.length() - bufferStartPos;
                if (length2 <= wrapColumn) return;
                String EOL_PLUS_SPACE = StaticUtils.EOL + ' ';
                buffer.insert(bufferStartPos + wrapColumn, EOL_PLUS_SPACE);
                for (int pos = bufferStartPos + 2 * wrapColumn + EOL_PLUS_SPACE.length() - 1; pos < buffer.length(); pos += wrapColumn - 1 + EOL_PLUS_SPACE.length()) {
                    buffer.insert(pos, EOL_PLUS_SPACE);
                }
                return;
            }
            for (int i = 0; i < length; ++i) {
                if ((valueBytes[i] & 0x7F) != (valueBytes[i] & 0xFF)) {
                    buffer.append(": ");
                    Base64.encode(valueBytes, buffer);
                    Object var9_10 = null;
                    if (wrapColumn <= 2) return;
                    int length2 = buffer.length() - bufferStartPos;
                    if (length2 <= wrapColumn) return;
                    String EOL_PLUS_SPACE = StaticUtils.EOL + ' ';
                    buffer.insert(bufferStartPos + wrapColumn, EOL_PLUS_SPACE);
                    for (int pos = bufferStartPos + 2 * wrapColumn + EOL_PLUS_SPACE.length() - 1; pos < buffer.length(); pos += wrapColumn - 1 + EOL_PLUS_SPACE.length()) {
                        buffer.insert(pos, EOL_PLUS_SPACE);
                    }
                    return;
                }
                switch (valueBytes[i]) {
                    case 0: 
                    case 10: 
                    case 13: {
                        buffer.append(": ");
                        Base64.encode(valueBytes, buffer);
                        Object var9_11 = null;
                        if (wrapColumn <= 2) return;
                        int length2 = buffer.length() - bufferStartPos;
                        if (length2 <= wrapColumn) return;
                        String EOL_PLUS_SPACE = StaticUtils.EOL + ' ';
                        buffer.insert(bufferStartPos + wrapColumn, EOL_PLUS_SPACE);
                        for (int pos = bufferStartPos + 2 * wrapColumn + EOL_PLUS_SPACE.length() - 1; pos < buffer.length(); pos += wrapColumn - 1 + EOL_PLUS_SPACE.length()) {
                            buffer.insert(pos, EOL_PLUS_SPACE);
                        }
                        return;
                    }
                }
            }
            buffer.append(' ');
            buffer.append(value.stringValue());
            Object var9_12 = null;
            if (wrapColumn <= 2) return;
        }
        catch (Throwable throwable) {
            int length2;
            Object var9_13 = null;
            if (wrapColumn <= 2 || (length2 = buffer.length() - bufferStartPos) <= wrapColumn) throw throwable;
            String EOL_PLUS_SPACE = StaticUtils.EOL + ' ';
            buffer.insert(bufferStartPos + wrapColumn, EOL_PLUS_SPACE);
            for (int pos = bufferStartPos + 2 * wrapColumn + EOL_PLUS_SPACE.length() - 1; pos < buffer.length(); pos += wrapColumn - 1 + EOL_PLUS_SPACE.length()) {
                buffer.insert(pos, EOL_PLUS_SPACE);
            }
            throw throwable;
        }
        int length2 = buffer.length() - bufferStartPos;
        if (length2 <= wrapColumn) return;
        String EOL_PLUS_SPACE = StaticUtils.EOL + ' ';
        buffer.insert(bufferStartPos + wrapColumn, EOL_PLUS_SPACE);
        for (int pos = bufferStartPos + 2 * wrapColumn + EOL_PLUS_SPACE.length() - 1; pos < buffer.length(); pos += wrapColumn - 1 + EOL_PLUS_SPACE.length()) {
            buffer.insert(pos, EOL_PLUS_SPACE);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void encodeNameAndValue(String name, ASN1OctetString value, ByteStringBuffer buffer, int wrapColumn) {
        int bufferStartPos = buffer.length();
        try {
            buffer.append(name);
            LDIFWriter.encodeValue(value, buffer);
            Object var6_5 = null;
            if (wrapColumn <= 2) return;
            int length = buffer.length() - bufferStartPos;
            if (length <= wrapColumn) return;
        }
        catch (Throwable throwable) {
            int length;
            Object var6_6 = null;
            if (wrapColumn <= 2 || (length = buffer.length() - bufferStartPos) <= wrapColumn) throw throwable;
            byte[] EOL_BYTES_PLUS_SPACE = new byte[StaticUtils.EOL_BYTES.length + 1];
            System.arraycopy(StaticUtils.EOL_BYTES, 0, EOL_BYTES_PLUS_SPACE, 0, StaticUtils.EOL_BYTES.length);
            EOL_BYTES_PLUS_SPACE[StaticUtils.EOL_BYTES.length] = 32;
            buffer.insert(bufferStartPos + wrapColumn, EOL_BYTES_PLUS_SPACE);
            for (int pos = bufferStartPos + 2 * wrapColumn + EOL_BYTES_PLUS_SPACE.length - 1; pos < buffer.length(); pos += wrapColumn - 1 + EOL_BYTES_PLUS_SPACE.length) {
                buffer.insert(pos, EOL_BYTES_PLUS_SPACE);
            }
            throw throwable;
        }
        byte[] EOL_BYTES_PLUS_SPACE = new byte[StaticUtils.EOL_BYTES.length + 1];
        System.arraycopy(StaticUtils.EOL_BYTES, 0, EOL_BYTES_PLUS_SPACE, 0, StaticUtils.EOL_BYTES.length);
        EOL_BYTES_PLUS_SPACE[StaticUtils.EOL_BYTES.length] = 32;
        buffer.insert(bufferStartPos + wrapColumn, EOL_BYTES_PLUS_SPACE);
        for (int pos = bufferStartPos + 2 * wrapColumn + EOL_BYTES_PLUS_SPACE.length - 1; pos < buffer.length(); pos += wrapColumn - 1 + EOL_BYTES_PLUS_SPACE.length) {
            buffer.insert(pos, EOL_BYTES_PLUS_SPACE);
        }
        return;
    }

    static void encodeValue(ASN1OctetString value, ByteStringBuffer buffer) {
        buffer.append(':');
        byte[] valueBytes = value.getValue();
        int length = valueBytes.length;
        if (length == 0) {
            buffer.append(' ');
            return;
        }
        switch (valueBytes[0]) {
            case 32: 
            case 58: 
            case 60: {
                buffer.append(':');
                buffer.append(' ');
                Base64.encode(valueBytes, buffer);
                return;
            }
        }
        if (valueBytes[length - 1] == 32) {
            buffer.append(':');
            buffer.append(' ');
            Base64.encode(valueBytes, buffer);
            return;
        }
        for (int i = 0; i < length; ++i) {
            if ((valueBytes[i] & 0x7F) != (valueBytes[i] & 0xFF)) {
                buffer.append(':');
                buffer.append(' ');
                Base64.encode(valueBytes, buffer);
                return;
            }
            switch (valueBytes[i]) {
                case 0: 
                case 10: 
                case 13: {
                    buffer.append(':');
                    buffer.append(' ');
                    Base64.encode(valueBytes, buffer);
                    return;
                }
            }
        }
        buffer.append(' ');
        buffer.append(valueBytes);
    }

    static void rethrow(Throwable t) throws IOException {
        if (t == null) {
            return;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw StaticUtils.createIOExceptionWithCause(null, t);
    }
}

