/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.AssertionRequestControl;
import com.unboundid.ldap.sdk.controls.AuthorizationIdentityRequestControl;
import com.unboundid.ldap.sdk.controls.DontUseCopyRequestControl;
import com.unboundid.ldap.sdk.controls.ManageDsaITRequestControl;
import com.unboundid.ldap.sdk.controls.PermissiveModifyRequestControl;
import com.unboundid.ldap.sdk.controls.PostReadRequestControl;
import com.unboundid.ldap.sdk.controls.PreReadRequestControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV1RequestControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV2RequestControl;
import com.unboundid.ldap.sdk.controls.ServerSideSortRequestControl;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.controls.SubentriesRequestControl;
import com.unboundid.ldap.sdk.controls.SubtreeDeleteRequestControl;
import com.unboundid.ldap.sdk.controls.TransactionSpecificationRequestControl;
import com.unboundid.ldap.sdk.controls.VirtualListViewRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.IgnoreNoUserModificationRequestControl;
import com.unboundid.util.StaticUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class RequestControlPreProcessor {
    private RequestControlPreProcessor() {
    }

    static Map<String, Control> processControls(byte requestOpType, List<Control> controls) throws LDAPException {
        LinkedHashMap<String, Control> m = new LinkedHashMap<String, Control>(StaticUtils.computeMapCapacity(controls.size()));
        block48: for (Control control : controls) {
            String oid = control.getOID();
            if (oid.equals("1.3.6.1.1.12")) {
                switch (requestOpType) {
                    case 74: 
                    case 99: 
                    case 102: 
                    case 104: 
                    case 108: 
                    case 110: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new AssertionRequestControl(control)) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("2.16.840.1.113730.3.4.16")) {
                switch (requestOpType) {
                    case 96: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new AuthorizationIdentityRequestControl(control)) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("1.3.6.1.1.22")) {
                switch (requestOpType) {
                    case 99: 
                    case 110: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new DontUseCopyRequestControl(control)) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("2.16.840.1.113730.3.4.2")) {
                switch (requestOpType) {
                    case 74: 
                    case 99: 
                    case 102: 
                    case 104: 
                    case 108: 
                    case 110: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new ManageDsaITRequestControl(control)) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("1.2.840.113556.1.4.1413")) {
                switch (requestOpType) {
                    case 102: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new PermissiveModifyRequestControl(control)) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("1.3.6.1.1.13.2")) {
                switch (requestOpType) {
                    case 102: 
                    case 104: 
                    case 108: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new PostReadRequestControl(control)) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("1.3.6.1.1.13.1")) {
                switch (requestOpType) {
                    case 74: 
                    case 102: 
                    case 108: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new PreReadRequestControl(control)) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("2.16.840.1.113730.3.4.12")) {
                switch (requestOpType) {
                    case 74: 
                    case 99: 
                    case 102: 
                    case 104: 
                    case 108: 
                    case 110: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new ProxiedAuthorizationV1RequestControl(control)) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("2.16.840.1.113730.3.4.18")) {
                switch (requestOpType) {
                    case 74: 
                    case 99: 
                    case 102: 
                    case 104: 
                    case 108: 
                    case 110: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new ProxiedAuthorizationV2RequestControl(control)) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("1.2.840.113556.1.4.473")) {
                switch (requestOpType) {
                    case 99: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new ServerSideSortRequestControl(control)) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("1.2.840.113556.1.4.319")) {
                switch (requestOpType) {
                    case 99: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new SimplePagedResultsControl(control.getOID(), control.isCritical(), control.getValue())) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("1.3.6.1.4.1.7628.5.101.1")) {
                switch (requestOpType) {
                    case 99: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new SubentriesRequestControl(control)) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("1.2.840.113556.1.4.805")) {
                switch (requestOpType) {
                    case 74: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new SubtreeDeleteRequestControl(control)) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("1.3.6.1.1.21.2")) {
                switch (requestOpType) {
                    case 74: 
                    case 102: 
                    case 104: 
                    case 108: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new TransactionSpecificationRequestControl(control)) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("2.16.840.1.113730.3.4.9")) {
                switch (requestOpType) {
                    case 99: {
                        break;
                    }
                    default: {
                        if (!control.isCritical()) continue block48;
                        throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
                    }
                }
                if (m.put(oid, new VirtualListViewRequestControl(control)) == null) continue;
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_CONTROLS.get(oid));
            }
            if (oid.equals("1.3.6.1.4.1.4203.1.10.2")) {
                switch (requestOpType) {
                    case 74: 
                    case 102: 
                    case 104: 
                    case 108: {
                        throw new LDAPException(ResultCode.NO_OPERATION, ListenerMessages.ERR_CONTROL_PROCESSOR_NO_OPERATION.get());
                    }
                }
                if (!control.isCritical()) continue;
                throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
            }
            if (oid.equals("1.3.6.1.4.1.30221.2.5.5")) {
                if (requestOpType == 104) {
                    m.put(oid, new IgnoreNoUserModificationRequestControl(control));
                    continue;
                }
                if (!control.isCritical()) continue;
                throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_FOR_OP.get(oid));
            }
            if (oid.equals("1.3.6.1.4.1.30221.2.5.18")) {
                m.put(oid, control);
                continue;
            }
            if (!control.isCritical()) continue;
            throw new LDAPException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, ListenerMessages.ERR_CONTROL_PROCESSOR_UNSUPPORTED_CONTROL.get(oid));
        }
        if (m.containsKey("2.16.840.1.113730.3.4.12") && m.containsKey("2.16.840.1.113730.3.4.18")) {
            throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_MULTIPLE_PROXY_CONTROLS.get());
        }
        if (m.containsKey("2.16.840.1.113730.3.4.9")) {
            if (m.containsKey("1.2.840.113556.1.4.319")) {
                throw new LDAPException(ResultCode.CONSTRAINT_VIOLATION, ListenerMessages.ERR_CONTROL_PROCESSOR_VLV_AND_PAGED_RESULTS.get());
            }
            if (!m.containsKey("1.2.840.113556.1.4.473")) {
                throw new LDAPException(ResultCode.SORT_CONTROL_MISSING, ListenerMessages.ERR_CONTROL_PROCESSOR_VLV_WITHOUT_SORT.get());
            }
        }
        return m;
    }
}

