/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.UniquenessMultipleAttributeBehavior;
import com.unboundid.ldap.sdk.unboundidds.controls.UniquenessRequestControlProperties;
import com.unboundid.ldap.sdk.unboundidds.controls.UniquenessValidationLevel;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class UniquenessRequestControl
extends Control {
    public static final String UNIQUENESS_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.52";
    private static final byte TYPE_UNIQUENESS_ID = -128;
    private static final byte TYPE_ATTRIBUTE_TYPES = -95;
    private static final byte TYPE_MULTIPLE_ATTRIBUTE_BEHAVIOR = -126;
    private static final byte TYPE_BASE_DN = -125;
    private static final byte TYPE_FILTER = -92;
    private static final byte TYPE_PREVENT_CONFLICTS_WITH_SOFT_DELETED_ENTRIES = -123;
    private static final byte TYPE_PRE_COMMIT_VALIDATION_LEVEL = -122;
    private static final byte TYPE_POST_COMMIT_VALIDATION_LEVEL = -121;
    private static final long serialVersionUID = 7976218379635922852L;
    private final boolean preventConflictsWithSoftDeletedEntries;
    private final Filter filter;
    private final Set<String> attributeTypes;
    private final String baseDN;
    private final String uniquenessID;
    private final UniquenessMultipleAttributeBehavior multipleAttributeBehavior;
    private final UniquenessValidationLevel postCommitValidationLevel;
    private final UniquenessValidationLevel preCommitValidationLevel;

    public UniquenessRequestControl(boolean isCritical, String uniquenessID, UniquenessRequestControlProperties properties) throws LDAPException {
        this(uniquenessID == null ? UUID.randomUUID().toString() : uniquenessID, properties, isCritical);
    }

    private UniquenessRequestControl(String uniquenessID, UniquenessRequestControlProperties properties, boolean isCritical) throws LDAPException {
        super(UNIQUENESS_REQUEST_OID, isCritical, UniquenessRequestControl.encodeValue(uniquenessID, properties));
        Validator.ensureNotNull(uniquenessID);
        this.uniquenessID = uniquenessID;
        this.attributeTypes = properties.getAttributeTypes();
        this.multipleAttributeBehavior = properties.getMultipleAttributeBehavior();
        this.baseDN = properties.getBaseDN();
        this.filter = properties.getFilter();
        this.preventConflictsWithSoftDeletedEntries = properties.preventConflictsWithSoftDeletedEntries();
        this.preCommitValidationLevel = properties.getPreCommitValidationLevel();
        this.postCommitValidationLevel = properties.getPostCommitValidationLevel();
        if (this.attributeTypes.isEmpty() && this.filter == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_NO_ATTRS_OR_FILTER.get());
        }
    }

    private static ASN1OctetString encodeValue(String uniquenessID, UniquenessRequestControlProperties properties) {
        UniquenessValidationLevel postCommitValidationLevel;
        UniquenessValidationLevel preCommitValidationLevel;
        Filter filter;
        String baseDN;
        UniquenessMultipleAttributeBehavior multipleAttributeBehavior;
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(8);
        elements.add(new ASN1OctetString(-128, uniquenessID));
        Set<String> attributeTypes = properties.getAttributeTypes();
        if (!attributeTypes.isEmpty()) {
            ArrayList<ASN1OctetString> attributeTypeElements = new ArrayList<ASN1OctetString>(attributeTypes.size());
            for (String attributeType : attributeTypes) {
                attributeTypeElements.add(new ASN1OctetString(attributeType));
            }
            elements.add(new ASN1Set(-95, attributeTypeElements));
        }
        if ((multipleAttributeBehavior = properties.getMultipleAttributeBehavior()) != UniquenessMultipleAttributeBehavior.UNIQUE_WITHIN_EACH_ATTRIBUTE) {
            elements.add(new ASN1Enumerated(-126, multipleAttributeBehavior.intValue()));
        }
        if ((baseDN = properties.getBaseDN()) != null) {
            elements.add(new ASN1OctetString(-125, baseDN));
        }
        if ((filter = properties.getFilter()) != null) {
            elements.add(new ASN1Element(-92, filter.encode().encode()));
        }
        if (properties.preventConflictsWithSoftDeletedEntries()) {
            elements.add(new ASN1Boolean(-123, true));
        }
        if ((preCommitValidationLevel = properties.getPreCommitValidationLevel()) != UniquenessValidationLevel.ALL_SUBTREE_VIEWS) {
            elements.add(new ASN1Enumerated(-122, preCommitValidationLevel.intValue()));
        }
        if ((postCommitValidationLevel = properties.getPostCommitValidationLevel()) != UniquenessValidationLevel.ALL_SUBTREE_VIEWS) {
            elements.add(new ASN1Enumerated(-121, postCommitValidationLevel.intValue()));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public UniquenessRequestControl(Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_DECODE_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements;
            boolean decodedPreventSoftDeletedConflicts = false;
            Filter decodedFilter = null;
            Set<Object> decodedAttributeTypes = Collections.emptySet();
            String decodedBaseDN = null;
            String decodedUniquenessID = null;
            UniquenessMultipleAttributeBehavior decodedMultipleAttributeBehavior = UniquenessMultipleAttributeBehavior.UNIQUE_WITHIN_EACH_ATTRIBUTE;
            UniquenessValidationLevel decodedPreCommitLevel = UniquenessValidationLevel.ALL_SUBTREE_VIEWS;
            UniquenessValidationLevel decodedPostCommitLevel = UniquenessValidationLevel.ALL_SUBTREE_VIEWS;
            block13: for (ASN1Element e : elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        decodedUniquenessID = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block13;
                    }
                    case -95: {
                        ASN1Element[] atElements = ASN1Set.decodeAsSet(e).elements();
                        LinkedHashSet<String> atNames = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(atElements.length));
                        for (ASN1Element atElement : atElements) {
                            atNames.add(ASN1OctetString.decodeAsOctetString(atElement).stringValue());
                        }
                        decodedAttributeTypes = Collections.unmodifiableSet(atNames);
                        continue block13;
                    }
                    case -126: {
                        int mabIntValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        decodedMultipleAttributeBehavior = UniquenessMultipleAttributeBehavior.valueOf(mabIntValue);
                        if (decodedMultipleAttributeBehavior != null) continue block13;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_DECODE_UNKNOWN_MULTIPLE_ATTR_BEHAVIOR.get(mabIntValue));
                    }
                    case -125: {
                        decodedBaseDN = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block13;
                    }
                    case -92: {
                        decodedFilter = Filter.decode(ASN1Element.decode(e.getValue()));
                        continue block13;
                    }
                    case -123: {
                        decodedPreventSoftDeletedConflicts = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block13;
                    }
                    case -122: {
                        int preCommitIntValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        decodedPreCommitLevel = UniquenessValidationLevel.valueOf(preCommitIntValue);
                        if (decodedPreCommitLevel != null) continue block13;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_DECODE_UNKNOWN_PRE_COMMIT_LEVEL.get(preCommitIntValue));
                    }
                    case -121: {
                        int postCommitIntValue = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                        decodedPostCommitLevel = UniquenessValidationLevel.valueOf(postCommitIntValue);
                        if (decodedPostCommitLevel != null) continue block13;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_DECODE_UNKNOWN_POST_COMMIT_LEVEL.get(postCommitIntValue));
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_DECODE_UNKNOWN_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            if (decodedUniquenessID == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_MISSING_UNIQUENESS_ID.get());
            }
            if (decodedAttributeTypes.isEmpty() && decodedFilter == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_NO_ATTRS_OR_FILTER.get());
            }
            this.uniquenessID = decodedUniquenessID;
            this.attributeTypes = decodedAttributeTypes;
            this.multipleAttributeBehavior = decodedMultipleAttributeBehavior;
            this.baseDN = decodedBaseDN;
            this.filter = decodedFilter;
            this.preventConflictsWithSoftDeletedEntries = decodedPreventSoftDeletedConflicts;
            this.preCommitValidationLevel = decodedPreCommitLevel;
            this.postCommitValidationLevel = decodedPostCommitLevel;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_UNIQUENESS_REQ_DECODE_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getUniquenessID() {
        return this.uniquenessID;
    }

    public Set<String> getAttributeTypes() {
        return this.attributeTypes;
    }

    public UniquenessMultipleAttributeBehavior getMultipleAttributeBehavior() {
        return this.multipleAttributeBehavior;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean preventConflictsWithSoftDeletedEntries() {
        return this.preventConflictsWithSoftDeletedEntries;
    }

    public UniquenessValidationLevel getPreCommitValidationLevel() {
        return this.preCommitValidationLevel;
    }

    public UniquenessValidationLevel getPostCommitValidationLevel() {
        return this.postCommitValidationLevel;
    }

    @Override
    public String getControlName() {
        return ControlMessages.INFO_UNIQUENESS_REQ_CONTROL_NAME.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("UniquenessRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", uniquenessID='");
        buffer.append(this.uniquenessID);
        buffer.append("', attributeTypes={");
        Iterator<String> attributeTypesIterator = this.attributeTypes.iterator();
        while (attributeTypesIterator.hasNext()) {
            buffer.append('\'');
            buffer.append(attributeTypesIterator.next());
            buffer.append('\'');
            if (!attributeTypesIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, multipleAttributeBehavior=");
        buffer.append((Object)this.multipleAttributeBehavior);
        if (this.baseDN != null) {
            buffer.append(", baseDN='");
            buffer.append(this.baseDN);
            buffer.append('\'');
        }
        if (this.filter != null) {
            buffer.append(", filter='");
            buffer.append(this.filter);
            buffer.append('\'');
        }
        buffer.append(", preventConflictsWithSoftDeletedEntries=");
        buffer.append(this.preventConflictsWithSoftDeletedEntries);
        buffer.append(", preCommitValidationLevel=");
        buffer.append((Object)this.preCommitValidationLevel);
        buffer.append(", postCommitValidationLevel=");
        buffer.append((Object)this.postCommitValidationLevel);
        buffer.append(')');
    }
}

