/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLMessages;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.X509TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JVMDefaultTrustManager
implements X509TrustManager,
Serializable {
    private static final AtomicReference<JVMDefaultTrustManager> INSTANCE = new AtomicReference();
    private static final String PROPERTY_JAVA_HOME = "java.home";
    static final String[] FILE_EXTENSIONS = new String[]{".jks", ".p12", ".pkcs12", ".pfx"};
    private static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];
    private static final long serialVersionUID = -8587938729712485943L;
    private final CertificateException certificateException;
    private final File caCertsFile;
    private final KeyStore keystore;
    private final Map<ASN1OctetString, X509Certificate> trustedCertificateMap;

    JVMDefaultTrustManager(String javaHomePropertyName) {
        ObjectPair<KeyStore, File> keystorePair;
        String javaHomePath = System.getProperty(javaHomePropertyName);
        if (javaHomePath == null) {
            this.certificateException = new CertificateException(SSLMessages.ERR_JVM_DEFAULT_TRUST_MANAGER_NO_JAVA_HOME.get(javaHomePropertyName));
            this.caCertsFile = null;
            this.keystore = null;
            this.trustedCertificateMap = Collections.emptyMap();
            return;
        }
        File javaHomeDirectory = new File(javaHomePath);
        if (!javaHomeDirectory.exists() || !javaHomeDirectory.isDirectory()) {
            this.certificateException = new CertificateException(SSLMessages.ERR_JVM_DEFAULT_TRUST_MANAGER_INVALID_JAVA_HOME.get(javaHomePropertyName, javaHomePath));
            this.caCertsFile = null;
            this.keystore = null;
            this.trustedCertificateMap = Collections.emptyMap();
            return;
        }
        try {
            keystorePair = JVMDefaultTrustManager.getJVMDefaultKeyStore(javaHomeDirectory);
        }
        catch (CertificateException ce) {
            Debug.debugException(ce);
            this.certificateException = ce;
            this.caCertsFile = null;
            this.keystore = null;
            this.trustedCertificateMap = Collections.emptyMap();
            return;
        }
        this.keystore = keystorePair.getFirst();
        this.caCertsFile = keystorePair.getSecond();
        LinkedHashMap<ASN1OctetString, X509Certificate> certificateMap = new LinkedHashMap<ASN1OctetString, X509Certificate>(StaticUtils.computeMapCapacity(50));
        try {
            Enumeration<String> aliasEnumeration = this.keystore.aliases();
            while (aliasEnumeration.hasMoreElements()) {
                String alias = aliasEnumeration.nextElement();
                try {
                    X509Certificate certificate = (X509Certificate)this.keystore.getCertificate(alias);
                    if (certificate == null) continue;
                    certificateMap.put(new ASN1OctetString(certificate.getSignature()), certificate);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.certificateException = new CertificateException(SSLMessages.ERR_JVM_DEFAULT_TRUST_MANAGER_ERROR_ITERATING_THROUGH_CACERTS.get(this.caCertsFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            this.trustedCertificateMap = Collections.emptyMap();
            return;
        }
        this.trustedCertificateMap = Collections.unmodifiableMap(certificateMap);
        this.certificateException = null;
    }

    public static JVMDefaultTrustManager getInstance() {
        JVMDefaultTrustManager existingInstance = INSTANCE.get();
        if (existingInstance != null) {
            return existingInstance;
        }
        JVMDefaultTrustManager newInstance = new JVMDefaultTrustManager(PROPERTY_JAVA_HOME);
        if (INSTANCE.compareAndSet(null, newInstance)) {
            return newInstance;
        }
        return INSTANCE.get();
    }

    KeyStore getKeyStore() throws CertificateException {
        if (this.certificateException != null) {
            throw this.certificateException;
        }
        return this.keystore;
    }

    public File getCACertsFile() throws CertificateException {
        if (this.certificateException != null) {
            throw this.certificateException;
        }
        return this.caCertsFile;
    }

    public Collection<X509Certificate> getTrustedIssuerCertificates() throws CertificateException {
        if (this.certificateException != null) {
            throw this.certificateException;
        }
        return this.trustedCertificateMap.values();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(chain);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (this.certificateException != null) {
            return NO_CERTIFICATES;
        }
        X509Certificate[] acceptedIssuers = new X509Certificate[this.trustedCertificateMap.size()];
        return this.trustedCertificateMap.values().toArray(acceptedIssuers);
    }

    private static ObjectPair<KeyStore, File> getJVMDefaultKeyStore(File javaHomeDirectory) throws CertificateException {
        File libSecurityCACerts = StaticUtils.constructPath(javaHomeDirectory, "lib", "security", "cacerts");
        File jreLibSecurityCACerts = StaticUtils.constructPath(javaHomeDirectory, "jre", "lib", "security", "cacerts");
        ArrayList<File> tryFirstFiles = new ArrayList<File>(2 * FILE_EXTENSIONS.length + 2);
        tryFirstFiles.add(libSecurityCACerts);
        tryFirstFiles.add(jreLibSecurityCACerts);
        for (String extension : FILE_EXTENSIONS) {
            tryFirstFiles.add(new File(libSecurityCACerts.getAbsolutePath() + extension));
            tryFirstFiles.add(new File(jreLibSecurityCACerts.getAbsolutePath() + extension));
        }
        for (File f : tryFirstFiles) {
            KeyStore keyStore = JVMDefaultTrustManager.loadKeyStore(f);
            if (keyStore == null) continue;
            return new ObjectPair<KeyStore, File>(keyStore, f);
        }
        LinkedHashMap<File, CertificateException> exceptions = new LinkedHashMap<File, CertificateException>(StaticUtils.computeMapCapacity(1));
        ObjectPair<KeyStore, File> keystorePair = JVMDefaultTrustManager.searchForKeyStore(javaHomeDirectory, exceptions);
        if (keystorePair != null) {
            return keystorePair;
        }
        if (exceptions.isEmpty()) {
            throw new CertificateException(SSLMessages.ERR_JVM_DEFAULT_TRUST_MANAGER_CACERTS_NOT_FOUND_NO_EXCEPTION.get());
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(SSLMessages.ERR_JVM_DEFAULT_TRUST_MANAGER_CACERTS_NOT_FOUND_WITH_EXCEPTION.get());
        for (Map.Entry<File, CertificateException> e : exceptions.entrySet()) {
            if (buffer.charAt(buffer.length() - 1) != '.') {
                buffer.append('.');
            }
            buffer.append("  ");
            buffer.append(SSLMessages.ERR_JVM_DEFAULT_TRUST_MANAGER_LOAD_ERROR.get(e.getKey().getAbsolutePath(), StaticUtils.getExceptionMessage(e.getValue())));
        }
        throw new CertificateException(buffer.toString());
    }

    private static ObjectPair<KeyStore, File> searchForKeyStore(File directory, Map<File, CertificateException> exceptions) {
        block4: for (File f : directory.listFiles()) {
            if (f.isDirectory()) {
                ObjectPair<KeyStore, File> p = JVMDefaultTrustManager.searchForKeyStore(f, exceptions);
                if (p == null) continue;
                return p;
            }
            String lowerName = StaticUtils.toLowerCase(f.getName());
            if (lowerName.equals("cacerts")) {
                try {
                    KeyStore keystore = JVMDefaultTrustManager.loadKeyStore(f);
                    return new ObjectPair<KeyStore, File>(keystore, f);
                }
                catch (CertificateException ce) {
                    Debug.debugException(ce);
                    exceptions.put(f, ce);
                    continue;
                }
            }
            for (String extension : FILE_EXTENSIONS) {
                if (!lowerName.equals("cacerts" + extension)) continue;
                try {
                    KeyStore keystore = JVMDefaultTrustManager.loadKeyStore(f);
                    return new ObjectPair<KeyStore, File>(keystore, f);
                }
                catch (CertificateException ce) {
                    Debug.debugException(ce);
                    exceptions.put(f, ce);
                    continue block4;
                }
            }
        }
        return null;
    }

    private static KeyStore loadKeyStore(File f) throws CertificateException {
        if (!f.exists() || !f.isFile()) {
            return null;
        }
        CertificateException firstGetInstanceException = null;
        CertificateException firstLoadException = null;
        for (String keyStoreType : new String[]{"JKS", "PKCS12"}) {
            KeyStore keyStore;
            try {
                keyStore = KeyStore.getInstance(keyStoreType);
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (firstGetInstanceException != null) continue;
                firstGetInstanceException = new CertificateException(SSLMessages.ERR_JVM_DEFAULT_TRUST_MANAGER_CANNOT_INSTANTIATE_KEYSTORE.get(keyStoreType, StaticUtils.getExceptionMessage(e)), e);
                continue;
            }
            try (FileInputStream inputStream = new FileInputStream(f);){
                keyStore.load(inputStream, null);
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (firstLoadException != null) continue;
                firstLoadException = new CertificateException(SSLMessages.ERR_JVM_DEFAULT_TRUST_MANAGER_CANNOT_ERROR_LOADING_KEYSTORE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
                continue;
            }
            return keyStore;
        }
        if (firstLoadException != null) {
            throw firstLoadException;
        }
        throw firstGetInstanceException;
    }

    void checkTrusted(X509Certificate[] chain) throws CertificateException {
        if (this.certificateException != null) {
            throw this.certificateException;
        }
        if (chain == null || chain.length == 0) {
            throw new CertificateException(SSLMessages.ERR_JVM_DEFAULT_TRUST_MANAGER_NO_CERTS_IN_CHAIN.get());
        }
        boolean foundIssuer = false;
        Date currentTime = new Date();
        for (X509Certificate cert : chain) {
            Date notBefore = cert.getNotBefore();
            if (currentTime.before(notBefore)) {
                throw new CertificateNotYetValidException(SSLMessages.ERR_JVM_DEFAULT_TRUST_MANAGER_CERT_NOT_YET_VALID.get(JVMDefaultTrustManager.chainToString(chain), String.valueOf(cert.getSubjectDN()), String.valueOf(notBefore)));
            }
            Date notAfter = cert.getNotAfter();
            if (currentTime.after(notAfter)) {
                throw new CertificateExpiredException(SSLMessages.ERR_JVM_DEFAULT_TRUST_MANAGER_CERT_EXPIRED.get(JVMDefaultTrustManager.chainToString(chain), String.valueOf(cert.getSubjectDN()), String.valueOf(notAfter)));
            }
            ASN1OctetString signature = new ASN1OctetString(cert.getSignature());
            foundIssuer |= this.trustedCertificateMap.get(signature) != null;
        }
        if (!foundIssuer) {
            throw new CertificateException(SSLMessages.ERR_JVM_DEFAULT_TRUST_MANGER_NO_TRUSTED_ISSUER_FOUND.get(JVMDefaultTrustManager.chainToString(chain)));
        }
    }

    static String chainToString(X509Certificate[] chain) {
        StringBuilder buffer = new StringBuilder();
        switch (chain.length) {
            case 0: {
                break;
            }
            case 1: {
                buffer.append('\'');
                buffer.append(chain[0].getSubjectDN());
                buffer.append('\'');
                break;
            }
            case 2: {
                buffer.append('\'');
                buffer.append(chain[0].getSubjectDN());
                buffer.append("' and '");
                buffer.append(chain[1].getSubjectDN());
                buffer.append('\'');
                break;
            }
            default: {
                for (int i = 0; i < chain.length; ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    if (i == chain.length - 1) {
                        buffer.append("and ");
                    }
                    buffer.append('\'');
                    buffer.append(chain[i].getSubjectDN());
                    buffer.append('\'');
                }
            }
        }
        return buffer.toString();
    }
}

