/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionInternals;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPRequest;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.extensions.CancelExtendedRequest;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.logging.Level;
import javax.net.ssl.SSLSocketFactory;

@InternalUseOnly
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class InternalSDKHelper {
    private InternalSDKHelper() {
    }

    public static int getSoTimeout(LDAPConnection connection) throws LDAPException {
        try {
            return connection.getConnectionInternals(true).getSocket().getSoTimeout();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_INTERNAL_SDK_HELPER_CANNOT_GET_SO_TIMEOUT.get(String.valueOf(connection), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @InternalUseOnly
    public static void setSoTimeout(LDAPConnection connection, int soTimeout) throws LDAPException {
        if (Debug.debugEnabled()) {
            Debug.debug(Level.INFO, DebugType.CONNECT, "Setting the SO_TIMEOUT value for connection " + connection + " to " + soTimeout + "ms.");
        }
        try {
            LDAPConnectionInternals internals;
            if (connection != null && (internals = connection.getConnectionInternals(false)) != null) {
                internals.getSocket().setSoTimeout(soTimeout);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_INTERNAL_SDK_HELPER_CANNOT_SET_SO_TIMEOUT.get(String.valueOf(connection), soTimeout, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @InternalUseOnly
    public static void convertToTLS(LDAPConnection connection, SSLSocketFactory sslSocketFactory) throws LDAPException {
        connection.convertToTLS(sslSocketFactory);
    }

    @InternalUseOnly
    public static AsyncRequestID createAsyncRequestID(int targetMessageID, LDAPConnection connection) {
        return new AsyncRequestID(targetMessageID, connection);
    }

    @InternalUseOnly
    public static void cancel(LDAPConnection connection, int targetMessageID, Control ... controls) throws LDAPException {
        int messageID = connection.nextMessageID();
        CancelExtendedRequest cancelRequest = new CancelExtendedRequest(targetMessageID);
        Debug.debugLDAPRequest(Level.INFO, cancelRequest, messageID, connection);
        connection.sendMessage(new LDAPMessage(messageID, (ProtocolOp)new ExtendedRequest(cancelRequest), controls), connection.getConnectionOptions().getExtendedOperationResponseTimeoutMillis("1.3.6.1.1.8"));
    }

    @InternalUseOnly
    public static LDAPResult readLDAPResultFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        return LDAPResult.readLDAPResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    public static BindResult readBindResultFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        return BindResult.readBindResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    public static CompareResult readCompareResultFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        return CompareResult.readCompareResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    public static ExtendedResult readExtendedResultFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        return ExtendedResult.readExtendedResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    public static SearchResultEntry readSearchResultEntryFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader, Schema schema) throws LDAPException {
        return SearchResultEntry.readSearchEntryFrom(messageID, messageSequence, reader, schema);
    }

    @InternalUseOnly
    public static SearchResultReference readSearchResultReferenceFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        return SearchResultReference.readSearchReferenceFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    public static SearchResult readSearchResultFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        return SearchResult.readSearchResultFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    public static IntermediateResponse readIntermediateResponseFrom(int messageID, ASN1StreamReaderSequence messageSequence, ASN1StreamReader reader) throws LDAPException {
        return IntermediateResponse.readFrom(messageID, messageSequence, reader);
    }

    @InternalUseOnly
    public static Boolean followReferralsInternal(LDAPRequest request) {
        return request.followReferralsInternal();
    }

    @InternalUseOnly
    public static int nextMessageID(LDAPConnection connection) {
        return connection.nextMessageID();
    }

    @InternalUseOnly
    public static BindRequest getLastBindRequest(LDAPConnection connection) {
        return connection.getLastBindRequest();
    }

    @InternalUseOnly
    public static Schema getEntrySchema(Entry entry) {
        return entry.getSchema();
    }
}

