/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class BackupTask
extends Task {
    static final String BACKUP_TASK_CLASS = "com.unboundid.directory.server.tasks.BackupTask";
    private static final String ATTR_BACKEND_ID = "ds-task-backup-backend-id";
    private static final String ATTR_BACKUP_ALL = "ds-task-backup-all";
    private static final String ATTR_BACKUP_DIRECTORY = "ds-backup-directory-path";
    private static final String ATTR_BACKUP_ID = "ds-backup-id";
    private static final String ATTR_COMPRESS = "ds-task-backup-compress";
    private static final String ATTR_ENCRYPT = "ds-task-backup-encrypt";
    private static final String ATTR_ENCRYPTION_PASSPHRASE_FILE = "ds-task-backup-encryption-passphrase-file";
    private static final String ATTR_ENCRYPTION_SETTINGS_DEFINITION_ID = "ds-task-backup-encryption-settings-definition-id";
    private static final String ATTR_HASH = "ds-task-backup-hash";
    private static final String ATTR_INCREMENTAL = "ds-task-backup-incremental";
    private static final String ATTR_INCREMENTAL_BASE_ID = "ds-task-backup-incremental-base-id";
    private static final String ATTR_MAX_MEGABYTES_PER_SECOND = "ds-task-backup-max-megabytes-per-second";
    private static final String ATTR_RETAIN_PREVIOUS_FULL_BACKUP_AGE = "ds-task-backup-retain-previous-full-backup-age";
    private static final String ATTR_RETAIN_PREVIOUS_FULL_BACKUP_COUNT = "ds-task-backup-retain-previous-full-backup-count";
    private static final String ATTR_SIGN_HASH = "ds-task-backup-sign-hash";
    private static final String OC_BACKUP_TASK = "ds-task-backup";
    private static final TaskProperty PROPERTY_BACKUP_DIRECTORY = new TaskProperty("ds-backup-directory-path", TaskMessages.INFO_DISPLAY_NAME_BACKUP_DIRECTORY.get(), TaskMessages.INFO_DESCRIPTION_BACKUP_DIRECTORY_BACKUP.get(), String.class, true, false, false);
    private static final TaskProperty PROPERTY_BACKEND_ID = new TaskProperty("ds-task-backup-backend-id", TaskMessages.INFO_DISPLAY_NAME_BACKEND_ID.get(), TaskMessages.INFO_DESCRIPTION_BACKEND_ID_BACKUP.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_BACKUP_ID = new TaskProperty("ds-backup-id", TaskMessages.INFO_DISPLAY_NAME_BACKUP_ID.get(), TaskMessages.INFO_DESCRIPTION_BACKUP_ID_BACKUP.get(), String.class, false, false, true);
    private static final TaskProperty PROPERTY_INCREMENTAL = new TaskProperty("ds-task-backup-incremental", TaskMessages.INFO_DISPLAY_NAME_INCREMENTAL.get(), TaskMessages.INFO_DESCRIPTION_INCREMENTAL.get(), Boolean.class, false, false, false);
    private static final TaskProperty PROPERTY_INCREMENTAL_BASE_ID = new TaskProperty("ds-task-backup-incremental-base-id", TaskMessages.INFO_DISPLAY_NAME_INCREMENTAL_BASE_ID.get(), TaskMessages.INFO_DESCRIPTION_INCREMENTAL_BASE_ID.get(), String.class, false, false, true);
    private static final TaskProperty PROPERTY_COMPRESS = new TaskProperty("ds-task-backup-compress", TaskMessages.INFO_DISPLAY_NAME_COMPRESS.get(), TaskMessages.INFO_DESCRIPTION_COMPRESS_BACKUP.get(), Boolean.class, false, false, false);
    private static final TaskProperty PROPERTY_ENCRYPT = new TaskProperty("ds-task-backup-encrypt", TaskMessages.INFO_DISPLAY_NAME_ENCRYPT.get(), TaskMessages.INFO_DESCRIPTION_ENCRYPT_BACKUP.get(), Boolean.class, false, false, false);
    private static final TaskProperty PROPERTY_ENCRYPTION_PASSPHRASE_FILE = new TaskProperty("ds-task-backup-encryption-passphrase-file", TaskMessages.INFO_DISPLAY_NAME_ENCRYPTION_PASSPHRASE_FILE.get(), TaskMessages.INFO_DESCRIPTION_ENCRYPTION_PASSPHRASE_FILE.get(), String.class, false, false, true);
    private static final TaskProperty PROPERTY_ENCRYPTION_SETTINGS_DEFINITION_ID = new TaskProperty("ds-task-backup-encryption-settings-definition-id", TaskMessages.INFO_DISPLAY_NAME_ENCRYPTION_SETTINGS_DEFINITION_ID.get(), TaskMessages.INFO_DESCRIPTION_ENCRYPTION_SETTINGS_DEFINITION_ID.get(), String.class, false, false, true);
    private static final TaskProperty PROPERTY_HASH = new TaskProperty("ds-task-backup-hash", TaskMessages.INFO_DISPLAY_NAME_HASH.get(), TaskMessages.INFO_DESCRIPTION_HASH_BACKUP.get(), Boolean.class, false, false, false);
    private static final TaskProperty PROPERTY_SIGN_HASH = new TaskProperty("ds-task-backup-sign-hash", TaskMessages.INFO_DISPLAY_NAME_SIGN_HASH.get(), TaskMessages.INFO_DESCRIPTION_SIGN_HASH_BACKUP.get(), Boolean.class, false, false, false);
    private static final TaskProperty PROPERTY_MAX_MEGABYTES_PER_SECOND = new TaskProperty("ds-task-backup-max-megabytes-per-second", TaskMessages.INFO_DISPLAY_NAME_BACKUP_MAX_MEGABYTES_PER_SECOND.get(), TaskMessages.INFO_DESCRIPTION_BACKUP_MAX_MEGABYTES_PER_SECOND.get(), Long.class, false, false, true);
    private static final TaskProperty PROPERTY_RETAIN_PREVIOUS_FULL_BACKUP_AGE = new TaskProperty("ds-task-backup-retain-previous-full-backup-age", TaskMessages.INFO_DISPLAY_NAME_BACKUP_RETAIN_AGE.get(), TaskMessages.INFO_DESCRIPTION_BACKUP_RETAIN_AGE.get(), String.class, false, false, true);
    private static final TaskProperty PROPERTY_RETAIN_PREVIOUS_FULL_BACKUP_COUNT = new TaskProperty("ds-task-backup-retain-previous-full-backup-count", TaskMessages.INFO_DISPLAY_NAME_BACKUP_RETAIN_COUNT.get(), TaskMessages.INFO_DESCRIPTION_BACKUP_RETAIN_COUNT.get(), Long.class, false, false, true);
    private static final long serialVersionUID = 2637190942057174423L;
    private final boolean compress;
    private final boolean encrypt;
    private final boolean hash;
    private final boolean signHash;
    private final boolean incremental;
    private final Integer maxMegabytesPerSecond;
    private final Integer retainPreviousFullBackupCount;
    private final List<String> backendIDs;
    private final String backupDirectory;
    private final String backupID;
    private final String encryptionPassphraseFile;
    private final String encryptionSettingsDefinitionID;
    private final String incrementalBaseID;
    private final String retainPreviousFullBackupAge;

    public BackupTask() {
        this.compress = false;
        this.encrypt = false;
        this.hash = false;
        this.signHash = false;
        this.incremental = false;
        this.maxMegabytesPerSecond = null;
        this.retainPreviousFullBackupCount = null;
        this.backendIDs = null;
        this.backupDirectory = null;
        this.backupID = null;
        this.encryptionPassphraseFile = null;
        this.encryptionSettingsDefinitionID = null;
        this.incrementalBaseID = null;
        this.retainPreviousFullBackupAge = null;
    }

    public BackupTask(String taskID, String backupDirectory, String backendID) {
        this(taskID, backupDirectory, backendID == null ? null : Arrays.asList(backendID), null, false, null, false, false, false, false, null, null, null, null, null);
    }

    public BackupTask(String taskID, String backupDirectory, List<String> backendIDs, String backupID, boolean incremental, String incrementalBaseID, boolean compress, boolean encrypt, boolean hash, boolean signHash, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        this(taskID, backupDirectory, backendIDs, backupID, incremental, incrementalBaseID, compress, encrypt, null, null, hash, signHash, null, null, null, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
    }

    public BackupTask(String taskID, String backupDirectory, List<String> backendIDs, String backupID, boolean incremental, String incrementalBaseID, boolean compress, boolean encrypt, String encryptionPassphraseFile, String encryptionSettingsDefinitionID, boolean hash, boolean signHash, Integer maxMegabytesPerSecond, Integer retainPreviousFullBackupCount, String retainPreviousFullBackupAge, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        super(taskID, BACKUP_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
        Validator.ensureNotNull(backupDirectory);
        this.backupDirectory = backupDirectory;
        this.backupID = backupID;
        this.incremental = incremental;
        this.incrementalBaseID = incrementalBaseID;
        this.compress = compress;
        this.encrypt = encrypt;
        this.encryptionPassphraseFile = encryptionPassphraseFile;
        this.encryptionSettingsDefinitionID = encryptionSettingsDefinitionID;
        this.hash = hash;
        this.signHash = signHash;
        this.maxMegabytesPerSecond = maxMegabytesPerSecond;
        this.retainPreviousFullBackupCount = retainPreviousFullBackupCount;
        this.retainPreviousFullBackupAge = retainPreviousFullBackupAge;
        this.backendIDs = backendIDs == null ? Collections.emptyList() : Collections.unmodifiableList(backendIDs);
    }

    public BackupTask(Entry entry) throws TaskException {
        super(entry);
        this.backupDirectory = entry.getAttributeValue(ATTR_BACKUP_DIRECTORY);
        if (this.backupDirectory == null) {
            throw new TaskException(TaskMessages.ERR_BACKUP_NO_BACKUP_DIRECTORY.get(this.getTaskEntryDN()));
        }
        this.backendIDs = BackupTask.parseStringList(entry, ATTR_BACKEND_ID);
        this.backupID = entry.getAttributeValue(ATTR_BACKUP_ID);
        this.incremental = BackupTask.parseBooleanValue(entry, ATTR_INCREMENTAL, false);
        this.incrementalBaseID = entry.getAttributeValue(ATTR_INCREMENTAL_BASE_ID);
        this.compress = BackupTask.parseBooleanValue(entry, ATTR_COMPRESS, false);
        this.encrypt = BackupTask.parseBooleanValue(entry, ATTR_ENCRYPT, false);
        this.encryptionPassphraseFile = entry.getAttributeValue(ATTR_ENCRYPTION_PASSPHRASE_FILE);
        this.encryptionSettingsDefinitionID = entry.getAttributeValue(ATTR_ENCRYPTION_SETTINGS_DEFINITION_ID);
        this.hash = BackupTask.parseBooleanValue(entry, ATTR_HASH, false);
        this.signHash = BackupTask.parseBooleanValue(entry, ATTR_SIGN_HASH, false);
        this.maxMegabytesPerSecond = entry.getAttributeValueAsInteger(ATTR_MAX_MEGABYTES_PER_SECOND);
        this.retainPreviousFullBackupCount = entry.getAttributeValueAsInteger(ATTR_RETAIN_PREVIOUS_FULL_BACKUP_COUNT);
        this.retainPreviousFullBackupAge = entry.getAttributeValue(ATTR_RETAIN_PREVIOUS_FULL_BACKUP_AGE);
    }

    public BackupTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(BACKUP_TASK_CLASS, properties);
        boolean c = false;
        boolean e = false;
        boolean h = false;
        boolean i = false;
        boolean s = false;
        Integer maxMB = null;
        Integer retainCount = null;
        String bDir = null;
        String bkID = null;
        String incID = null;
        String encID = null;
        String encPWFile = null;
        String retainAge = null;
        String[] beIDs = StaticUtils.NO_STRINGS;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_BACKUP_DIRECTORY)) {
                bDir = BackupTask.parseString(p, values, bDir);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_BACKEND_ID)) {
                beIDs = BackupTask.parseStrings(p, values, beIDs);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_BACKUP_ID)) {
                bkID = BackupTask.parseString(p, values, bkID);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INCREMENTAL)) {
                i = BackupTask.parseBoolean(p, values, i);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INCREMENTAL_BASE_ID)) {
                incID = BackupTask.parseString(p, values, incID);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_COMPRESS)) {
                c = BackupTask.parseBoolean(p, values, c);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_ENCRYPT)) {
                e = BackupTask.parseBoolean(p, values, e);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_ENCRYPTION_PASSPHRASE_FILE)) {
                encPWFile = BackupTask.parseString(p, values, encPWFile);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_ENCRYPTION_SETTINGS_DEFINITION_ID)) {
                encID = BackupTask.parseString(p, values, encID);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_HASH)) {
                h = BackupTask.parseBoolean(p, values, h);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_SIGN_HASH)) {
                s = BackupTask.parseBoolean(p, values, s);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_MAX_MEGABYTES_PER_SECOND)) {
                Long maxMBLong = BackupTask.parseLong(p, values, null);
                if (maxMBLong == null) {
                    maxMB = null;
                    continue;
                }
                maxMB = maxMBLong.intValue();
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_RETAIN_PREVIOUS_FULL_BACKUP_COUNT)) {
                Long retainCountLong = BackupTask.parseLong(p, values, null);
                if (retainCountLong == null) {
                    retainCount = null;
                    continue;
                }
                retainCount = retainCountLong.intValue();
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_RETAIN_PREVIOUS_FULL_BACKUP_AGE)) continue;
            retainAge = BackupTask.parseString(p, values, retainAge);
        }
        if (bDir == null) {
            throw new TaskException(TaskMessages.ERR_BACKUP_NO_BACKUP_DIRECTORY.get(this.getTaskEntryDN()));
        }
        this.backupDirectory = bDir;
        this.backendIDs = Arrays.asList(beIDs);
        this.backupID = bkID;
        this.incremental = i;
        this.incrementalBaseID = incID;
        this.compress = c;
        this.encrypt = e;
        this.encryptionPassphraseFile = encPWFile;
        this.encryptionSettingsDefinitionID = encID;
        this.hash = h;
        this.signHash = s;
        this.maxMegabytesPerSecond = maxMB;
        this.retainPreviousFullBackupCount = retainCount;
        this.retainPreviousFullBackupAge = retainAge;
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_BACKUP.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_BACKUP.get();
    }

    public String getBackupDirectory() {
        return this.backupDirectory;
    }

    public boolean backupAll() {
        return this.backendIDs.isEmpty();
    }

    public List<String> getBackendIDs() {
        return this.backendIDs;
    }

    public String getBackupID() {
        return this.backupID;
    }

    public boolean incremental() {
        return this.incremental;
    }

    public String getIncrementalBaseID() {
        return this.incrementalBaseID;
    }

    public boolean compress() {
        return this.compress;
    }

    public boolean encrypt() {
        return this.encrypt;
    }

    public String getEncryptionPassphraseFile() {
        return this.encryptionPassphraseFile;
    }

    public String getEncryptionSettingsDefinitionID() {
        return this.encryptionSettingsDefinitionID;
    }

    public boolean hash() {
        return this.hash;
    }

    public boolean signHash() {
        return this.signHash;
    }

    public Integer getMaxMegabytesPerSecond() {
        return this.maxMegabytesPerSecond;
    }

    public Integer getRetainPreviousFullBackupCount() {
        return this.retainPreviousFullBackupCount;
    }

    public String getRetainPreviousFullBackupAge() {
        return this.retainPreviousFullBackupAge;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Arrays.asList(OC_BACKUP_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(20);
        attrs.add(new Attribute(ATTR_BACKUP_DIRECTORY, this.backupDirectory));
        attrs.add(new Attribute(ATTR_INCREMENTAL, String.valueOf(this.incremental)));
        attrs.add(new Attribute(ATTR_COMPRESS, String.valueOf(this.compress)));
        attrs.add(new Attribute(ATTR_ENCRYPT, String.valueOf(this.encrypt)));
        attrs.add(new Attribute(ATTR_HASH, String.valueOf(this.hash)));
        attrs.add(new Attribute(ATTR_SIGN_HASH, String.valueOf(this.signHash)));
        if (this.backendIDs.isEmpty()) {
            attrs.add(new Attribute(ATTR_BACKUP_ALL, "true"));
        } else {
            attrs.add(new Attribute(ATTR_BACKEND_ID, this.backendIDs));
        }
        if (this.backupID != null) {
            attrs.add(new Attribute(ATTR_BACKUP_ID, this.backupID));
        }
        if (this.incrementalBaseID != null) {
            attrs.add(new Attribute(ATTR_INCREMENTAL_BASE_ID, this.incrementalBaseID));
        }
        if (this.encryptionPassphraseFile != null) {
            attrs.add(new Attribute(ATTR_ENCRYPTION_PASSPHRASE_FILE, this.encryptionPassphraseFile));
        }
        if (this.encryptionSettingsDefinitionID != null) {
            attrs.add(new Attribute(ATTR_ENCRYPTION_SETTINGS_DEFINITION_ID, this.encryptionSettingsDefinitionID));
        }
        if (this.maxMegabytesPerSecond != null) {
            attrs.add(new Attribute(ATTR_MAX_MEGABYTES_PER_SECOND, String.valueOf(this.maxMegabytesPerSecond)));
        }
        if (this.retainPreviousFullBackupCount != null) {
            attrs.add(new Attribute(ATTR_RETAIN_PREVIOUS_FULL_BACKUP_COUNT, String.valueOf(this.retainPreviousFullBackupCount)));
        }
        if (this.retainPreviousFullBackupAge != null) {
            attrs.add(new Attribute(ATTR_RETAIN_PREVIOUS_FULL_BACKUP_AGE, this.retainPreviousFullBackupAge));
        }
        return attrs;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        List<TaskProperty> propList = Arrays.asList(PROPERTY_BACKUP_DIRECTORY, PROPERTY_BACKEND_ID, PROPERTY_BACKUP_ID, PROPERTY_INCREMENTAL, PROPERTY_INCREMENTAL_BASE_ID, PROPERTY_COMPRESS, PROPERTY_ENCRYPT, PROPERTY_ENCRYPTION_PASSPHRASE_FILE, PROPERTY_ENCRYPTION_SETTINGS_DEFINITION_ID, PROPERTY_HASH, PROPERTY_SIGN_HASH, PROPERTY_MAX_MEGABYTES_PER_SECOND, PROPERTY_RETAIN_PREVIOUS_FULL_BACKUP_COUNT, PROPERTY_RETAIN_PREVIOUS_FULL_BACKUP_AGE);
        return Collections.unmodifiableList(propList);
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>();
        props.put(PROPERTY_BACKUP_DIRECTORY, Collections.unmodifiableList(Arrays.asList(this.backupDirectory)));
        props.put(PROPERTY_BACKEND_ID, Collections.unmodifiableList(this.backendIDs));
        if (this.backupID == null) {
            props.put(PROPERTY_BACKUP_ID, Collections.emptyList());
        } else {
            props.put(PROPERTY_BACKUP_ID, Collections.unmodifiableList(Arrays.asList(this.backupID)));
        }
        props.put(PROPERTY_INCREMENTAL, Collections.unmodifiableList(Arrays.asList(this.incremental)));
        if (this.incrementalBaseID == null) {
            props.put(PROPERTY_INCREMENTAL_BASE_ID, Collections.emptyList());
        } else {
            props.put(PROPERTY_INCREMENTAL_BASE_ID, Collections.unmodifiableList(Arrays.asList(this.incrementalBaseID)));
        }
        props.put(PROPERTY_COMPRESS, Collections.unmodifiableList(Arrays.asList(this.compress)));
        props.put(PROPERTY_ENCRYPT, Collections.unmodifiableList(Arrays.asList(this.encrypt)));
        if (this.encryptionPassphraseFile == null) {
            props.put(PROPERTY_ENCRYPTION_PASSPHRASE_FILE, Collections.emptyList());
        } else {
            props.put(PROPERTY_ENCRYPTION_PASSPHRASE_FILE, Collections.unmodifiableList(Arrays.asList(this.encryptionPassphraseFile)));
        }
        if (this.encryptionSettingsDefinitionID == null) {
            props.put(PROPERTY_ENCRYPTION_SETTINGS_DEFINITION_ID, Collections.emptyList());
        } else {
            props.put(PROPERTY_ENCRYPTION_SETTINGS_DEFINITION_ID, Collections.unmodifiableList(Arrays.asList(this.encryptionSettingsDefinitionID)));
        }
        props.put(PROPERTY_HASH, Collections.unmodifiableList(Arrays.asList(this.hash)));
        props.put(PROPERTY_SIGN_HASH, Collections.unmodifiableList(Arrays.asList(this.signHash)));
        if (this.maxMegabytesPerSecond == null) {
            props.put(PROPERTY_MAX_MEGABYTES_PER_SECOND, Collections.emptyList());
        } else {
            props.put(PROPERTY_MAX_MEGABYTES_PER_SECOND, Collections.unmodifiableList(Arrays.asList(this.maxMegabytesPerSecond.longValue())));
        }
        if (this.retainPreviousFullBackupCount == null) {
            props.put(PROPERTY_RETAIN_PREVIOUS_FULL_BACKUP_COUNT, Collections.emptyList());
        } else {
            props.put(PROPERTY_RETAIN_PREVIOUS_FULL_BACKUP_COUNT, Collections.unmodifiableList(Arrays.asList(this.retainPreviousFullBackupCount.longValue())));
        }
        if (this.retainPreviousFullBackupAge == null) {
            props.put(PROPERTY_RETAIN_PREVIOUS_FULL_BACKUP_AGE, Collections.emptyList());
        } else {
            props.put(PROPERTY_RETAIN_PREVIOUS_FULL_BACKUP_AGE, Collections.unmodifiableList(Arrays.asList(this.retainPreviousFullBackupAge)));
        }
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

