/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.persist;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.persist.DefaultObjectEncoder;
import com.unboundid.ldap.sdk.persist.FieldInfo;
import com.unboundid.ldap.sdk.persist.FilterUsage;
import com.unboundid.ldap.sdk.persist.LDAPEntryField;
import com.unboundid.ldap.sdk.persist.LDAPField;
import com.unboundid.ldap.sdk.persist.LDAPObject;
import com.unboundid.ldap.sdk.persist.LDAPObjectHandler;
import com.unboundid.ldap.sdk.persist.LDAPPersistException;
import com.unboundid.ldap.sdk.persist.LDAPPersister;
import com.unboundid.ldap.sdk.persist.PersistFilterType;
import com.unboundid.ldap.sdk.persist.PersistMessages;
import com.unboundid.ldap.sdk.persist.PersistUtils;
import com.unboundid.ldap.sdk.persist.PersistedObjects;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassType;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.StringArgument;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import java.util.TreeSet;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class GenerateSourceFromSchema
extends LDAPCommandLineTool
implements Serializable {
    private static final long serialVersionUID = 3488976364950590266L;
    @NotNull
    private static final TreeSet<String> EMPTY_TREE_SET = new TreeSet();
    @Nullable
    private BooleanArgument terseArg;
    @Nullable
    private DNArgument defaultParentDNArg;
    @Nullable
    private FileArgument outputDirectoryArg;
    @Nullable
    private StringArgument auxiliaryClassArg;
    @Nullable
    private StringArgument classNameArg;
    @Nullable
    private StringArgument lazyAttributeArg;
    @Nullable
    private StringArgument operationalAttributeArg;
    @Nullable
    private StringArgument packageNameArg;
    @Nullable
    private StringArgument rdnAttributeArg;
    @Nullable
    private StringArgument structuralClassArg;
    private boolean needArrays = false;
    private boolean needDate = false;
    private boolean needDN = false;
    private boolean needPersistedObjects = false;

    public static void main(@NotNull String[] args) {
        ResultCode resultCode = GenerateSourceFromSchema.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@NotNull String[] args, @Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        GenerateSourceFromSchema tool = new GenerateSourceFromSchema(outStream, errStream);
        return tool.runTool(args);
    }

    public GenerateSourceFromSchema(@Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "generate-source-from-schema";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return PersistMessages.INFO_GEN_SOURCE_TOOL_DESCRIPTION.get();
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.5";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    protected boolean supportsSSLDebugging() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.outputDirectoryArg = new FileArgument(Character.valueOf('d'), "outputDirectory", false, 1, PersistMessages.INFO_GEN_SOURCE_VALUE_PLACEHOLDER_PATH.get(), PersistMessages.INFO_GEN_SOURCE_ARG_DESCRIPTION_OUTPUT_DIRECTORY.get(), true, true, false, true);
        this.outputDirectoryArg.addLongIdentifier("output-directory", true);
        parser.addArgument(this.outputDirectoryArg);
        this.structuralClassArg = new StringArgument(Character.valueOf('s'), "structuralClass", true, 1, PersistMessages.INFO_GEN_SOURCE_VALUE_PLACEHOLDER_NAME.get(), PersistMessages.INFO_GEN_SOURCE_ARG_DESCRIPTION_STRUCTURAL_CLASS.get());
        this.structuralClassArg.addLongIdentifier("structural-class", true);
        parser.addArgument(this.structuralClassArg);
        this.auxiliaryClassArg = new StringArgument(Character.valueOf('a'), "auxiliaryClass", false, 0, PersistMessages.INFO_GEN_SOURCE_VALUE_PLACEHOLDER_NAME.get(), PersistMessages.INFO_GEN_SOURCE_ARG_DESCRIPTION_AUXILIARY_CLASS.get());
        this.auxiliaryClassArg.addLongIdentifier("auxiliary-class", true);
        parser.addArgument(this.auxiliaryClassArg);
        this.rdnAttributeArg = new StringArgument(Character.valueOf('r'), "rdnAttribute", true, 0, PersistMessages.INFO_GEN_SOURCE_VALUE_PLACEHOLDER_NAME.get(), PersistMessages.INFO_GEN_SOURCE_ARG_DESCRIPTION_RDN_ATTRIBUTE.get());
        this.rdnAttributeArg.addLongIdentifier("rdn-attribute", true);
        parser.addArgument(this.rdnAttributeArg);
        this.lazyAttributeArg = new StringArgument(Character.valueOf('l'), "lazyAttribute", false, 0, PersistMessages.INFO_GEN_SOURCE_VALUE_PLACEHOLDER_NAME.get(), PersistMessages.INFO_GEN_SOURCE_ARG_DESCRIPTION_LAZY_ATTRIBUTE.get());
        this.lazyAttributeArg.addLongIdentifier("lazy-attribute", true);
        parser.addArgument(this.lazyAttributeArg);
        this.operationalAttributeArg = new StringArgument(Character.valueOf('O'), "operationalAttribute", false, 0, PersistMessages.INFO_GEN_SOURCE_VALUE_PLACEHOLDER_NAME.get(), PersistMessages.INFO_GEN_SOURCE_ARG_DESCRIPTION_OPERATIONAL_ATTRIBUTE.get());
        this.operationalAttributeArg.addLongIdentifier("operational-attribute", true);
        parser.addArgument(this.operationalAttributeArg);
        this.defaultParentDNArg = new DNArgument(Character.valueOf('b'), "defaultParentDN", false, 1, PersistMessages.INFO_GEN_SOURCE_VALUE_PLACEHOLDER_DN.get(), PersistMessages.INFO_GEN_SOURCE_ARG_DESCRIPTION_DEFAULT_PARENT_DN.get());
        this.defaultParentDNArg.addLongIdentifier("default-parent-dn", true);
        parser.addArgument(this.defaultParentDNArg);
        this.packageNameArg = new StringArgument(Character.valueOf('n'), "packageName", false, 1, PersistMessages.INFO_GEN_SOURCE_VALUE_PLACEHOLDER_NAME.get(), PersistMessages.INFO_GEN_SOURCE_ARG_DESCRIPTION_PACKAGE_NAME.get());
        this.packageNameArg.addLongIdentifier("package-name", true);
        parser.addArgument(this.packageNameArg);
        this.classNameArg = new StringArgument(Character.valueOf('c'), "className", false, 1, PersistMessages.INFO_GEN_SOURCE_VALUE_PLACEHOLDER_NAME.get(), PersistMessages.INFO_GEN_SOURCE_ARG_DESCRIPTION_CLASS_NAME.get());
        this.classNameArg.addLongIdentifier("class-name", true);
        parser.addArgument(this.classNameArg);
        this.terseArg = new BooleanArgument(Character.valueOf('t'), "terse", 1, PersistMessages.INFO_GEN_SOURCE_ARG_DESCRIPTION_TERSE.get());
        parser.addArgument(this.terseArg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        Schema schema;
        LDAPConnection conn;
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.err(PersistMessages.ERR_GEN_SOURCE_CANNOT_CONNECT.get(StaticUtils.getExceptionMessage(le)));
            return le.getResultCode();
        }
        try {
            schema = conn.getSchema();
            if (schema == null) {
                this.err(PersistMessages.ERR_GEN_SOURCE_CANNOT_READ_SCHEMA.get(PersistMessages.ERR_GEN_SOURCE_SCHEMA_NOT_RETURNED.get()));
                ResultCode resultCode = ResultCode.NO_RESULTS_RETURNED;
                return resultCode;
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.err(PersistMessages.ERR_GEN_SOURCE_CANNOT_READ_SCHEMA.get(StaticUtils.getExceptionMessage(le)));
            ResultCode resultCode = le.getResultCode();
            return resultCode;
        }
        finally {
            conn.close();
        }
        return this.generateSourceFile(schema, this.terseArg.isPresent());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private ResultCode generateSourceFile(@NotNull Schema schema, boolean terse) {
        TreeSet<String> ocNames;
        AttributeTypeDefinition d;
        String ocName;
        Iterator iterator;
        String packageName;
        PrintWriter writer;
        void var15_32;
        TreeMap<String, AttributeTypeDefinition> requiredAttrs = new TreeMap<String, AttributeTypeDefinition>();
        TreeMap<String, AttributeTypeDefinition> optionalAttrs = new TreeMap<String, AttributeTypeDefinition>();
        TreeMap<String, TreeSet<String>> requiredAttrOCs = new TreeMap<String, TreeSet<String>>();
        TreeMap<String, TreeSet<String>> optionalAttrOCs = new TreeMap<String, TreeSet<String>>();
        TreeMap<String, String> types = new TreeMap<String, String>();
        String structuralClassName = this.structuralClassArg.getValue();
        ObjectClassDefinition structuralOC = schema.getObjectClass(structuralClassName);
        if (structuralOC == null) {
            this.err(PersistMessages.ERR_GEN_SOURCE_STRUCTURAL_CLASS_NOT_FOUND.get(structuralClassName));
            return ResultCode.PARAM_ERROR;
        }
        if (structuralOC.getObjectClassType(schema) != ObjectClassType.STRUCTURAL) {
            this.err(PersistMessages.ERR_GEN_SOURCE_STRUCTURAL_CLASS_NOT_STRUCTURAL.get(structuralClassName));
            return ResultCode.PARAM_ERROR;
        }
        this.processObjectClass(structuralOC, schema, requiredAttrs, requiredAttrOCs, optionalAttrs, optionalAttrOCs, types);
        TreeMap<String, ObjectClassDefinition> auxiliaryOCs = new TreeMap<String, ObjectClassDefinition>();
        if (this.auxiliaryClassArg.isPresent()) {
            for (String s : this.auxiliaryClassArg.getValues()) {
                ObjectClassDefinition objectClassDefinition = schema.getObjectClass(s);
                if (objectClassDefinition == null) {
                    this.err(PersistMessages.ERR_GEN_SOURCE_AUXILIARY_CLASS_NOT_FOUND.get(s));
                    return ResultCode.PARAM_ERROR;
                }
                if (objectClassDefinition.getObjectClassType(schema) != ObjectClassType.AUXILIARY) {
                    this.err(PersistMessages.ERR_GEN_SOURCE_AUXILIARY_CLASS_NOT_AUXILIARY.get(s));
                    return ResultCode.PARAM_ERROR;
                }
                auxiliaryOCs.put(StaticUtils.toLowerCase(s), objectClassDefinition);
                this.processObjectClass(objectClassDefinition, schema, requiredAttrs, requiredAttrOCs, optionalAttrs, optionalAttrOCs, types);
            }
        }
        TreeMap<String, ObjectClassDefinition> superiorOCs = new TreeMap<String, ObjectClassDefinition>();
        for (ObjectClassDefinition objectClassDefinition : structuralOC.getSuperiorClasses(schema, true)) {
            superiorOCs.put(StaticUtils.toLowerCase(objectClassDefinition.getNameOrOID()), objectClassDefinition);
        }
        for (ObjectClassDefinition objectClassDefinition : auxiliaryOCs.values()) {
            for (ObjectClassDefinition objectClassDefinition2 : objectClassDefinition.getSuperiorClasses(schema, true)) {
                superiorOCs.put(StaticUtils.toLowerCase(objectClassDefinition2.getNameOrOID()), objectClassDefinition2);
            }
        }
        superiorOCs.remove(StaticUtils.toLowerCase(structuralClassName));
        for (String string : auxiliaryOCs.keySet()) {
            superiorOCs.remove(string);
        }
        TreeMap<String, AttributeTypeDefinition> operationalAttrs = new TreeMap<String, AttributeTypeDefinition>();
        if (this.operationalAttributeArg.isPresent()) {
            for (String s : this.operationalAttributeArg.getValues()) {
                AttributeTypeDefinition attributeTypeDefinition = schema.getAttributeType(s);
                if (attributeTypeDefinition == null) {
                    this.err(PersistMessages.ERR_GEN_SOURCE_OPERATIONAL_ATTRIBUTE_NOT_DEFINED.get(s));
                    return ResultCode.PARAM_ERROR;
                }
                if (!attributeTypeDefinition.isOperational()) {
                    this.err(PersistMessages.ERR_GEN_SOURCE_OPERATIONAL_ATTRIBUTE_NOT_OPERATIONAL.get(s));
                    return ResultCode.PARAM_ERROR;
                }
                String lowerName = StaticUtils.toLowerCase(s);
                operationalAttrs.put(lowerName, attributeTypeDefinition);
                types.put(lowerName, this.getJavaType(schema, attributeTypeDefinition));
            }
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : this.rdnAttributeArg.getValues()) {
            AttributeTypeDefinition d4 = schema.getAttributeType(string);
            if (d4 == null) {
                this.err(PersistMessages.ERR_GEN_SOURCE_RDN_ATTRIBUTE_NOT_DEFINED.get(string));
                return ResultCode.PARAM_ERROR;
            }
            String lowerName = StaticUtils.toLowerCase(d4.getNameOrOID());
            treeSet.add(lowerName);
            if (requiredAttrs.containsKey(lowerName)) continue;
            if (optionalAttrs.containsKey(lowerName)) {
                requiredAttrs.put(lowerName, optionalAttrs.remove(lowerName));
                requiredAttrOCs.put(lowerName, optionalAttrOCs.remove(lowerName));
                continue;
            }
            this.err(PersistMessages.ERR_GEN_SOURCE_RDN_ATTRIBUTE_NOT_DEFINED.get(string));
            return ResultCode.PARAM_ERROR;
        }
        TreeSet<String> lazyAttrs = new TreeSet<String>();
        for (String s : this.lazyAttributeArg.getValues()) {
            AttributeTypeDefinition d5 = schema.getAttributeType(s);
            if (d5 == null) {
                this.err(PersistMessages.ERR_GEN_SOURCE_LAZY_ATTRIBUTE_NOT_DEFINED.get(s));
                return ResultCode.PARAM_ERROR;
            }
            String lowerName = StaticUtils.toLowerCase(d5.getNameOrOID());
            lazyAttrs.add(lowerName);
            if (requiredAttrs.containsKey(lowerName) || optionalAttrs.containsKey(lowerName) || operationalAttrs.containsKey(lowerName)) continue;
            this.err(PersistMessages.ERR_GEN_SOURCE_LAZY_ATTRIBUTE_NOT_ALLOWED.get(s));
            return ResultCode.PARAM_ERROR;
        }
        if (this.classNameArg.isPresent()) {
            StringBuilder invalidReason;
            String string = this.classNameArg.getValue();
            if (!PersistUtils.isValidJavaIdentifier(string, invalidReason = new StringBuilder())) {
                this.err(PersistMessages.ERR_GEN_SOURCE_INVALID_CLASS_NAME.get(string, invalidReason.toString()));
                return ResultCode.PARAM_ERROR;
            }
        } else {
            String string = StaticUtils.capitalize(PersistUtils.toJavaIdentifier(structuralClassName));
        }
        File sourceFile = new File(this.outputDirectoryArg.getValue(), (String)var15_32 + ".java");
        try {
            writer = new PrintWriter(new FileWriter(sourceFile));
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.err(PersistMessages.ERR_GEN_SOURCE_CANNOT_CREATE_WRITER.get(sourceFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
            return ResultCode.LOCAL_ERROR;
        }
        if (this.packageNameArg.isPresent() && !(packageName = this.packageNameArg.getValue()).isEmpty()) {
            writer.println("package " + packageName + ';');
            writer.println();
            writer.println();
            writer.println();
        }
        boolean javaImports = false;
        if (this.needArrays) {
            writer.println("import " + Arrays.class.getName() + ';');
            javaImports = true;
        }
        if (this.needDate) {
            writer.println("import " + Date.class.getName() + ';');
            javaImports = true;
        }
        if (javaImports) {
            writer.println();
        }
        if (this.needDN) {
            writer.println("import " + DN.class.getName() + ';');
        }
        writer.println("import " + Entry.class.getName() + ';');
        writer.println("import " + Filter.class.getName() + ';');
        if (this.needDN) {
            writer.println("import " + LDAPException.class.getName() + ';');
            writer.println("import " + LDAPInterface.class.getName() + ';');
        }
        writer.println("import " + ReadOnlyEntry.class.getName() + ';');
        writer.println("import " + DefaultObjectEncoder.class.getName() + ';');
        writer.println("import " + FieldInfo.class.getName() + ';');
        writer.println("import " + FilterUsage.class.getName() + ';');
        writer.println("import " + LDAPEntryField.class.getName() + ';');
        writer.println("import " + LDAPField.class.getName() + ';');
        writer.println("import " + LDAPObject.class.getName() + ';');
        writer.println("import " + LDAPObjectHandler.class.getName() + ';');
        writer.println("import " + LDAPPersister.class.getName() + ';');
        writer.println("import " + LDAPPersistException.class.getName() + ';');
        if (this.needPersistedObjects) {
            writer.println("import " + PersistedObjects.class.getName() + ';');
        }
        writer.println("import " + PersistFilterType.class.getName() + ';');
        if (this.needDN) {
            writer.println("import " + PersistUtils.class.getName() + ';');
        }
        writer.println();
        writer.println();
        writer.println();
        writer.println("/**");
        writer.println(" * This class provides an implementation of an object that can be used to");
        writer.println(" * represent " + structuralClassName + " objects in the directory.");
        writer.println(" * It was generated by the " + this.getToolName() + " tool provided with the");
        writer.println(" * UnboundID LDAP SDK for Java.  It may be customized as desired to better suit");
        writer.println(" * your needs.");
        writer.println(" */");
        writer.println("@LDAPObject(structuralClass=\"" + structuralClassName + "\",");
        switch (auxiliaryOCs.size()) {
            case 0: {
                break;
            }
            case 1: {
                writer.println("            auxiliaryClass=\"" + ((ObjectClassDefinition)auxiliaryOCs.values().iterator().next()).getNameOrOID() + "\",");
                break;
            }
            default: {
                iterator = auxiliaryOCs.values().iterator();
                writer.println("            auxiliaryClass={ \"" + ((ObjectClassDefinition)iterator.next()).getNameOrOID() + "\",");
                while (iterator.hasNext()) {
                    ocName = ((ObjectClassDefinition)iterator.next()).getNameOrOID();
                    if (iterator.hasNext()) {
                        writer.println("                             \"" + ocName + "\",");
                        continue;
                    }
                    writer.println("                             \"" + ocName + "\" },");
                }
                break block1;
            }
        }
        switch (superiorOCs.size()) {
            case 0: {
                break;
            }
            case 1: {
                writer.println("            superiorClass=\"" + ((ObjectClassDefinition)superiorOCs.values().iterator().next()).getNameOrOID() + "\",");
                break;
            }
            default: {
                iterator = superiorOCs.values().iterator();
                writer.println("            superiorClass={ \"" + ((ObjectClassDefinition)iterator.next()).getNameOrOID() + "\",");
                while (iterator.hasNext()) {
                    ocName = ((ObjectClassDefinition)iterator.next()).getNameOrOID();
                    if (iterator.hasNext()) {
                        writer.println("                             \"" + ocName + "\",");
                        continue;
                    }
                    writer.println("                             \"" + ocName + "\" },");
                }
                break block5;
            }
        }
        if (this.defaultParentDNArg.isPresent()) {
            writer.println("            defaultParentDN=\"" + this.defaultParentDNArg.getValue() + "\",");
        }
        writer.println("            postDecodeMethod=\"doPostDecode\",");
        writer.println("            postEncodeMethod=\"doPostEncode\")");
        writer.println("public class " + (String)var15_32);
        writer.println("{");
        if (!terse) {
            writer.println("  /*");
            writer.println("   * NOTE:  This class includes a number of annotation elements which are not");
            writer.println("   * required but have been provided to make it easier to edit the resulting");
            writer.println("   * source code.  If you want to exclude these unnecessary annotation");
            writer.println("   * elements, use the '--terse' command-line argument.");
            writer.println("   */");
            writer.println();
            writer.println();
            writer.println();
        }
        writer.println("  // The field to use to hold a read-only copy of the associated entry.");
        writer.println("  @LDAPEntryField()");
        writer.println("  private ReadOnlyEntry ldapEntry;");
        for (String lowerName : treeSet) {
            d = requiredAttrs.get(lowerName);
            ocNames = requiredAttrOCs.get(lowerName);
            GenerateSourceFromSchema.writeField(writer, d, types.get(lowerName), ocNames, true, true, structuralClassName, false, terse);
        }
        for (String lowerName : requiredAttrs.keySet()) {
            if (treeSet.contains(lowerName)) continue;
            d = requiredAttrs.get(lowerName);
            ocNames = requiredAttrOCs.get(lowerName);
            GenerateSourceFromSchema.writeField(writer, d, types.get(lowerName), ocNames, false, true, structuralClassName, lazyAttrs.contains(lowerName), terse);
        }
        for (String lowerName : optionalAttrs.keySet()) {
            d = optionalAttrs.get(lowerName);
            ocNames = optionalAttrOCs.get(lowerName);
            GenerateSourceFromSchema.writeField(writer, d, types.get(lowerName), ocNames, false, false, structuralClassName, lazyAttrs.contains(lowerName), terse);
        }
        for (String lowerName : operationalAttrs.keySet()) {
            d = (AttributeTypeDefinition)operationalAttrs.get(lowerName);
            ocNames = EMPTY_TREE_SET;
            GenerateSourceFromSchema.writeField(writer, d, types.get(lowerName), ocNames, false, false, structuralClassName, lazyAttrs.contains(lowerName), terse);
        }
        writer.println();
        writer.println();
        writer.println();
        writer.println("  /**");
        writer.println("   * Creates a new instance of this object.  All fields will be uninitialized,");
        writer.println("   * so the setter methods should be used to assign values to them.");
        writer.println("   */");
        writer.println("  public " + (String)var15_32 + "()");
        writer.println("  {");
        writer.println("    // No initialization will be performed by default.  Note that if you set");
        writer.println("    // values for any fields marked with an @LDAPField, @LDAPDNField, or");
        writer.println("    // @LDAPEntryField annotation, they will be overwritten in the course of");
        writer.println("    // decoding initializing this object from an LDAP entry.");
        writer.println("  }");
        writer.println();
        writer.println();
        writer.println();
        writer.println("  /**");
        writer.println("   * Creates a new " + (String)var15_32 + " object decoded");
        writer.println("   * from the provided entry.");
        writer.println("   *");
        writer.println("   * @param  entry  The entry to be decoded.");
        writer.println("   *");
        writer.println("   * @return  The decoded " + (String)var15_32 + " object.");
        writer.println("   *");
        writer.println("   * @throws  LDAPPersistException  If a problem occurs while attempting to");
        writer.println("   *                                decode the provided entry.");
        writer.println("   */");
        writer.println("  public static " + (String)var15_32 + " decode(final Entry entry)");
        writer.println("         throws LDAPPersistException");
        writer.println("  {");
        writer.println("    return getPersister().decode(entry);");
        writer.println("  }");
        writer.println("");
        writer.println("");
        writer.println("");
        writer.println("  /**");
        writer.println("   * Retrieves an {@code LDAPPersister} instance that may be used to interact");
        writer.println("   * with objects of this type.");
        writer.println("   *");
        writer.println("   * @return  An {@code LDAPPersister} instance that may be used to interact");
        writer.println("   *          with objects of this type.");
        writer.println("   *");
        writer.println("   * @throws  LDAPPersistException  If a problem occurs while creating the");
        writer.println("   *                                {@code LDAPPersister} instance.");
        writer.println("   */");
        writer.println("  public static LDAPPersister<" + (String)var15_32 + "> getPersister()");
        writer.println("         throws LDAPPersistException");
        writer.println("  {");
        writer.println("    return LDAPPersister.getInstance(" + (String)var15_32 + ".class);");
        writer.println("  }");
        writer.println();
        writer.println();
        writer.println();
        writer.println("  /**");
        writer.println("   * Performs any processing that may be necessary after initializing this");
        writer.println("   * object from an LDAP entry.");
        writer.println("   *");
        writer.println("   * @throws  LDAPPersistException  If there is a problem with the object after");
        writer.println("   *                                it has been decoded from an LDAP entry.");
        writer.println("   */");
        writer.println("  private void doPostDecode()");
        writer.println("          throws LDAPPersistException");
        writer.println("  {");
        writer.println("    // No processing is needed by default.  You may provide an implementation");
        writer.println("    // for this method if custom post-decode processing is needed.");
        writer.println("  }");
        writer.println();
        writer.println();
        writer.println();
        writer.println("  /**");
        writer.println("   * Performs any processing that may be necessary after encoding this object");
        writer.println("   * to an LDAP entry.");
        writer.println("   *");
        writer.println("   * @param  entry  The entry that has been generated.  It may be altered if");
        writer.println("   *                desired.");
        writer.println("   *");
        writer.println("   * @throws  LDAPPersistException  If the generated entry should not be used.");
        writer.println("   */");
        writer.println("  private void doPostEncode(final Entry entry)");
        writer.println("          throws LDAPPersistException");
        writer.println("  {");
        writer.println("    // No processing is needed by default.  You may provide an implementation");
        writer.println("    // for this method if custom post-encode processing is needed.");
        writer.println("  }");
        writer.println();
        writer.println();
        writer.println();
        writer.println("  /**");
        writer.println("   * Retrieves a read-only copy of the entry with which this object is");
        writer.println("   * associated, if it is available.  It will only be available if this object");
        writer.println("   * was decoded from or encoded to an LDAP entry.");
        writer.println("   *");
        writer.println("   * @return  A read-only copy of the entry with which this object is");
        writer.println("   *          associated, or {@code null} if it is not available.");
        writer.println("   */");
        writer.println("  public ReadOnlyEntry getLDAPEntry()");
        writer.println("  {");
        writer.println("    return ldapEntry;");
        writer.println("  }");
        writer.println();
        writer.println();
        writer.println();
        writer.println("  /**");
        writer.println("   * Retrieves the DN of the entry with which this object is associated, if it");
        writer.println("   * is available.  It will only be available if this object was decoded from or");
        writer.println("   * encoded to an LDAP entry.");
        writer.println("   *");
        writer.println("   * @return  The DN of the entry with which this object is associated, or");
        writer.println("   *          {@code null} if it is not available.");
        writer.println("   */");
        writer.println("  public String getLDAPEntryDN()");
        writer.println("  {");
        writer.println("    if (ldapEntry == null)");
        writer.println("    {");
        writer.println("      return null;");
        writer.println("    }");
        writer.println("    else");
        writer.println("    {");
        writer.println("      return ldapEntry.getDN();");
        writer.println("    }");
        writer.println("  }");
        for (String lowerName : treeSet) {
            d = requiredAttrs.get(lowerName);
            GenerateSourceFromSchema.writeFieldMethods(writer, d, types.get(lowerName), true);
        }
        for (String lowerName : requiredAttrs.keySet()) {
            if (treeSet.contains(lowerName)) continue;
            d = requiredAttrs.get(lowerName);
            GenerateSourceFromSchema.writeFieldMethods(writer, d, types.get(lowerName), true);
        }
        for (String lowerName : optionalAttrs.keySet()) {
            d = optionalAttrs.get(lowerName);
            GenerateSourceFromSchema.writeFieldMethods(writer, d, types.get(lowerName), true);
        }
        for (String lowerName : operationalAttrs.keySet()) {
            d = (AttributeTypeDefinition)operationalAttrs.get(lowerName);
            GenerateSourceFromSchema.writeFieldMethods(writer, d, types.get(lowerName), false);
        }
        GenerateSourceFromSchema.writeToString(writer, (String)var15_32, requiredAttrs.values(), optionalAttrs.values(), operationalAttrs.values());
        writer.println("}");
        writer.println();
        writer.close();
        return ResultCode.SUCCESS;
    }

    private void processObjectClass(@NotNull ObjectClassDefinition oc, @NotNull Schema s, @NotNull TreeMap<String, AttributeTypeDefinition> ra, @NotNull TreeMap<String, TreeSet<String>> rac, @NotNull TreeMap<String, AttributeTypeDefinition> oa, @NotNull TreeMap<String, TreeSet<String>> oac, @NotNull TreeMap<String, String> t) {
        TreeSet<Object> ocSet;
        String lowerName;
        for (AttributeTypeDefinition d : oc.getRequiredAttributes(s, true)) {
            if (d.hasNameOrOID("objectClass")) continue;
            lowerName = StaticUtils.toLowerCase(d.getNameOrOID());
            if (ra.containsKey(lowerName)) {
                rac.get(lowerName).add(oc.getNameOrOID());
                continue;
            }
            if (oa.containsKey(lowerName)) {
                oa.remove(lowerName);
                ra.put(lowerName, d);
                ocSet = oac.remove(lowerName);
                ocSet.add(oc.getNameOrOID());
                rac.put(lowerName, ocSet);
                continue;
            }
            ocSet = new TreeSet<String>();
            ocSet.add(oc.getNameOrOID());
            ra.put(lowerName, d);
            rac.put(lowerName, ocSet);
            t.put(lowerName, this.getJavaType(s, d));
        }
        for (AttributeTypeDefinition d : oc.getOptionalAttributes(s, true)) {
            if (d.hasNameOrOID("objectClass")) continue;
            lowerName = StaticUtils.toLowerCase(d.getNameOrOID());
            if (ra.containsKey(lowerName)) {
                rac.get(lowerName).add(oc.getNameOrOID());
                continue;
            }
            if (oa.containsKey(lowerName)) {
                oac.get(lowerName).add(oc.getNameOrOID());
                continue;
            }
            ocSet = new TreeSet();
            ocSet.add(oc.getNameOrOID());
            oa.put(lowerName, d);
            oac.put(lowerName, ocSet);
            t.put(lowerName, this.getJavaType(s, d));
        }
    }

    private static void writeField(@NotNull PrintWriter writer, @NotNull AttributeTypeDefinition d, @NotNull String type, @NotNull TreeSet<String> ocNames, boolean inRDN, boolean required, @NotNull String sc, boolean lazy, boolean terse) {
        String attrName = d.getNameOrOID();
        String fieldName = PersistUtils.toJavaIdentifier(attrName);
        writer.println();
        if (inRDN) {
            writer.println("  // The field used for RDN attribute " + attrName + '.');
        } else if (required) {
            writer.println("  // The field used for required attribute " + attrName + '.');
        } else if (d.isOperational()) {
            writer.println("  // The field used for operational attribute " + attrName + '.');
        } else {
            writer.println("  // The field used for optional attribute " + attrName + '.');
        }
        boolean added = false;
        if (terse && attrName.equalsIgnoreCase(fieldName)) {
            writer.print("  @LDAPField(");
        } else {
            writer.print("  @LDAPField(attribute=\"" + attrName + '\"');
            added = true;
        }
        if (!ocNames.isEmpty()) {
            if (ocNames.size() == 1) {
                if (!terse || !ocNames.iterator().next().equalsIgnoreCase(sc)) {
                    if (added) {
                        writer.println(",");
                        writer.print("             objectClass=\"" + ocNames.iterator().next() + '\"');
                    } else {
                        writer.println("objectClass=\"" + ocNames.iterator().next() + '\"');
                        added = true;
                    }
                }
            } else {
                Iterator<String> iterator = ocNames.iterator();
                if (added) {
                    writer.println(",");
                    writer.println("             objectClass={ \"" + iterator.next() + "\",");
                } else {
                    writer.println("objectClass={ \"" + iterator.next() + "\",");
                    added = true;
                }
                while (iterator.hasNext()) {
                    String name = iterator.next();
                    if (iterator.hasNext()) {
                        writer.println("                           \"" + name + "\",");
                        continue;
                    }
                    writer.print("                           \"" + name + "\" }");
                }
            }
        }
        if (inRDN) {
            if (added) {
                writer.println(",");
                writer.println("             inRDN=true,");
            } else {
                writer.println("inRDN=true,");
                added = true;
            }
            writer.print("             filterUsage=FilterUsage.ALWAYS_ALLOWED");
        } else if (!terse) {
            if (added) {
                writer.println(",");
                writer.print("             filterUsage=FilterUsage.CONDITIONALLY_ALLOWED");
            } else {
                writer.print("filterUsage=FilterUsage.CONDITIONALLY_ALLOWED");
                added = true;
            }
        }
        if (required) {
            if (added) {
                writer.println(",");
                writer.print("             requiredForEncode=true");
            } else {
                writer.print("requiredForEncode=true");
                added = true;
            }
        }
        if (d.isOperational()) {
            if (added) {
                writer.println(",");
                writer.println("             inAdd=false,");
            } else {
                writer.println("inAdd=false,");
                added = true;
            }
            writer.print("             inModify=false");
        }
        if (lazy) {
            if (added) {
                writer.println(",");
                writer.print("             lazilyLoad=true");
            } else {
                writer.print("lazilyLoad=true");
                added = true;
            }
        }
        writer.println(")");
        if (d.isSingleValued()) {
            writer.println("  private " + type + ' ' + fieldName + ';');
        } else {
            writer.println("  private " + type + "[] " + fieldName + ';');
        }
    }

    private static void writeFieldMethods(@NotNull PrintWriter writer, @NotNull AttributeTypeDefinition d, @NotNull String type, boolean addSetter) {
        writer.println();
        writer.println();
        writer.println();
        String attrName = d.getNameOrOID();
        String fieldName = PersistUtils.toJavaIdentifier(attrName);
        String capFieldName = StaticUtils.capitalize(fieldName);
        if (d.isSingleValued()) {
            if (type.equals("DN")) {
                writer.println("  /**");
                writer.println("   * Retrieves the first value for the field associated with the");
                writer.println("   * " + attrName + " attribute as a DN, if present.");
                writer.println("   *");
                writer.println("   * @return  The first value for the field associated with the");
                writer.println("   *          " + attrName + " attribute, or");
                writer.println("   *          {@code null} if the field does not have a value.");
                writer.println("   */");
                writer.println("  public DN get" + capFieldName + "DN()");
                writer.println("  {");
                writer.println("    return " + fieldName + ';');
                writer.println("  }");
                writer.println();
                writer.println();
                writer.println();
                writer.println("  /**");
                writer.println("   * Retrieves the object referenced by the DN held in the");
                writer.println("   * " + attrName + " attribute, if present.");
                writer.println("   *");
                writer.println("   * @param  <T>  The type of object to return.");
                writer.println("   *");
                writer.println("   * @param  connection  The connection to use to retrieve the entry.  It must");
                writer.println("   *                     not be {@code null}.");
                writer.println("   * @param  type        The type of object as which to decode the entry.  It");
                writer.println("   *                     must not be {@code null}, and the class must be marked");
                writer.println("   *                     with the {@code LDAPObject} annotation type.");
                writer.println("   *");
                writer.println("   * @return  The object decoded from the entry with the associated DN, or");
                writer.println("   *          {@code null} if the field does not have a value or the referenced");
                writer.println("   *          entry does not exist.");
                writer.println("   *");
                writer.println("   * @throws  LDAPException  If a problem occurs while attempting to retrieve");
                writer.println("   *                         the entry or decode it as an object of the");
                writer.println("   *                         specified type.");
                writer.println("   */");
                writer.println("  public <T> T get" + capFieldName + "Object(");
                writer.println("                    final LDAPInterface connection,");
                writer.println("                    final Class<T> type)");
                writer.println("         throws LDAPException");
                writer.println("  {");
                writer.println("    return PersistUtils.getEntryAsObject(" + fieldName + ',');
                writer.println("         type, connection);");
                writer.println("  }");
                if (addSetter) {
                    writer.println();
                    writer.println();
                    writer.println();
                    writer.println("  /**");
                    writer.println("   * Sets the value for the field associated with the");
                    writer.println("   * " + attrName + " attribute.");
                    writer.println("   *");
                    writer.println("   * @param  v  The value for the field associated with the");
                    writer.println("   *            " + attrName + " attribute.");
                    writer.println("   */");
                    writer.println("  public void set" + capFieldName + "(final DN v)");
                    writer.println("  {");
                    writer.println("    this." + fieldName + " = v;");
                    writer.println("  }");
                    writer.println();
                    writer.println();
                    writer.println();
                    writer.println("  /**");
                    writer.println("   * Sets the value for the field associated with the");
                    writer.println("   * " + attrName + " attribute.");
                    writer.println("   *");
                    writer.println("   * @param  v  The string representation of the value for the field associated");
                    writer.println("   *            with the " + attrName + " attribute.");
                    writer.println("   *");
                    writer.println("   * @throws  LDAPException  If the provided string cannot be parsed as a DN.");
                    writer.println("   */");
                    writer.println("  public void set" + capFieldName + "(final String v)");
                    writer.println("         throws LDAPException");
                    writer.println("  {");
                    writer.println("    if (v == null)");
                    writer.println("    {");
                    writer.println("      this." + fieldName + " = null;");
                    writer.println("    }");
                    writer.println("    else");
                    writer.println("    {");
                    writer.println("      this." + fieldName + " = new DN(v);");
                    writer.println("    }");
                    writer.println("  }");
                }
            } else {
                writer.println("  /**");
                writer.println("   * Retrieves the value for the field associated with the");
                writer.println("   * " + attrName + " attribute, if present.");
                writer.println("   *");
                writer.println("   * @return  The value for the field associated with the");
                writer.println("   *          " + attrName + " attribute, or");
                writer.println("   *          {@code null} if the field does not have a value.");
                writer.println("   */");
                writer.println("  public " + type + " get" + capFieldName + "()");
                writer.println("  {");
                writer.println("    return " + fieldName + ';');
                writer.println("  }");
                if (addSetter) {
                    writer.println();
                    writer.println();
                    writer.println();
                    writer.println("  /**");
                    writer.println("   * Sets the value for the field associated with the");
                    writer.println("   * " + attrName + " attribute.");
                    writer.println("   *");
                    writer.println("   * @param  v  The value for the field associated with the");
                    writer.println("   *            " + attrName + " attribute.");
                    writer.println("   */");
                    writer.println("  public void set" + capFieldName + "(final " + type + " v)");
                    writer.println("  {");
                    writer.println("    this." + fieldName + " = v;");
                    writer.println("  }");
                }
            }
        } else if (type.equals("DN")) {
            writer.println("  /**");
            writer.println("   * Retrieves the first value for the field associated with the");
            writer.println("   * " + attrName + " attribute as a DN, if present.");
            writer.println("   *");
            writer.println("   * @return  The first value for the field associated with the");
            writer.println("   *          " + attrName + " attribute, or");
            writer.println("   *          {@code null} if that attribute was not present in the entry or");
            writer.println("   *          does not have any values.");
            writer.println("   */");
            writer.println("  public DN getFirst" + capFieldName + "DN()");
            writer.println("  {");
            writer.println("    if ((" + fieldName + " == null) ||");
            writer.println("        (" + fieldName + ".length == 0))");
            writer.println("    {");
            writer.println("      return null;");
            writer.println("    }");
            writer.println("    else");
            writer.println("    {");
            writer.println("      return " + fieldName + "[0];");
            writer.println("    }");
            writer.println("  }");
            writer.println();
            writer.println();
            writer.println();
            writer.println("  /**");
            writer.println("   * Retrieves the values for the field associated with the");
            writer.println("   * " + attrName + " attribute as DNs, if present.");
            writer.println("   *");
            writer.println("   * @return  The values for the field associated with the");
            writer.println("   *          " + attrName + " attribute, or");
            writer.println("   *          {@code null} if that attribute was not present in the entry.");
            writer.println("   */");
            writer.println("  public DN[] get" + capFieldName + "DNs()");
            writer.println("  {");
            writer.println("    return " + fieldName + ';');
            writer.println("  }");
            writer.println();
            writer.println();
            writer.println();
            writer.println("  /**");
            writer.println("   * Retrieves the values for the field associated with the");
            writer.println("   * " + attrName + " attribute as objects of the " + "specified type,");
            writer.println("   * if present.");
            writer.println("   *");
            writer.println("   * @param  <T>  The type of object to return.");
            writer.println("   *");
            writer.println("   * @param  connection  The connection to use to retrieve the entries.  It");
            writer.println("   *                     must not be {@code null}.");
            writer.println("   * @param  type        The type of object as which the entries should be");
            writer.println("   *                     decoded.  It must not be {@code null}, and the class");
            writer.println("   *                     must be marked with the {@code LDAPObject} annotation");
            writer.println("   *                     type.");
            writer.println("   *");
            writer.println("   * @return  A {@code PersistedObjects} object that may be used to iterate");
            writer.println("   *          across the resulting objects.");
            writer.println("   *");
            writer.println("   * @throws  LDAPException  If the requested type cannot be used with the LDAP");
            writer.println("   *                         SDK persistence framework.");
            writer.println("   */");
            writer.println("  public <T> PersistedObjects<T> get" + capFieldName + "Objects(");
            writer.println("                                      final LDAPInterface connection,");
            writer.println("                                      final Class<T> type)");
            writer.println("         throws LDAPException");
            writer.println("  {");
            writer.println("    return PersistUtils.getEntriesAsObjects(" + fieldName + ',');
            writer.println("         type, connection);");
            writer.println("  }");
            if (addSetter) {
                writer.println();
                writer.println();
                writer.println();
                writer.println("  /**");
                writer.println("   * Sets the values for the field associated with the");
                writer.println("   * " + attrName + " attribute.");
                writer.println("   *");
                writer.println("   * @param  v  The values for the field associated with the");
                writer.println("   *            " + attrName + " attribute.");
                writer.println("   */");
                writer.println("  public void set" + capFieldName + "(final DN... v)");
                writer.println("  {");
                writer.println("    this." + fieldName + " = v;");
                writer.println("  }");
                writer.println();
                writer.println();
                writer.println();
                writer.println("  /**");
                writer.println("   * Sets the values for the field associated with the");
                writer.println("   * " + attrName + " attribute.");
                writer.println("   *");
                writer.println("   * @param  v  The string representations of the values for the field");
                writer.println("   *            associated with the " + attrName + " attribute.");
                writer.println("   *");
                writer.println("   * @throws  LDAPException  If any of the provided strings cannot be parsed as");
                writer.println("   *                         a DN.");
                writer.println("   */");
                writer.println("  public void set" + capFieldName + "(final String... v)");
                writer.println("         throws LDAPException");
                writer.println("  {");
                writer.println("    if (v == null)");
                writer.println("    {");
                writer.println("      this." + fieldName + " = null;");
                writer.println("    }");
                writer.println("    else");
                writer.println("    {");
                writer.println("      this." + fieldName + " = new DN[v.length];");
                writer.println("      for (int i=0; i < v.length; i++)");
                writer.println("      {");
                writer.println("        this." + fieldName + "[i] = new DN(v[i]);");
                writer.println("      }");
                writer.println("    }");
                writer.println("  }");
            }
        } else {
            writer.println("  /**");
            writer.println("   * Retrieves the first value for the field associated with the");
            writer.println("   * " + attrName + " attribute, if present.");
            writer.println("   *");
            writer.println("   * @return  The first value for the field associated with the");
            writer.println("   *          " + attrName + " attribute, or");
            writer.println("   *          {@code null} if that attribute was not present in the entry or");
            writer.println("   *          does not have any values.");
            writer.println("   */");
            writer.println("  public " + type + " getFirst" + capFieldName + "()");
            writer.println("  {");
            writer.println("    if ((" + fieldName + " == null) ||");
            writer.println("        (" + fieldName + ".length == 0))");
            writer.println("    {");
            writer.println("      return null;");
            writer.println("    }");
            writer.println("    else");
            writer.println("    {");
            writer.println("      return " + fieldName + "[0];");
            writer.println("    }");
            writer.println("  }");
            writer.println();
            writer.println();
            writer.println();
            writer.println("  /**");
            writer.println("   * Retrieves the values for the field associated with the");
            writer.println("   * " + attrName + " attribute, if present.");
            writer.println("   *");
            writer.println("   * @return  The values for the field associated with the");
            writer.println("   *          " + attrName + " attribute, or");
            writer.println("   *          {@code null} if that attribute was not present in the entry.");
            writer.println("   */");
            writer.println("  public " + type + "[] get" + capFieldName + "()");
            writer.println("  {");
            writer.println("    return " + fieldName + ';');
            writer.println("  }");
            if (addSetter) {
                writer.println();
                writer.println();
                writer.println();
                writer.println("  /**");
                writer.println("   * Sets the values for the field associated with the");
                writer.println("   * " + attrName + " attribute.");
                writer.println("   *");
                writer.println("   * @param  v  The values for the field associated with the");
                writer.println("   *            " + attrName + " attribute.");
                writer.println("   */");
                writer.println("  public void set" + capFieldName + "(final " + type + "... v)");
                writer.println("  {");
                writer.println("    this." + fieldName + " = v;");
                writer.println("  }");
            }
        }
        writer.println();
        writer.println();
        writer.println();
        writer.println("  /**");
        writer.println("   * Generates a filter that may be used to search for objects of this type");
        writer.println("   * using the " + attrName + " attribute.");
        writer.println("   * The resulting filter may be combined with other filter elements to create a");
        writer.println("   * more complex filter.");
        writer.println("   *");
        writer.println("   * @param  filterType  The type of filter to generate.");
        writer.println("   * @param  value       The value to use to use for the filter.  It may be");
        writer.println("   *                     {@code null} only for a filter type of");
        writer.println("   *                     {@code PRESENCE}.");
        writer.println("   *");
        writer.println("   * @return  The generated search filter.");
        writer.println("   *");
        writer.println("   * @throws  LDAPPersistException  If a problem is encountered while attempting");
        writer.println("   *                                to generate the filter.");
        writer.println("   */");
        writer.println("  public static Filter generate" + capFieldName + "Filter(");
        writer.println("                            final PersistFilterType filterType,");
        writer.println("                            final " + type + " value)");
        writer.println("         throws LDAPPersistException");
        writer.println("  {");
        writer.println("    final byte[] valueBytes;");
        writer.println("    if (filterType == PersistFilterType.PRESENCE)");
        writer.println("    {");
        writer.println("      valueBytes = null;");
        writer.println("    }");
        writer.println("    else");
        writer.println("    {");
        writer.println("      if (value == null)");
        writer.println("      {");
        writer.println("        throw new LDAPPersistException(\"Unable to generate a filter of type \" +");
        writer.println("             filterType.name() + \" with a null value for attribute \" +");
        writer.println("             \"" + attrName + "\");");
        writer.println("      }");
        writer.println();
        writer.println("      final LDAPObjectHandler<?> objectHandler =");
        writer.println("           getPersister().getObjectHandler();");
        writer.println("      final FieldInfo fieldInfo = objectHandler.getFields().get(");
        writer.println("           \"" + StaticUtils.toLowerCase(attrName) + "\");");
        writer.println();
        writer.println("      final DefaultObjectEncoder objectEncoder = new DefaultObjectEncoder();");
        writer.println("      valueBytes = objectEncoder.encodeFieldValue(fieldInfo.getField(),");
        if (d.isSingleValued()) {
            writer.println("           value,");
        } else {
            writer.println("           new " + type + "[] { value },");
        }
        writer.println("           \"" + attrName + "\").getValueByteArray();");
        writer.println("    }");
        writer.println();
        writer.println("    switch (filterType)");
        writer.println("    {");
        writer.println("      case PRESENCE:");
        writer.println("        return Filter.createPresenceFilter(");
        writer.println("             \"" + attrName + "\");");
        writer.println("      case EQUALITY:");
        writer.println("        return Filter.createEqualityFilter(");
        writer.println("             \"" + attrName + "\",");
        writer.println("             valueBytes);");
        writer.println("      case STARTS_WITH:");
        writer.println("        return Filter.createSubstringFilter(");
        writer.println("             \"" + attrName + "\",");
        writer.println("             valueBytes, null, null);");
        writer.println("      case ENDS_WITH:");
        writer.println("        return Filter.createSubstringFilter(");
        writer.println("             \"" + attrName + "\",");
        writer.println("             null, null, valueBytes);");
        writer.println("      case CONTAINS:");
        writer.println("        return Filter.createSubstringFilter(");
        writer.println("             \"" + attrName + "\",");
        writer.println("             null, new byte[][] { valueBytes }, null);");
        writer.println("      case GREATER_OR_EQUAL:");
        writer.println("        return Filter.createGreaterOrEqualFilter(");
        writer.println("             \"" + attrName + "\",");
        writer.println("             valueBytes);");
        writer.println("      case LESS_OR_EQUAL:");
        writer.println("        return Filter.createLessOrEqualFilter(");
        writer.println("             \"" + attrName + "\",");
        writer.println("             valueBytes);");
        writer.println("      case APPROXIMATELY_EQUAL_TO:");
        writer.println("        return Filter.createApproximateMatchFilter(");
        writer.println("             \"" + attrName + "\",");
        writer.println("             valueBytes);");
        writer.println("      default:");
        writer.println("        // This should never happen.");
        writer.println("        throw new LDAPPersistException(\"Unrecognized filter type \" +");
        writer.println("             filterType.name());");
        writer.println("    }");
        writer.println("  }");
    }

    private static void writeToString(@NotNull PrintWriter writer, @NotNull String className, @NotNull Collection<AttributeTypeDefinition> requiredAttrs, @NotNull Collection<AttributeTypeDefinition> optionalAttrs, @NotNull Collection<AttributeTypeDefinition> operationalAttrs) {
        writer.println();
        writer.println();
        writer.println();
        writer.println("  /**");
        writer.println("   * Retrieves a string representation of this");
        writer.println("   * {@code " + className + "} object.");
        writer.println("   *");
        writer.println("   * @return  A string representation of this");
        writer.println("   *          {@code " + className + "} object.");
        writer.println("   */");
        writer.println("  @Override()");
        writer.println("  public String toString()");
        writer.println("  {");
        writer.println("    final StringBuilder buffer = new StringBuilder();");
        writer.println("    toString(buffer);");
        writer.println("    return buffer.toString();");
        writer.println("  }");
        writer.println();
        writer.println();
        writer.println();
        writer.println("  /**");
        writer.println("   * Appends a string representation of this");
        writer.println("   * {@code " + className + "} object");
        writer.println("   * to the provided buffer.");
        writer.println("   *");
        writer.println("   * @param  buffer  The buffer to which the string representation should be");
        writer.println("   *                 appended.");
        writer.println("   */");
        writer.println("  public void toString(final StringBuilder buffer)");
        writer.println("  {");
        writer.println("    buffer.append(\"" + className + "(\");");
        writer.println();
        writer.println("    boolean appended = false;");
        writer.println("    if (ldapEntry != null)");
        writer.println("    {");
        writer.println("      appended = true;");
        writer.println("      buffer.append(\"entryDN='\");");
        writer.println("      buffer.append(ldapEntry.getDN());");
        writer.println("      buffer.append('\\'');");
        writer.println("    }");
        for (AttributeTypeDefinition d : requiredAttrs) {
            GenerateSourceFromSchema.writeToStringField(writer, d);
        }
        for (AttributeTypeDefinition d : optionalAttrs) {
            GenerateSourceFromSchema.writeToStringField(writer, d);
        }
        for (AttributeTypeDefinition d : operationalAttrs) {
            GenerateSourceFromSchema.writeToStringField(writer, d);
        }
        writer.println();
        writer.println("    buffer.append(')');");
        writer.println("  }");
    }

    private static void writeToStringField(@NotNull PrintWriter w, @NotNull AttributeTypeDefinition d) {
        String fieldName = PersistUtils.toJavaIdentifier(d.getNameOrOID());
        w.println();
        w.println("    if (" + fieldName + " != null)");
        w.println("    {");
        w.println("      if (appended)");
        w.println("      {");
        w.println("        buffer.append(\", \");");
        w.println("      }");
        w.println("      appended = true;");
        w.println("      buffer.append(\"" + fieldName + "=\");");
        if (d.isSingleValued()) {
            w.println("      buffer.append(" + fieldName + ");");
        } else {
            w.println("      buffer.append(Arrays.toString(" + fieldName + "));");
        }
        w.println("    }");
    }

    @NotNull
    private String getJavaType(@NotNull Schema schema, @NotNull AttributeTypeDefinition d) {
        String syntaxOID;
        if (!d.isSingleValued()) {
            this.needArrays = true;
        }
        if ((syntaxOID = d.getSyntaxOID(schema)) == null) {
            return "String";
        }
        int bracePos = syntaxOID.indexOf(123);
        String oid = bracePos > 0 ? syntaxOID.substring(0, bracePos) : syntaxOID;
        if (oid.equals("1.3.6.1.4.1.1466.115.121.1.7")) {
            return "Boolean";
        }
        if (oid.equals("1.3.6.1.4.1.4203.1.1.2") || oid.equals("1.3.6.1.4.1.1466.115.121.1.5") || oid.equals("1.3.6.1.4.1.1466.115.121.1.8") || oid.equals("1.3.6.1.4.1.1466.115.121.1.9") || oid.equals("1.3.6.1.4.1.1466.115.121.1.10") || oid.equals("1.3.6.1.4.1.1466.115.121.1.28") || oid.equals("1.3.6.1.4.1.1466.115.121.1.40")) {
            return "byte[]";
        }
        if (oid.equals("1.3.6.1.4.1.1466.115.121.1.24")) {
            this.needDate = true;
            return "Date";
        }
        if (oid.equals("1.3.6.1.4.1.1466.115.121.1.27")) {
            return "Long";
        }
        if (oid.equals("1.3.6.1.4.1.1466.115.121.1.12") || oid.equals("1.3.6.1.4.1.1466.115.121.1.34")) {
            this.needDN = true;
            if (!d.isSingleValued()) {
                this.needPersistedObjects = true;
            }
            return "DN";
        }
        return "String";
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPassword", "password", "--outputDirectory", "src/com/example", "--structuralClass", "myStructuralClass", "--auxiliaryClass", "auxClass1", "--auxiliaryClass", "auxClass2", "--rdnAttribute", "cn", "--defaultParentDN", "dc=example,dc=com", "--packageName", "com.example", "--className", "MyObject"};
        examples.put(args, PersistMessages.INFO_GEN_SOURCE_EXAMPLE_1.get());
        return examples;
    }
}

