/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.args.SubCommand;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SplitLDIF
extends CommandLineTool {
    private static final int MAX_OUTPUT_LINE_LENGTH = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @Nullable
    private BooleanArgument addEntriesOutsideSplitBaseDNToAllSets = null;
    @Nullable
    private BooleanArgument addEntriesOutsideSplitBaseDNToDedicatedSet = null;
    @Nullable
    private BooleanArgument compressTarget = null;
    @Nullable
    private BooleanArgument encryptTarget = null;
    @Nullable
    private BooleanArgument sourceCompressed = null;
    @Nullable
    private DNArgument splitBaseDN = null;
    @Nullable
    private FileArgument encryptionPassphraseFile = null;
    @Nullable
    private FileArgument schemaPath = null;
    @Nullable
    private FileArgument sourceLDIF = null;
    @Nullable
    private FileArgument targetLDIFBasePath = null;
    @Nullable
    private IntegerArgument numThreads = null;
    @Nullable
    private IntegerArgument splitUsingHashOnRDNNumSets = null;
    @Nullable
    private SubCommand splitUsingHashOnRDN = null;
    @Nullable
    private BooleanArgument splitUsingHashOnAttributeAssumeFlatDIT = null;
    @Nullable
    private BooleanArgument splitUsingHashOnAttributeUseAllValues = null;
    @Nullable
    private IntegerArgument splitUsingHashOnAttributeNumSets = null;
    @Nullable
    private StringArgument splitUsingHashOnAttributeAttributeName = null;
    @Nullable
    private SubCommand splitUsingHashOnAttribute = null;
    @Nullable
    private BooleanArgument splitUsingFewestEntriesAssumeFlatDIT = null;
    @Nullable
    private IntegerArgument splitUsingFewestEntriesNumSets = null;
    @Nullable
    private SubCommand splitUsingFewestEntries = null;
    @Nullable
    private BooleanArgument splitUsingFilterAssumeFlatDIT = null;
    @Nullable
    private FilterArgument splitUsingFilterFilter = null;
    @Nullable
    private SubCommand splitUsingFilter = null;

    public static void main(String ... args) {
        ResultCode resultCode = SplitLDIF.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        SplitLDIF tool = new SplitLDIF(out, err);
        return tool.runTool(args);
    }

    public SplitLDIF(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "split-ldif";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return ToolMessages.INFO_SPLIT_LDIF_TOOL_DESCRIPTION.get();
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.5";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    public void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.sourceLDIF = new FileArgument(Character.valueOf('l'), "sourceLDIF", true, 0, null, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_SOURCE_LDIF.get(), true, false, true, false);
        this.sourceLDIF.addLongIdentifier("inputLDIF", true);
        this.sourceLDIF.addLongIdentifier("source-ldif", true);
        this.sourceLDIF.addLongIdentifier("input-ldif", true);
        parser.addArgument(this.sourceLDIF);
        this.sourceCompressed = new BooleanArgument(Character.valueOf('C'), "sourceCompressed", ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_SOURCE_COMPRESSED.get());
        this.sourceCompressed.addLongIdentifier("inputCompressed", true);
        this.sourceCompressed.addLongIdentifier("source-compressed", true);
        this.sourceCompressed.addLongIdentifier("input-compressed", true);
        parser.addArgument(this.sourceCompressed);
        this.targetLDIFBasePath = new FileArgument(Character.valueOf('o'), "targetLDIFBasePath", false, 1, null, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_TARGET_LDIF_BASE.get(), false, true, true, false);
        this.targetLDIFBasePath.addLongIdentifier("outputLDIFBasePath", true);
        this.targetLDIFBasePath.addLongIdentifier("target-ldif-base-path", true);
        this.targetLDIFBasePath.addLongIdentifier("output-ldif-base-path", true);
        parser.addArgument(this.targetLDIFBasePath);
        this.compressTarget = new BooleanArgument(Character.valueOf('c'), "compressTarget", ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_COMPRESS_TARGET.get());
        this.compressTarget.addLongIdentifier("compressOutput", true);
        this.compressTarget.addLongIdentifier("compress", true);
        this.compressTarget.addLongIdentifier("compress-target", true);
        this.compressTarget.addLongIdentifier("compress-output", true);
        parser.addArgument(this.compressTarget);
        this.encryptTarget = new BooleanArgument(null, "encryptTarget", ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_ENCRYPT_TARGET.get());
        this.encryptTarget.addLongIdentifier("encryptOutput", true);
        this.encryptTarget.addLongIdentifier("encrypt", true);
        this.encryptTarget.addLongIdentifier("encrypt-target", true);
        this.encryptTarget.addLongIdentifier("encrypt-output", true);
        parser.addArgument(this.encryptTarget);
        this.encryptionPassphraseFile = new FileArgument(null, "encryptionPassphraseFile", false, 1, null, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_ENCRYPT_PW_FILE.get(), true, true, true, false);
        this.encryptionPassphraseFile.addLongIdentifier("encryptionPasswordFile", true);
        this.encryptionPassphraseFile.addLongIdentifier("encryption-passphrase-file", true);
        this.encryptionPassphraseFile.addLongIdentifier("encryption-password-file", true);
        parser.addArgument(this.encryptionPassphraseFile);
        this.splitBaseDN = new DNArgument(Character.valueOf('b'), "splitBaseDN", true, 1, null, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_SPLIT_BASE_DN.get());
        this.splitBaseDN.addLongIdentifier("baseDN", true);
        this.splitBaseDN.addLongIdentifier("split-base-dn", true);
        this.splitBaseDN.addLongIdentifier("base-dn", true);
        parser.addArgument(this.splitBaseDN);
        this.addEntriesOutsideSplitBaseDNToAllSets = new BooleanArgument(null, "addEntriesOutsideSplitBaseDNToAllSets", 1, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_OUTSIDE_TO_ALL_SETS.get());
        this.addEntriesOutsideSplitBaseDNToAllSets.addLongIdentifier("add-entries-outside-split-base-dn-to-all-sets", true);
        parser.addArgument(this.addEntriesOutsideSplitBaseDNToAllSets);
        this.addEntriesOutsideSplitBaseDNToDedicatedSet = new BooleanArgument(null, "addEntriesOutsideSplitBaseDNToDedicatedSet", 1, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_OUTSIDE_TO_DEDICATED_SET.get());
        this.addEntriesOutsideSplitBaseDNToDedicatedSet.addLongIdentifier("add-entries-outside-split-base-dn-to-dedicated-set", true);
        parser.addArgument(this.addEntriesOutsideSplitBaseDNToDedicatedSet);
        this.schemaPath = new FileArgument(null, "schemaPath", false, 0, null, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_SCHEMA_PATH.get(), true, false, false, false);
        this.schemaPath.addLongIdentifier("schemaFile", true);
        this.schemaPath.addLongIdentifier("schemaDirectory", true);
        this.schemaPath.addLongIdentifier("schema-path", true);
        this.schemaPath.addLongIdentifier("schema-file", true);
        this.schemaPath.addLongIdentifier("schema-directory", true);
        parser.addArgument(this.schemaPath);
        this.numThreads = new IntegerArgument(Character.valueOf('t'), "numThreads", false, 1, null, ToolMessages.INFO_SPLIT_LDIF_GLOBAL_ARG_DESC_NUM_THREADS.get(), 1, Integer.MAX_VALUE, 1);
        this.numThreads.addLongIdentifier("num-threads", true);
        parser.addArgument(this.numThreads);
        ArgumentParser splitUsingHashOnRDNParser = new ArgumentParser("split-using-hash-on-rdn", ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_RDN_DESC.get());
        this.splitUsingHashOnRDNNumSets = new IntegerArgument(null, "numSets", true, 1, null, ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_RDN_ARG_DESC_NUM_SETS.get(), 2, Integer.MAX_VALUE);
        this.splitUsingHashOnRDNNumSets.addLongIdentifier("num-sets", true);
        splitUsingHashOnRDNParser.addArgument(this.splitUsingHashOnRDNNumSets);
        LinkedHashMap<String[], String> splitUsingHashOnRDNExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        splitUsingHashOnRDNExamples.put(new String[]{"split-using-hash-on-rdn", "--sourceLDIF", "whole.ldif", "--targetLDIFBasePath", "split.ldif", "--splitBaseDN", "ou=People,dc=example,dc=com", "--numSets", "4", "--schemaPath", "config/schema", "--addEntriesOutsideSplitBaseDNToAllSets"}, ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_RDN_EXAMPLE.get());
        this.splitUsingHashOnRDN = new SubCommand("split-using-hash-on-rdn", ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_RDN_DESC.get(), splitUsingHashOnRDNParser, splitUsingHashOnRDNExamples);
        this.splitUsingHashOnRDN.addName("hash-on-rdn", true);
        parser.addSubCommand(this.splitUsingHashOnRDN);
        ArgumentParser splitUsingHashOnAttributeParser = new ArgumentParser("split-using-hash-on-attribute", ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_ATTR_DESC.get());
        this.splitUsingHashOnAttributeAttributeName = new StringArgument(null, "attributeName", true, 1, "{attr}", ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_ATTR_ARG_DESC_ATTR_NAME.get());
        this.splitUsingHashOnAttributeAttributeName.addLongIdentifier("attribute-name", true);
        splitUsingHashOnAttributeParser.addArgument(this.splitUsingHashOnAttributeAttributeName);
        this.splitUsingHashOnAttributeNumSets = new IntegerArgument(null, "numSets", true, 1, null, ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_ATTR_ARG_DESC_NUM_SETS.get(), 2, Integer.MAX_VALUE);
        this.splitUsingHashOnAttributeNumSets.addLongIdentifier("num-sets", true);
        splitUsingHashOnAttributeParser.addArgument(this.splitUsingHashOnAttributeNumSets);
        this.splitUsingHashOnAttributeUseAllValues = new BooleanArgument(null, "useAllValues", 1, ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_ATTR_ARG_DESC_ALL_VALUES.get());
        this.splitUsingHashOnAttributeUseAllValues.addLongIdentifier("use-all-values", true);
        splitUsingHashOnAttributeParser.addArgument(this.splitUsingHashOnAttributeUseAllValues);
        this.splitUsingHashOnAttributeAssumeFlatDIT = new BooleanArgument(null, "assumeFlatDIT", 1, ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_ATTR_ARG_DESC_ASSUME_FLAT_DIT.get());
        this.splitUsingHashOnAttributeAssumeFlatDIT.addLongIdentifier("assume-flat-dit", true);
        splitUsingHashOnAttributeParser.addArgument(this.splitUsingHashOnAttributeAssumeFlatDIT);
        LinkedHashMap<String[], String> splitUsingHashOnAttributeExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        splitUsingHashOnAttributeExamples.put(new String[]{"split-using-hash-on-attribute", "--sourceLDIF", "whole.ldif", "--targetLDIFBasePath", "split.ldif", "--splitBaseDN", "ou=People,dc=example,dc=com", "--attributeName", "uid", "--numSets", "4", "--schemaPath", "config/schema", "--addEntriesOutsideSplitBaseDNToAllSets"}, ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_ATTR_EXAMPLE.get());
        this.splitUsingHashOnAttribute = new SubCommand("split-using-hash-on-attribute", ToolMessages.INFO_SPLIT_LDIF_SC_HASH_ON_ATTR_DESC.get(), splitUsingHashOnAttributeParser, splitUsingHashOnAttributeExamples);
        this.splitUsingHashOnAttribute.addName("hash-on-attribute", true);
        parser.addSubCommand(this.splitUsingHashOnAttribute);
        ArgumentParser splitUsingFewestEntriesParser = new ArgumentParser("split-using-fewest-entries", ToolMessages.INFO_SPLIT_LDIF_SC_FEWEST_ENTRIES_DESC.get());
        this.splitUsingFewestEntriesNumSets = new IntegerArgument(null, "numSets", true, 1, null, ToolMessages.INFO_SPLIT_LDIF_SC_FEWEST_ENTRIES_ARG_DESC_NUM_SETS.get(), 2, Integer.MAX_VALUE);
        this.splitUsingFewestEntriesNumSets.addLongIdentifier("num-sets", true);
        splitUsingFewestEntriesParser.addArgument(this.splitUsingFewestEntriesNumSets);
        this.splitUsingFewestEntriesAssumeFlatDIT = new BooleanArgument(null, "assumeFlatDIT", 1, ToolMessages.INFO_SPLIT_LDIF_SC_FEWEST_ENTRIES_ARG_DESC_ASSUME_FLAT_DIT.get());
        this.splitUsingFewestEntriesAssumeFlatDIT.addLongIdentifier("assume-flat-dit", true);
        splitUsingFewestEntriesParser.addArgument(this.splitUsingFewestEntriesAssumeFlatDIT);
        LinkedHashMap<String[], String> splitUsingFewestEntriesExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        splitUsingFewestEntriesExamples.put(new String[]{"split-using-fewest-entries", "--sourceLDIF", "whole.ldif", "--targetLDIFBasePath", "split.ldif", "--splitBaseDN", "ou=People,dc=example,dc=com", "--numSets", "4", "--schemaPath", "config/schema", "--addEntriesOutsideSplitBaseDNToAllSets"}, ToolMessages.INFO_SPLIT_LDIF_SC_FEWEST_ENTRIES_EXAMPLE.get());
        this.splitUsingFewestEntries = new SubCommand("split-using-fewest-entries", ToolMessages.INFO_SPLIT_LDIF_SC_FEWEST_ENTRIES_DESC.get(), splitUsingFewestEntriesParser, splitUsingFewestEntriesExamples);
        this.splitUsingFewestEntries.addName("fewest-entries", true);
        parser.addSubCommand(this.splitUsingFewestEntries);
        ArgumentParser splitUsingFilterParser = new ArgumentParser("split-using-filter", ToolMessages.INFO_SPLIT_LDIF_SC_FILTER_DESC.get());
        this.splitUsingFilterFilter = new FilterArgument(null, "filter", true, 0, null, ToolMessages.INFO_SPLIT_LDIF_SC_FILTER_ARG_DESC_FILTER.get());
        splitUsingFilterParser.addArgument(this.splitUsingFilterFilter);
        this.splitUsingFilterAssumeFlatDIT = new BooleanArgument(null, "assumeFlatDIT", 1, ToolMessages.INFO_SPLIT_LDIF_SC_FILTER_ARG_DESC_ASSUME_FLAT_DIT.get());
        this.splitUsingFilterAssumeFlatDIT.addLongIdentifier("assume-flat-dit", true);
        splitUsingFilterParser.addArgument(this.splitUsingFilterAssumeFlatDIT);
        LinkedHashMap<String[], String> splitUsingFilterExamples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        splitUsingFilterExamples.put(new String[]{"split-using-filter", "--sourceLDIF", "whole.ldif", "--targetLDIFBasePath", "split.ldif", "--splitBaseDN", "ou=People,dc=example,dc=com", "--filter", "(timeZone=Eastern)", "--filter", "(timeZone=Central)", "--filter", "(timeZone=Mountain)", "--filter", "(timeZone=Pacific)", "--schemaPath", "config/schema", "--addEntriesOutsideSplitBaseDNToAllSets"}, ToolMessages.INFO_SPLIT_LDIF_SC_FILTER_EXAMPLE.get());
        this.splitUsingFilter = new SubCommand("split-using-filter", ToolMessages.INFO_SPLIT_LDIF_SC_FILTER_DESC.get(), splitUsingFilterParser, splitUsingFilterExamples);
        this.splitUsingFilter.addName("filter", true);
        parser.addSubCommand(this.splitUsingFilter);
    }

    @Override
    public void doExtendedArgumentValidation() throws ArgumentException {
        List<File> sourceLDIFValues = this.sourceLDIF.getValues();
        if (sourceLDIFValues.size() > 1 && !this.targetLDIFBasePath.isPresent()) {
            throw new ArgumentException(ToolMessages.ERR_SPLIT_LDIF_NO_TARGET_BASE_PATH.get(this.sourceLDIF.getIdentifierString(), this.targetLDIFBasePath.getIdentifierString()));
        }
        if (this.splitUsingFilter.isPresent()) {
            List<Filter> filterList = this.splitUsingFilterFilter.getValues();
            LinkedHashSet<Filter> filterSet = new LinkedHashSet<Filter>(StaticUtils.computeMapCapacity(filterList.size()));
            for (Filter f : filterList) {
                if (filterSet.contains(f)) {
                    throw new ArgumentException(ToolMessages.ERR_SPLIT_LDIF_NON_UNIQUE_FILTER.get(this.splitUsingFilterFilter.getIdentifierString(), f.toString()));
                }
                filterSet.add(f);
            }
            if (filterSet.size() < 2) {
                throw new ArgumentException(ToolMessages.ERR_SPLIT_LDIF_NOT_ENOUGH_FILTERS.get(this.splitUsingFilter.getPrimaryName(), this.splitUsingFilterFilter.getIdentifierString()));
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [27[CATCHBLOCK]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private Schema getSchema() throws LDAPException {
        if (this.schemaPath.isPresent()) {
            ArrayList<File> schemaFiles = new ArrayList<File>(10);
            for (File path : this.schemaPath.getValues()) {
                if (path.isFile()) {
                    schemaFiles.add(path);
                    continue;
                }
                TreeMap<String, File> fileMap = new TreeMap<String, File>();
                for (File schemaDirFile : path.listFiles()) {
                    String name = schemaDirFile.getName();
                    if (!schemaDirFile.isFile() || !name.toLowerCase().endsWith(".ldif")) continue;
                    fileMap.put(name, schemaDirFile);
                }
                schemaFiles.addAll(fileMap.values());
            }
            if (schemaFiles.isEmpty()) {
                throw new LDAPException(ResultCode.PARAM_ERROR, ToolMessages.ERR_SPLIT_LDIF_NO_SCHEMA_FILES.get(this.schemaPath.getIdentifierString()));
            }
            try {
                return Schema.getSchema(schemaFiles);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_SPLIT_LDIF_ERROR_LOADING_SCHEMA.get(StaticUtils.getExceptionMessage(e)));
            }
        }
        try {
            File instanceRoot;
            File configDir;
            File schemaDir;
            String instanceRootStr = StaticUtils.getEnvironmentVariable("INSTANCE_ROOT");
            if (instanceRootStr != null && (schemaDir = new File(configDir = new File(instanceRoot = new File(instanceRootStr), "config"), "schema")).exists()) {
                TreeMap<String, File> fileMap = new TreeMap<String, File>();
                for (File schemaDirFile : schemaDir.listFiles()) {
                    String name = schemaDirFile.getName();
                    if (!schemaDirFile.isFile() || !name.toLowerCase().endsWith(".ldif")) continue;
                    fileMap.put(name, schemaDirFile);
                }
                if (!fileMap.isEmpty()) {
                    return Schema.getSchema(new ArrayList<File>(fileMap.values()));
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        return null;
    }

    @NotNull
    private File getOutputFile(@NotNull String extension) {
        File baseFile = this.targetLDIFBasePath.isPresent() ? this.targetLDIFBasePath.getValue() : this.sourceLDIF.getValue();
        return new File(baseFile.getAbsolutePath() + extension);
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleMap = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(4));
        for (Map.Entry<String[], String> e : this.splitUsingHashOnRDN.getExampleUsages().entrySet()) {
            exampleMap.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String[], String> e : this.splitUsingHashOnAttribute.getExampleUsages().entrySet()) {
            exampleMap.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String[], String> e : this.splitUsingFewestEntries.getExampleUsages().entrySet()) {
            exampleMap.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String[], String> e : this.splitUsingFilter.getExampleUsages().entrySet()) {
            exampleMap.put(e.getKey(), e.getValue());
        }
        return exampleMap;
    }
}

