/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.AccessRequirement;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.lang.reflect.AnnotatedElement;

public class AccessRequirementUtil {
    public static AccessRequirement getAccessRequirement(AnnotatedElement annotatedClassOrMethod, AnnotatedElement fallback) {
        if (annotatedClassOrMethod.isAnnotationPresent(DenyAll.class)) {
            return new AccessRequirement(AccessRequirement.Type.DENY_ALL);
        }
        if (annotatedClassOrMethod.isAnnotationPresent(AnonymousAllowed.class)) {
            return new AccessRequirement(AccessRequirement.Type.ANONYMOUS_ALLOWED);
        }
        RolesAllowed rolesAllowed = annotatedClassOrMethod.getAnnotation(RolesAllowed.class);
        if (rolesAllowed != null) {
            return new AccessRequirement(AccessRequirement.Type.ROLES_ALLOWED, rolesAllowed.value());
        }
        if (annotatedClassOrMethod.isAnnotationPresent(PermitAll.class)) {
            return new AccessRequirement(AccessRequirement.Type.PERMIT_ALL);
        }
        if (fallback != null) {
            return AccessRequirementUtil.getAccessRequirement(fallback, null);
        }
        return new AccessRequirement(AccessRequirement.Type.DENY_ALL);
    }
}

