/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.base.devserver.stats.ProjectHelpers;
import com.vaadin.copilot.Downloader;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.flow.server.frontend.installer.ArchiveExtractionException;
import com.vaadin.flow.server.frontend.installer.DefaultArchiveExtractor;
import com.vaadin.flow.server.frontend.installer.DownloadException;
import com.vaadin.open.OSUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class JetbrainsRuntimeUtil {
    private static final String TAR_GZ = ".tar.gz";
    private static final String JETBRAINS_GITHUB_RELEASES_PAGE = "https://api.github.com/repos/JetBrains/JetBrainsRuntime/releases";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ProjectManager projectManager;

    public JetbrainsRuntimeUtil(ProjectManager projectManager) {
        this.projectManager = projectManager;
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private static String getArchitecture() {
        return System.getProperty("os.arch");
    }

    public File unpackJbr(File jbrArchive, Consumer<String> statusUpdater) throws IOException, ArchiveExtractionException {
        if (!jbrArchive.getName().endsWith(TAR_GZ)) {
            throw new IOException("Unexpected file format: " + jbrArchive.getName());
        }
        File folder = new File(jbrArchive.getParentFile(), jbrArchive.getName().replace(TAR_GZ, ""));
        if (folder.exists()) {
            File[] files = folder.listFiles();
            if (files == null || files.length == 0) {
                Files.delete(folder.toPath());
            } else {
                statusUpdater.accept("Using JetBrains already in " + folder.getAbsolutePath());
                return folder;
            }
        }
        statusUpdater.accept("Extracting " + jbrArchive.getAbsolutePath() + " into " + folder.getAbsolutePath());
        new DefaultArchiveExtractor().extract(jbrArchive, jbrArchive.getParentFile());
        statusUpdater.accept("Extraction complete");
        return folder;
    }

    private File getJavaHome(File jdkFolder) {
        if (OSUtils.isMac()) {
            return jdkFolder.toPath().resolve("Contents").resolve("Home").toFile();
        }
        return jdkFolder;
    }

    public File getHotswapAgentLocation(File jdkFolder) {
        return new File(new File(new File(this.getJavaHome(jdkFolder), "lib"), "hotswap"), "hotswap-agent.jar");
    }

    public File getJavaExecutable(File jdkFolder) {
        String bin = OSUtils.isWindows() ? "java.exe" : "java";
        return new File(new File(this.getJavaHome(jdkFolder), "bin"), bin);
    }

    public Optional<File> downloadLatestJBR(Consumer<String> statusUpdater) throws IOException, URISyntaxException, DownloadException {
        statusUpdater.accept("Finding JetBrains Runtime download location");
        GitHubRelease latest = this.findLatestJBRRelease();
        Optional<URL> downloadUrl = this.findJBRDownloadUrl(latest);
        if (downloadUrl.isPresent()) {
            URL url = downloadUrl.get();
            String filename = this.getFilename(url);
            File target = new File(new File(ProjectHelpers.resolveVaadinHomeDirectory(), "jdk"), filename);
            File folder = target.getParentFile();
            if (!folder.exists() && !folder.mkdirs()) {
                throw new IOException("Unable to create " + folder.getAbsolutePath());
            }
            this.downloadIfNotPresent(url, target, statusUpdater);
            return Optional.of(target);
        }
        return Optional.empty();
    }

    private void downloadIfNotPresent(URL url, File target, Consumer<String> statusUpdater) throws URISyntaxException, DownloadException {
        if (target.exists() && target.length() > 0L) {
            statusUpdater.accept("JetBrains Runtime already downloaded into " + target.getAbsolutePath());
            return;
        }
        statusUpdater.accept("Downloading JetBrains Runtime from " + String.valueOf(url));
        Downloader.downloadFile(url, target, this.projectManager, (bytesTransferred, totalBytes, progress) -> statusUpdater.accept("Progress: " + progress));
        statusUpdater.accept("Downloaded JetBrains Runtime into " + target.getAbsolutePath());
    }

    private String getFilename(URL url) {
        return url.getFile().replaceAll(".*/", "");
    }

    private Optional<URL> findJBRDownloadUrl(GitHubRelease latest) throws URISyntaxException, IOException {
        GitHubReleaseWithBody release = (GitHubReleaseWithBody)this.objectMapper.readValue(new URI("https://api.github.com/repos/JetBrains/JetBrainsRuntime/releases/" + latest.id).toURL(), GitHubReleaseWithBody.class);
        Optional<JBRSdkInfo> sdk = this.findCorrectReleaseForArchitecture(release.body);
        if (sdk.isPresent()) {
            return Optional.of(new URL(sdk.get().url()));
        }
        return Optional.empty();
    }

    private GitHubRelease findLatestJBRRelease() throws URISyntaxException, IOException {
        TypeReference<List<GitHubRelease>> listOfGithubReleases = new TypeReference<List<GitHubRelease>>(){};
        List res = (List)this.objectMapper.readValue(new URI(JETBRAINS_GITHUB_RELEASES_PAGE).toURL(), (TypeReference)listOfGithubReleases);
        List<GitHubRelease> relevant = res.stream().filter(r -> !r.prerelease).sorted().toList();
        return relevant.get(relevant.size() - 1);
    }

    private Optional<JBRSdkInfo> findCorrectReleaseForArchitecture(String body) {
        Map<String, JBRSdkInfo> jbrSdks = JetbrainsRuntimeUtil.findAllJbrSdks(body);
        String key = this.getDownloadKey();
        return Optional.ofNullable(jbrSdks.get(key));
    }

    public String getDownloadKey() {
        String jvmArch = JetbrainsRuntimeUtil.getArchitecture();
        String prefix = OSUtils.isMac() ? "osx" : (OSUtils.isWindows() ? "windows" : "linux");
        String suffix = "aarch64".equals(jvmArch) ? "aarch64" : ("x86".equals(jvmArch) ? "x86" : "x64");
        return prefix + "-" + suffix;
    }

    private static Map<String, JBRSdkInfo> findAllJbrSdks(String body) {
        String[] lines = body.replace("\r", "").split("\n");
        List<JBRSdkInfo> sdks = Arrays.stream(lines).map(line -> {
            String[] parts = line.split("\\|");
            if (parts.length < 4) {
                return null;
            }
            String arch = parts[1].trim();
            String sdkType = parts[2].replace("*", "").trim();
            String url = parts[3].replaceAll("\\[.*]", "").replaceAll("[()]", "").trim();
            return new JBRSdkInfo(arch, sdkType, url);
        }).filter(Objects::nonNull).toList();
        return sdks.stream().filter(jbrSdkInfo -> jbrSdkInfo.sdkType.equals("JBRSDK")).filter(jbrSdkInfo -> jbrSdkInfo.url.endsWith(TAR_GZ)).collect(Collectors.toMap(sdkInfo -> sdkInfo.arch, sdkInfo -> sdkInfo));
    }

    record GitHubRelease(int id, String name, String tag_name, boolean prerelease) implements Comparable<GitHubRelease>
    {
        @Override
        public int compareTo(GitHubRelease o) {
            return this.compareNumerically(this.tag_name, o.tag_name);
        }

        private int compareNumerically(String s1, String s2) {
            int commonLength = Math.min(s1.length(), s2.length());
            for (int i = 0; i < commonLength; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i))) continue;
                return Character.compare(c1, c2);
            }
            if (s1.length() > commonLength) {
                return 1;
            }
            if (s2.length() > commonLength) {
                return -1;
            }
            return 0;
        }
    }

    record GitHubReleaseWithBody(String body) {
    }

    record JBRSdkInfo(String arch, String sdkType, String url) {
    }
}

