/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.nodeTypes.NodeWithStatements;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.vaadin.copilot.IdentityHashSet;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class JavaRewriterMerger {
    public static String apply(Set<Node> addedOrModifiedNodes, Set<Range> removedRanges, String source) {
        IdentityHashSet addedStatements = new IdentityHashSet();
        HashSet addedDeclarations = new HashSet();
        HashSet addedImports = new HashSet();
        HashSet addedComments = new HashSet();
        ArrayList<Node> addedOrModified = new ArrayList<Node>(addedOrModifiedNodes);
        addedOrModified.removeIf(node -> {
            if (node instanceof Comment) {
                Comment comment = (Comment)node;
                addedComments.add(comment);
                return true;
            }
            if (JavaRewriterUtil.findAncestor(node, CompilationUnit.class) == null) {
                return true;
            }
            Statement statement = JavaRewriterUtil.findAncestor(node, Statement.class);
            if (statement != null) {
                addedStatements.add(statement);
                return true;
            }
            BodyDeclaration recordDeclaration = JavaRewriterUtil.findAncestor(node, BodyDeclaration.class);
            if (recordDeclaration != null) {
                addedDeclarations.add(recordDeclaration);
                return true;
            }
            ImportDeclaration importDeclaration = JavaRewriterUtil.findAncestor(node, ImportDeclaration.class);
            if (importDeclaration != null) {
                addedImports.add(importDeclaration);
                return true;
            }
            return false;
        });
        Set<Integer> removedLines = removedRanges.stream().flatMap(JavaRewriterMerger::rangeToLines).collect(Collectors.toSet());
        List<AddChange> addChanges = JavaRewriterMerger.collectChanges(addedStatements, addedDeclarations, addedImports, addedComments).sorted().toList();
        return JavaRewriterMerger.applyChanges(source, addChanges, removedLines);
    }

    @SafeVarargs
    private static Stream<AddChange> collectChanges(Set<? extends Node> ... collections) {
        Stream<AddChange> streams = Stream.empty();
        for (Set<? extends Node> collection : collections) {
            Set<List<Node>> mergedNodes = JavaRewriterMerger.mergeConsecutiveNodes(collection);
            Stream<AddChange> stream = mergedNodes.stream().map(addedNode -> {
                LineColumn insertAt = JavaRewriterMerger.findInsertPosition((Node)addedNode.get(0));
                return new AddChange(insertAt, addedNode.stream().map(Object::toString).collect(Collectors.joining("\n")));
            });
            streams = Stream.concat(streams, stream);
        }
        return streams;
    }

    private static Stream<Integer> rangeToLines(Range range) {
        return IntStream.range(range.begin.line - 1, range.end.line - 1 + 1).boxed();
    }

    private static Set<List<Node>> mergeConsecutiveNodes(Set<? extends Node> nodes) {
        IdentityHashSet<List<Node>> merged = new IdentityHashSet<List<Node>>();
        while (!nodes.isEmpty()) {
            Node statement = nodes.iterator().next();
            List<Node> list = JavaRewriterMerger.getConsecutiveNodes(statement, nodes);
            merged.add(list);
        }
        return merged;
    }

    private static List<Node> getConsecutiveNodes(Node statement, Set<? extends Node> nodes) {
        ArrayList<Node> list = new ArrayList<Node>();
        list.add(statement);
        nodes.remove(statement);
        Optional<Node> next = JavaRewriterMerger.getNextSibling(statement);
        Optional<Node> prev = JavaRewriterMerger.getPreviousSibling(statement);
        if (prev.isPresent() && nodes.contains(prev.get())) {
            list.addAll(0, JavaRewriterMerger.getConsecutiveNodes(prev.get(), nodes));
        }
        if (next.isPresent() && nodes.contains(next.get())) {
            list.addAll(JavaRewriterMerger.getConsecutiveNodes(next.get(), nodes));
        }
        return list;
    }

    private static String applyChanges(String source, List<AddChange> addChanges, Set<Integer> removedLines) {
        StringBuilder result = new StringBuilder();
        String[] sourceLines = source.split("\n");
        LineColumn nextFromOriginal = new LineColumn(0, 0);
        for (AddChange addChange : addChanges) {
            LineColumn insertAt = addChange.lineColumn();
            JavaRewriterMerger.writeLines(nextFromOriginal, insertAt, sourceLines, result, removedLines);
            result.append(addChange.text.replace("DELETE_THIS", "")).append("\n");
            nextFromOriginal = insertAt;
        }
        LineColumn endOfFile = new LineColumn(sourceLines.length - 1, sourceLines[sourceLines.length - 1].length());
        if (nextFromOriginal.before(endOfFile)) {
            JavaRewriterMerger.writeLines(nextFromOriginal, endOfFile, sourceLines, result, removedLines);
        }
        return result.toString();
    }

    private static void writeLines(LineColumn startInclusive, LineColumn endInclusive, String[] from, StringBuilder to, Set<Integer> removedLines) {
        int firstFullLine = startInclusive.line();
        if (startInclusive.column() != 0 && !removedLines.contains(startInclusive.line())) {
            ++firstFullLine;
            to.append(from[startInclusive.line()].substring(startInclusive.column()));
        }
        for (int i = firstFullLine; i < endInclusive.line(); ++i) {
            if (removedLines.contains(i)) continue;
            to.append(from[i]).append("\n");
        }
        if (from.length > endInclusive.line() && endInclusive.column() > 0 && !removedLines.contains(endInclusive.line())) {
            to.append(from[endInclusive.line()], 0, endInclusive.column()).append("\n");
        }
    }

    private static LineColumn findInsertPosition(Node nodeToInsert) {
        Comment comment;
        Optional commentedNode;
        Node prev;
        Optional prevRange;
        Optional<Node> maybePrev = JavaRewriterMerger.getPreviousSibling(nodeToInsert);
        Optional maybeParent = nodeToInsert.getParentNode();
        if (maybeParent.isPresent()) {
            Node parent = (Node)maybeParent.get();
            if (maybePrev.isEmpty() || nodeToInsert instanceof ImportDeclaration) {
                Optional<Range> firstChildFromSource = JavaRewriterMerger.getOrderedChildCollection(nodeToInsert, parent).stream().filter(child -> child.getRange().isPresent()).map(child -> (Range)child.getRange().get()).findFirst();
                if (firstChildFromSource.isPresent()) {
                    return new LineColumn(firstChildFromSource.get().begin.line - 1, 0);
                }
                if (parent instanceof ClassOrInterfaceDeclaration) {
                    ClassOrInterfaceDeclaration classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)parent;
                    Optional range = classOrInterfaceDeclaration.getRange();
                    if (range.isPresent()) {
                        return new LineColumn(((Range)range.get()).end.line - 1, ((Range)range.get()).end.column - 1);
                    }
                } else if (parent instanceof BlockStmt) {
                    BlockStmt blockStmt = (BlockStmt)parent;
                    Optional range = blockStmt.getRange();
                    if (range.isPresent()) {
                        return new LineColumn(((Range)range.get()).end.line - 1, ((Range)range.get()).end.column - 1);
                    }
                } else if (nodeToInsert instanceof ImportDeclaration && parent instanceof CompilationUnit) {
                    CompilationUnit compilationUnit = (CompilationUnit)parent;
                    NodeList types = compilationUnit.getTypes();
                    if (!types.isEmpty()) {
                        Optional range = ((TypeDeclaration)types.get(0)).getRange();
                        if (range.isPresent()) {
                            return new LineColumn(((Range)range.get()).begin.line - 1, 0);
                        }
                    } else {
                        return new LineColumn(1, 0);
                    }
                }
                throw new IllegalArgumentException("Unclear where to add code for " + String.valueOf(nodeToInsert));
            }
        }
        if (maybePrev.isPresent() && (prevRange = (prev = maybePrev.get()).getRange()).isPresent()) {
            return new LineColumn(((Range)prevRange.get()).end.line, 0);
        }
        if (nodeToInsert instanceof Comment && (commentedNode = (comment = (Comment)nodeToInsert).getCommentedNode()).isPresent()) {
            return JavaRewriterMerger.findInsertPosition((Node)commentedNode.get());
        }
        return new LineColumn(0, 0);
    }

    private static Optional<Node> getPreviousSibling(Node n) {
        return JavaRewriterMerger.getSibling(n, -1);
    }

    private static Optional<Node> getNextSibling(Node n) {
        return JavaRewriterMerger.getSibling(n, 1);
    }

    private static Optional<Node> getSibling(Node n, int i) {
        return n.getParentNode().flatMap(parent -> JavaRewriterMerger.getSibling(JavaRewriterMerger.getOrderedChildCollection(n, parent), n, i));
    }

    private static List<? extends Node> getOrderedChildCollection(Node n, Node parent) {
        if (n instanceof Statement && parent instanceof NodeWithStatements) {
            NodeWithStatements nodeWithStatements = (NodeWithStatements)parent;
            return nodeWithStatements.getStatements();
        }
        if (parent instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)parent;
            return classOrInterfaceDeclaration.getMembers();
        }
        if (parent instanceof CompilationUnit) {
            CompilationUnit compilationUnit = (CompilationUnit)parent;
            if (n instanceof ImportDeclaration) {
                return compilationUnit.getImports();
            }
        }
        return parent.getChildNodes();
    }

    private static Optional<Node> getSibling(List<? extends Node> nodes, Node n, int i) {
        int index = -1;
        for (int k = 0; k < nodes.size(); ++k) {
            if (nodes.get(k) != n) continue;
            index = k;
            break;
        }
        if (index == -1) {
            throw new IllegalArgumentException("Node not found in parent");
        }
        int siblingIndex = index + i;
        if (siblingIndex >= 0 && siblingIndex < nodes.size()) {
            return Optional.of(nodes.get(siblingIndex));
        }
        return Optional.empty();
    }

    private record LineColumn(int line, int column) {
        public boolean before(LineColumn endOfFile) {
            if (this.line < endOfFile.line) {
                return true;
            }
            return this.line == endOfFile.line && this.column < endOfFile.column;
        }
    }

    private record AddChange(LineColumn lineColumn, String text) implements Comparable<AddChange>
    {
        @Override
        public int compareTo(AddChange o) {
            return Integer.compare(this.lineColumn.line, o.lineColumn.line);
        }
    }
}

