/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.vaadin.copilot.javarewriter.ComponentInfo;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.shared.util.SharedUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JavaStyleRewriter {
    public static List<StyleInfo> getStyles(ComponentInfo componentInfo) {
        return JavaRewriterUtil.findCalls(Style.class, componentInfo).stream().map(JavaStyleRewriter::extractStyle).toList();
    }

    public static void setStyle(ComponentInfo componentInfo, String dashSeparatedProperty, String value) {
        List<MethodCallExpr> styleCalls = JavaRewriterUtil.findCalls(Style.class, componentInfo);
        List<MethodCallExpr> existingSetters = JavaStyleRewriter.getExistingSetterMethodCalls(componentInfo, dashSeparatedProperty);
        if (existingSetters.isEmpty()) {
            if (value == null) {
                throw new IllegalArgumentException("Unable to remove non-existing style " + dashSeparatedProperty + " from " + String.valueOf(componentInfo));
            }
            MethodCallExpr newStylesCall = JavaStyleRewriter.createStylesCall(dashSeparatedProperty, value);
            if (!styleCalls.isEmpty()) {
                MethodCallExpr lastStylesCall = styleCalls.get(styleCalls.size() - 1);
                JavaRewriterUtil.findAncestorOrThrow((Node)lastStylesCall, ExpressionStmt.class).setExpression((Expression)newStylesCall);
                newStylesCall.setScope((Expression)lastStylesCall);
            } else {
                MethodCallExpr getStyleCall = JavaRewriterUtil.addFunctionCall(componentInfo, "getStyle", Collections.emptyList());
                newStylesCall.setScope((Expression)JavaRewriterUtil.clone(getStyleCall));
                getStyleCall.replace((Node)newStylesCall);
            }
        } else {
            JavaStyleRewriter.updateStyle(existingSetters.get(existingSetters.size() - 1), value);
        }
    }

    private static List<MethodCallExpr> getExistingSetterMethodCalls(ComponentInfo componentInfo, String dashSeparatedProperty) {
        List<MethodCallExpr> styleCalls = JavaRewriterUtil.findCalls(Style.class, componentInfo);
        return styleCalls.stream().filter(methodCallExpr -> {
            StyleInfo style = JavaStyleRewriter.extractStyle(methodCallExpr);
            if (style.isDashSeparatedProperty) {
                return style.property().equals(dashSeparatedProperty);
            }
            return SharedUtil.camelCaseToDashSeparated((String)style.property()).equals(dashSeparatedProperty);
        }).toList();
    }

    private static MethodCallExpr createStylesCall(String dashSeparatedProperty, String value) {
        String camelCaseProperty = SharedUtil.dashSeparatedToCamelCase((String)dashSeparatedProperty);
        String setter = JavaRewriterUtil.getSetterName(camelCaseProperty, Style.class, false);
        if (JavaRewriterUtil.hasSetterForType(Style.class, setter, String.class)) {
            return (MethodCallExpr)new MethodCallExpr(null, setter).addArgument(JavaRewriterUtil.toExpression(value));
        }
        return (MethodCallExpr)((MethodCallExpr)new MethodCallExpr(null, "set").addArgument(JavaRewriterUtil.toExpression(dashSeparatedProperty))).addArgument(JavaRewriterUtil.toExpression(value));
    }

    private static StyleInfo extractStyle(MethodCallExpr methodCallExpr) {
        String value;
        String setter = methodCallExpr.getNameAsString();
        if (setter.equals("set")) {
            String dashProperty = String.valueOf(JavaRewriterUtil.fromExpression(methodCallExpr.getArgument(0), null));
            String value2 = String.valueOf(JavaRewriterUtil.fromExpression(methodCallExpr.getArgument(1), null));
            return new StyleInfo(dashProperty, value2, true);
        }
        int argCount = methodCallExpr.getArguments().size();
        if (argCount != 1) {
            throw new IllegalArgumentException("Expected styles method call expression to have one argument but was " + argCount + " for " + String.valueOf(methodCallExpr));
        }
        Expression argument = methodCallExpr.getArgument(0);
        if (argument.isFieldAccessExpr()) {
            String fieldName = argument.asFieldAccessExpr().getNameAsString();
            value = fieldName.replace("_", "-").toLowerCase();
        } else if (argument.isStringLiteralExpr()) {
            value = argument.asStringLiteralExpr().getValue();
        } else {
            throw new IllegalArgumentException("Unexpected argument type in style call: " + String.valueOf(methodCallExpr));
        }
        String property = JavaRewriterUtil.getPropertyName(setter);
        return new StyleInfo(property, value, false);
    }

    static void updateStyle(MethodCallExpr methodCallExpr, Object value) {
        if (value == null) {
            JavaRewriterUtil.removeFromChainedStyleCall(methodCallExpr);
            return;
        }
        if (methodCallExpr.getNameAsString().equals("set")) {
            methodCallExpr.getArgument(1).replace((Node)JavaRewriterUtil.toExpression(value));
        } else {
            methodCallExpr.getArgument(0).replace((Node)JavaRewriterUtil.toExpression(value));
        }
    }

    public static void setSizing(ComponentInfo componentInfo, Map<String, String> changes) {
        List<MethodCallExpr> methodCalls = JavaRewriterUtil.findMethodCalls(componentInfo);
        changes.forEach((key, value) -> {
            if (value == null) {
                JavaStyleRewriter.removeSizingStatements(componentInfo, methodCalls, key);
            } else {
                JavaStyleRewriter.setStyle(componentInfo, SharedUtil.camelCaseToDashSeparated((String)key), value);
            }
        });
    }

    private static void removeSizingStatements(ComponentInfo componentInfo, List<MethodCallExpr> methodCalls, String camelCasePropertyKey) {
        boolean propertyRemoved = false;
        String setterName = JavaRewriterUtil.getSetterName(camelCasePropertyKey, componentInfo.getClass(), false);
        List<MethodCallExpr> list = methodCalls.stream().filter(methodCallExpr -> methodCallExpr.getNameAsString().equals(setterName)).toList();
        if (!list.isEmpty()) {
            propertyRemoved = true;
            list.forEach(JavaRewriterUtil::removeStatement);
        }
        if (!propertyRemoved) {
            propertyRemoved = JavaStyleRewriter.removeExpandStatements(componentInfo, camelCasePropertyKey);
        }
        if (!propertyRemoved) {
            JavaStyleRewriter.setStyle(componentInfo, SharedUtil.camelCaseToDashSeparated((String)camelCasePropertyKey), null);
        }
    }

    private static boolean removeExpandStatements(ComponentInfo componentInfo, String camelCasePropertyKey) {
        if (!"flexGrow".equals(camelCasePropertyKey)) {
            return false;
        }
        List<Expression> parameterUsage = JavaRewriterUtil.findParameterUsage(componentInfo).stream().filter(parameterExpression -> parameterExpression.getParentNode().isPresent() && parameterExpression.getParentNode().get() instanceof MethodCallExpr).toList();
        for (Expression expression : parameterUsage) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)expression.getParentNode().get();
            if (methodCallExpr.getNameAsString().equals("expand")) {
                if (methodCallExpr.getArguments().size() == 1) {
                    JavaRewriterUtil.removeStatement((Node)methodCallExpr);
                    return true;
                }
                int argumentPosition = methodCallExpr.getArgumentPosition(expression);
                methodCallExpr.getArguments().remove(argumentPosition);
                continue;
            }
            if (!methodCallExpr.getNameAsString().equals("addAndExpand")) continue;
            throw new IllegalArgumentException("addAndExpand call is not supported yet");
        }
        return false;
    }

    public record StyleInfo(String property, String value, boolean isDashSeparatedProperty) {
    }
}

