/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ErrorHandler;
import com.vaadin.copilot.FlowUtil;
import com.vaadin.copilot.JavaSourcePathDetector;
import com.vaadin.copilot.ProjectFileManager;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.Util;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.copilot.javarewriter.ComponentTypeAndSourceLocation;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectFileHandler
implements CopilotCommand {
    private static final String COPILOT_UNDO_LABEL = CopilotIDEPlugin.undoLabel("File Update");
    private final ProjectManager projectManager;

    public ProjectFileHandler(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("get-project-file")) {
            String filename = data.getString("filename");
            String reqId = data.getString("reqId");
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", reqId);
            try {
                responseData.put("content", this.projectManager.readFile(filename));
                devToolsInterface.send("copilot-project-file", responseData);
            }
            catch (IOException e) {
                this.getLogger().debug("Unable to read project file {}", (Object)filename, (Object)e);
                ErrorHandler.sendErrorResponse(devToolsInterface, command, responseData, "Unable to read file", e);
            }
            return true;
        }
        if (command.equals("write-project-file")) {
            String filename = data.getString("filename");
            String reqId = data.getString("reqId");
            String content = data.getString("content");
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", reqId);
            try {
                this.projectManager.writeFile(filename, COPILOT_UNDO_LABEL, content);
                devToolsInterface.send("copilot-project-file-written", responseData);
            }
            catch (IOException e) {
                this.getLogger().debug("Unable to write project file {}", (Object)filename, (Object)e);
                ErrorHandler.sendErrorResponse(devToolsInterface, command, responseData, "Unable to write file", e);
            }
            return true;
        }
        if (command.equals("write-project-resource-binary")) {
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", data.getString("reqId"));
            Optional resourceFolder = Util.findCurrentModule(this.projectManager, data.getObject("currentView")).flatMap(JavaSourcePathDetector.ModuleInfo::getOrGuessResourceFolder);
            String filename = data.getString("filename");
            String base64 = data.getString("base64Content");
            boolean renameIfExists = data.getBoolean("renameIfExists");
            try {
                if (resourceFolder.isEmpty()) {
                    throw new IOException("Unable to determine resource folder for the current view");
                }
                File written = ProjectFileManager.getInstance().writeFileBase64(((Path)resourceFolder.get()).resolve(filename).toString(), COPILOT_UNDO_LABEL, base64, renameIfExists);
                responseData.put("filename", written.getName());
                devToolsInterface.send("copilot-" + command + "-response", responseData);
            }
            catch (IOException e) {
                responseData.put("error", true);
                devToolsInterface.send("copilot-project-file-written", responseData);
                this.getLogger().error("Unable to write project file {}", (Object)filename, (Object)e);
            }
            return true;
        }
        if (command.equals("get-component-source-info")) {
            JsonObject responseData = Json.createObject();
            responseData.put("reqId", data.getString("reqId"));
            int uiId = (int)data.getNumber("uiId");
            Map<Component, ComponentTypeAndSourceLocation> allComponents = FlowUtil.findAllComponents(this.projectManager, uiId);
            List<Integer> nodeIdsInProject = allComponents.entrySet().stream().filter(entry -> {
                Optional<ComponentTracker.Location> create = ((ComponentTypeAndSourceLocation)entry.getValue()).createLocationInProject();
                return create.filter(location -> this.projectManager.getSourceFile((ComponentTracker.Location)location).exists()).isPresent();
            }).map(entry -> (Component)entry.getKey()).map(FlowUtil::getNodeId).toList();
            responseData.put("nodeIdsInProject", (JsonValue)JsonUtils.listToJson(nodeIdsInProject));
            devToolsInterface.send("copilot-" + command + "-response", responseData);
            return true;
        }
        return false;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

