/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonArray;
import elemental.json.JsonBoolean;
import elemental.json.JsonNull;
import elemental.json.JsonNumber;
import elemental.json.JsonObject;
import elemental.json.JsonString;
import elemental.json.JsonType;
import elemental.json.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public record JavaComponent(String tag, String className, Map<String, Object> props, List<JavaComponent> children, Metadata metadata) {
    public JavaComponent(String tag, String className, Map<String, Object> props, List<JavaComponent> children) {
        this(tag, className, props, children, new Metadata());
    }

    public JavaComponent withTag(String tag) {
        return new JavaComponent(tag, this.className(), this.props(), this.children());
    }

    private static Object propertyValueFromJson(Object jsonValue) {
        if (jsonValue instanceof JsonBoolean) {
            JsonBoolean jsonboolean = (JsonBoolean)jsonValue;
            return jsonboolean.getBoolean();
        }
        if (jsonValue instanceof JsonString) {
            JsonString jsonString = (JsonString)jsonValue;
            return jsonString.getString();
        }
        if (jsonValue instanceof JsonNull) {
            return null;
        }
        if (jsonValue instanceof JsonNumber) {
            JsonNumber number = (JsonNumber)jsonValue;
            if (number.asString().equals("" + (int)number.asNumber())) {
                return (int)((JsonNumber)jsonValue).getNumber();
            }
            return number.asNumber();
        }
        if (jsonValue instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonValue;
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            for (String key : jsonObject.keys()) {
                values.put(key, JavaComponent.propertyValueFromJson(jsonObject.get(key)));
            }
            return values;
        }
        if (jsonValue instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonValue;
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                values.add(JavaComponent.propertyValueFromJson(jsonArray.get(i)));
            }
            return values;
        }
        throw new IllegalArgumentException("Unsupported JSON value: " + String.valueOf(jsonValue));
    }

    public static JavaComponent componentFromJson(JsonObject json) {
        JsonValue itemType;
        JsonObject jsonMetadata;
        String tag = json.hasKey("tag") ? json.getString("tag") : null;
        String className = json.hasKey("className") ? json.getString("className") : null;
        HashMap<String, Object> props = new HashMap<String, Object>();
        JsonObject jsonProps = json.getObject("props");
        if (jsonProps != null) {
            for (String key : jsonProps.keys()) {
                props.put(key, JavaComponent.propertyValueFromJson(jsonProps.get(key)));
            }
        }
        Metadata metadata = new Metadata();
        if (json.hasKey("metadata") && (jsonMetadata = json.getObject("metadata")).hasKey("itemType") && (itemType = jsonMetadata.get("itemType")).getType() == JsonType.STRING) {
            metadata.setItemType(itemType.asString());
        }
        ArrayList<JavaComponent> children = new ArrayList<JavaComponent>();
        JsonArray jsonChildren = json.getArray("children");
        if (jsonChildren != null) {
            for (int i = 0; i < jsonChildren.length(); ++i) {
                JavaComponent child = JavaComponent.componentFromJson(jsonChildren.getObject(i));
                if ("prefix".equals(child.props.get("slot"))) {
                    child.props.remove("slot");
                    props.put("prefixComponent", child);
                    continue;
                }
                if ("suffix".equals(child.props.get("slot"))) {
                    child.props.remove("slot");
                    props.put("suffixComponent", child);
                    continue;
                }
                if ("add-button".equals(child.props.get("slot"))) {
                    child.props.remove("slot");
                    props.put("uploadButton", child);
                    continue;
                }
                children.add(child);
            }
        }
        return new JavaComponent(tag, className, props, children, metadata);
    }

    public static List<JavaComponent> componentsFromJson(JsonArray template) {
        return JsonUtils.stream((JsonArray)template).map(JsonObject.class::cast).map(JavaComponent::componentFromJson).toList();
    }

    @JsonIgnore
    public List<Map<String, Object>> getItemsFromProperty() {
        if (this.props.containsKey("items")) {
            return (List)this.props.get("items");
        }
        if (this.props.containsKey("dataProvider")) {
            return (List)this.props.get("dataProvider");
        }
        return new ArrayList<Map<String, Object>>();
    }

    public static class Metadata {
        private String localVariableName;
        private String fieldVariableName;
        private String originalClassName;
        private String itemType;

        public String getLocalVariableName() {
            return this.localVariableName;
        }

        public void setLocalVariableName(String localVariableName) {
            this.localVariableName = localVariableName;
        }

        public String getFieldVariableName() {
            return this.fieldVariableName;
        }

        public void setFieldVariableName(String fieldVariableName) {
            this.fieldVariableName = fieldVariableName;
        }

        public String getOriginalClassName() {
            return this.originalClassName;
        }

        public void setOriginalClassName(String originalClassName) {
            this.originalClassName = originalClassName;
        }

        public String getItemType() {
            return this.itemType;
        }

        public void setItemType(String itemType) {
            this.itemType = itemType;
        }
    }
}

