/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.javarewriter;

import com.github.javaparser.Range;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.observer.AstObserver;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.vaadin.copilot.IdentityHashSet;
import com.vaadin.copilot.javarewriter.JavaRewriterUtil;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class JavaRewriterObserver
implements AstObserver {
    private final Set<Range> removedRanges = new HashSet<Range>();
    private final Set<Node> addedOrModifiedNodes = new IdentityHashSet<Node>();

    public void propertyChange(Node observedNode, ObservableProperty property, Object oldValue, Object newValue) {
        if (property == ObservableProperty.COMMENT && newValue instanceof Comment) {
            Comment comment = (Comment)newValue;
            this.addedOrModifiedNodes.add((Node)comment);
        } else if (property == ObservableProperty.NAME) {
            this.markRemoved(observedNode);
            this.addedOrModifiedNodes.add(observedNode);
        }
    }

    public void parentChange(Node observedNode, Node previousParent, Node newParent) {
        if (newParent == null) {
            this.markRemoved(observedNode);
        } else {
            this.addedOrModifiedNodes.add(observedNode);
        }
    }

    public void listChange(NodeList<?> observedNode, AstObserver.ListChangeType type, int index, Node nodeAddedOrRemoved) {
        Node parentNode = observedNode.getParentNode().orElse(null);
        if (parentNode != null) {
            if (!(parentNode instanceof CompilationUnit || parentNode instanceof ClassOrInterfaceDeclaration || parentNode instanceof BlockStmt)) {
                this.markRemoved(parentNode);
                this.addedOrModifiedNodes.add(parentNode);
                return;
            }
            if (nodeAddedOrRemoved instanceof FieldDeclaration && parentNode instanceof ClassOrInterfaceDeclaration && type.equals((Object)AstObserver.ListChangeType.REMOVAL)) {
                nodeAddedOrRemoved.getRange().ifPresent(this.removedRanges::add);
                return;
            }
        }
        if (type == AstObserver.ListChangeType.ADDITION) {
            this.addedOrModifiedNodes.add(nodeAddedOrRemoved);
        }
    }

    public void listReplacement(NodeList<?> observedNode, int index, Node oldNode, Node newNode) {
        this.markRemoved(oldNode);
        this.addedOrModifiedNodes.add(newNode);
    }

    private void markRemoved(Node node) {
        Optional.ofNullable(JavaRewriterUtil.findAncestor(node, Statement.class)).flatMap(Node::getRange).ifPresent(this.removedRanges::add);
        Optional.ofNullable(JavaRewriterUtil.findAncestor(node, FieldDeclaration.class)).flatMap(Node::getRange).ifPresent(this.removedRanges::add);
    }

    public Set<Node> getAddedOrModifiedNodes() {
        return this.addedOrModifiedNodes;
    }

    public Set<Range> getRemovedRanges() {
        return this.removedRanges;
    }
}

