/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.ErrorMessageProvider;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public abstract class AbstractStringToNumberConverter<T extends Number>
implements Converter<String, T> {
    private final ErrorMessageProvider errorMessageProvider;
    private T emptyValue;

    protected AbstractStringToNumberConverter(T emptyValue, ErrorMessageProvider errorMessageProvider) {
        this.emptyValue = emptyValue;
        this.errorMessageProvider = errorMessageProvider;
    }

    protected AbstractStringToNumberConverter(T emptyValue, String errorMessage) {
        this(emptyValue, (ErrorMessageProvider & Serializable)(ValueContext ctx) -> errorMessage);
    }

    protected NumberFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return NumberFormat.getNumberInstance(locale);
    }

    protected Result<Number> convertToNumber(String value, ValueContext context) {
        if (value == null) {
            return Result.ok(null);
        }
        value = value.trim();
        ParsePosition parsePosition = new ParsePosition(0);
        Number parsedValue = this.getFormat(context.getLocale().orElse(null)).parse(value, parsePosition);
        if (parsePosition.getIndex() != value.length()) {
            return Result.error(this.getErrorMessage(context));
        }
        if (parsedValue == null) {
            return Result.ok(this.emptyValue);
        }
        return Result.ok(parsedValue);
    }

    protected String getErrorMessage(ValueContext context) {
        return this.errorMessageProvider.apply(context);
    }

    @Override
    public String convertToPresentation(T value, ValueContext context) {
        if (value == null) {
            return null;
        }
        return this.getFormat(context.getLocale().orElse(null)).format(value);
    }
}

