/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.SimpleResult;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

class ValidationResultWrap<R>
implements Result<R> {
    private final List<ValidationResult> resultList;
    private final Result<R> wrappedResult;

    ValidationResultWrap(Result<R> result, List<ValidationResult> resultList) {
        this.resultList = resultList;
        this.wrappedResult = result;
    }

    ValidationResultWrap(R value, ValidationResult result) {
        this.wrappedResult = result.isError() ? new SimpleResult<Object>(null, result.getErrorMessage()) : new SimpleResult<R>(value, null);
        this.resultList = new ArrayList<ValidationResult>();
        this.resultList.add(result);
    }

    List<ValidationResult> getValidationResults() {
        return Collections.unmodifiableList(this.resultList);
    }

    Result<R> getWrappedResult() {
        return this.wrappedResult;
    }

    @Override
    public <S> Result<S> flatMap(SerializableFunction<R, Result<S>> mapper) {
        Result<S> result = this.wrappedResult.flatMap(mapper);
        if (!(result instanceof ValidationResultWrap)) {
            return new ValidationResultWrap<S>(result, this.resultList);
        }
        ArrayList<ValidationResult> currentResults = new ArrayList<ValidationResult>(this.resultList);
        ValidationResultWrap resultWrap = (ValidationResultWrap)result;
        currentResults.addAll(resultWrap.getValidationResults());
        return new ValidationResultWrap<R>(resultWrap.getWrappedResult(), currentResults);
    }

    @Override
    public void handle(SerializableConsumer<R> ifOk, SerializableConsumer<String> ifError) {
        this.wrappedResult.handle(ifOk, ifError);
    }

    @Override
    public boolean isError() {
        return this.wrappedResult.isError();
    }

    @Override
    public Optional<String> getMessage() {
        return this.wrappedResult.getMessage();
    }

    @Override
    public <X extends Throwable> R getOrThrow(SerializableFunction<String, ? extends X> exceptionProvider) throws X {
        return this.wrappedResult.getOrThrow(exceptionProvider);
    }
}

