/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.KeyMapper;
import com.vaadin.flow.data.provider.QuerySortOrder;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalArrayUpdater;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalCommunicationController;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.HierarchyMapper;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.Range;
import com.vaadin.flow.internal.StateNode;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class HierarchicalDataCommunicator<T>
extends DataCommunicator<T> {
    private final HierarchicalArrayUpdater arrayUpdater;
    private final StateNode stateNode;
    private HierarchyMapper<T, ?> mapper;
    private DataGenerator<T> dataGenerator;
    private final SerializableSupplier<ValueProvider<T, String>> uniqueKeyProviderSupplier;
    private final Map<String, HierarchicalCommunicationController<T>> dataControllers = new HashMap<String, HierarchicalCommunicationController<T>>();

    public HierarchicalDataCommunicator(CompositeDataGenerator<T> dataGenerator, HierarchicalArrayUpdater arrayUpdater, SerializableConsumer<JsonArray> dataUpdater, StateNode stateNode, SerializableSupplier<ValueProvider<T, String>> uniqueKeyProviderSupplier) {
        super(dataGenerator, arrayUpdater, dataUpdater, stateNode);
        this.dataGenerator = dataGenerator;
        this.arrayUpdater = arrayUpdater;
        this.stateNode = stateNode;
        this.uniqueKeyProviderSupplier = uniqueKeyProviderSupplier;
        KeyMapperWrapper keyMapperWrapper = new KeyMapperWrapper();
        this.setKeyMapper(keyMapperWrapper);
        dataGenerator.addDataGenerator(this::generateTreeData);
        this.setDataProvider(new TreeDataProvider(new TreeData()), (Object)null);
    }

    private void generateTreeData(T item, JsonObject jsonObject) {
        Optional.ofNullable(this.getParentItem(item)).ifPresent(parent -> jsonObject.put("parentUniqueKey", this.getKeyMapper().key(parent)));
    }

    private void requestFlush(HierarchicalArrayUpdater.HierarchicalUpdate update) {
        SerializableConsumer & Serializable flushRequest = (SerializableConsumer & Serializable)context -> update.commit();
        this.stateNode.runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(this.stateNode, flushRequest));
    }

    private void requestFlush(HierarchicalCommunicationController<T> update) {
        SerializableConsumer & Serializable flushRequest = (SerializableConsumer & Serializable)context -> update.flush();
        this.stateNode.runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(this.stateNode, flushRequest));
    }

    @Override
    public void reset() {
        super.reset();
        if (!this.dataControllers.isEmpty()) {
            this.dataControllers.values().forEach(HierarchicalCommunicationController::unregisterPassivatedKeys);
            this.dataControllers.clear();
        }
        if (this.getHierarchyMapper() != null) {
            HierarchicalArrayUpdater.HierarchicalUpdate update = this.arrayUpdater.startUpdate(this.getHierarchyMapper().getRootSize());
            update.enqueue("$connector.ensureHierarchy", new Serializable[0]);
            Collection<T> expandedItems = this.getHierarchyMapper().getExpandedItems();
            if (!expandedItems.isEmpty()) {
                Serializable[] serializableArray = new Serializable[1];
                serializableArray[0] = (Serializable)expandedItems.stream().map(this.getKeyMapper()::key).map(key -> {
                    JsonObject json = Json.createObject();
                    json.put("key", key);
                    return json;
                }).collect(JsonUtils.asArray());
                update.enqueue("$connector.expandItems", serializableArray);
            }
            this.requestFlush(update);
        }
    }

    @Override
    protected void handleDataRefreshEvent(DataChangeEvent.DataRefreshEvent<T> event) {
        T item;
        if (event.isRefreshChildren() && this.isExpanded(item = event.getItem())) {
            HierarchicalCommunicationController<T> dataController;
            String parentKey = this.getKeyMapper().key(item);
            if (!this.dataControllers.containsKey(parentKey)) {
                this.setParentRequestedRange(0, this.mapper.countChildItems(item), item);
            }
            if ((dataController = this.dataControllers.get(parentKey)) != null) {
                dataController.setResendEntireRange(true);
                this.requestFlush(dataController);
            }
        }
        super.handleDataRefreshEvent(event);
    }

    @Override
    public Stream<T> fetchFromProvider(int offset, int limit) {
        return this.mapper.fetchRootItems(Range.withLength((int)offset, (int)limit));
    }

    public void setParentRequestedRange(int start, int length, T parentItem) {
        String parentKey = this.getKeyMapper().key(parentItem);
        HierarchicalCommunicationController controller = this.dataControllers.computeIfAbsent(parentKey, key -> new HierarchicalCommunicationController(parentKey, this.getKeyMapper(), this.mapper, this.dataGenerator, (SerializableFunction<Integer, HierarchicalArrayUpdater.HierarchicalUpdate>)(SerializableFunction & Serializable)size -> this.arrayUpdater.startUpdate(this.getDataProviderSize()), (SerializableBiFunction & Serializable)(pkey, range) -> this.mapper.fetchChildItems(this.getKeyMapper().get((String)pkey), (Range)range)));
        controller.setRequestRange(start, length);
        this.requestFlush(controller);
    }

    @Override
    public HierarchicalDataProvider<T, ?> getDataProvider() {
        return (HierarchicalDataProvider)super.getDataProvider();
    }

    @Override
    public <F> SerializableConsumer<F> setDataProvider(HierarchicalDataProvider<T, F> dataProvider, F initialFilter) {
        if (this.mapper != null) {
            this.mapper.destroyAllData();
        }
        this.mapper = this.createHierarchyMapper(dataProvider);
        SerializableConsumer<F> consumer = super.setDataProvider(dataProvider, initialFilter);
        this.mapper.setBackEndSorting(this.getBackEndSorting());
        this.mapper.setInMemorySorting(this.getInMemorySorting());
        this.mapper.setFilter(this.getFilter());
        return consumer;
    }

    protected <F> HierarchyMapper<T, F> createHierarchyMapper(HierarchicalDataProvider<T, F> dataProvider) {
        return new HierarchyMapper<T, F>(dataProvider);
    }

    @Override
    public <F> SerializableConsumer<F> setDataProvider(DataProvider<T, F> dataProvider, F initialFilter) {
        if (dataProvider instanceof HierarchicalDataProvider) {
            return this.setDataProvider((HierarchicalDataProvider)dataProvider, initialFilter);
        }
        throw new IllegalArgumentException("Only " + HierarchicalDataProvider.class.getName() + " and subtypes supported.");
    }

    public void confirmUpdate(int id, String parentKey) {
        Optional.ofNullable(this.dataControllers.get(parentKey)).ifPresent(controller -> {
            controller.confirmUpdate(id);
            this.requestFlush((HierarchicalCommunicationController<T>)controller);
        });
    }

    public void collapse(T item) {
        this.collapse(item, true);
    }

    protected void collapse(T item, boolean syncClient) {
        this.doCollapse(Arrays.asList(item), syncClient);
    }

    public Collection<T> collapse(Collection<T> items) {
        return this.doCollapse(items, true);
    }

    private Collection<T> doCollapse(Collection<T> items, boolean syncClient) {
        ArrayList collapsedItems = new ArrayList();
        items.forEach(item -> {
            if (this.mapper.collapse(item)) {
                collapsedItems.add(item);
                HierarchicalCommunicationController<T> controller = this.dataControllers.remove(this.getKeyMapper().key(item));
                if (controller != null) {
                    controller.unregisterPassivatedKeys();
                }
            }
        });
        if (syncClient && !collapsedItems.isEmpty()) {
            HierarchicalArrayUpdater.HierarchicalUpdate update = this.arrayUpdater.startUpdate(this.getHierarchyMapper().getRootSize());
            update.enqueue("$connector.collapseItems", (Serializable)collapsedItems.stream().map(this::generateJsonForExpandedOrCollapsedItem).collect(JsonUtils.asArray()));
            this.requestFlush(update);
        }
        return collapsedItems;
    }

    public void expand(T item) {
        this.expand(item, true);
    }

    public Collection<T> expand(Collection<T> items) {
        return this.doExpand(items, true);
    }

    protected void expand(T item, boolean syncClient) {
        this.doExpand(Arrays.asList(item), syncClient);
    }

    private Collection<T> doExpand(Collection<T> items, boolean syncClient) {
        ArrayList expandedItems = new ArrayList();
        items.forEach(item -> {
            if (this.mapper.expand(item)) {
                expandedItems.add(item);
            }
        });
        if (syncClient && !expandedItems.isEmpty()) {
            HierarchicalArrayUpdater.HierarchicalUpdate update = this.arrayUpdater.startUpdate(this.getHierarchyMapper().getRootSize());
            update.enqueue("$connector.expandItems", (Serializable)expandedItems.stream().map(this::generateJsonForExpandedOrCollapsedItem).collect(JsonUtils.asArray()));
            this.requestFlush(update);
        }
        return expandedItems;
    }

    public boolean hasChildren(T item) {
        return this.mapper.hasChildren(item);
    }

    public boolean isExpanded(T item) {
        return this.mapper.isExpanded(item);
    }

    public Integer getParentIndex(T item) {
        return this.mapper.getParentIndex(item);
    }

    public Integer getIndex(T item) {
        return Optional.ofNullable(this.mapper.getIndex(item)).filter(index -> index >= 0).orElse(null);
    }

    public T getParentItem(T item) {
        return this.mapper.getParentOfItem(item);
    }

    public int getDepth(T item) {
        return this.mapper.getDepth(item);
    }

    @Override
    public int getDataProviderSize() {
        return this.mapper.getRootSize();
    }

    @Override
    public void setBackEndSorting(List<QuerySortOrder> sortOrder) {
        if (this.mapper != null) {
            this.mapper.setBackEndSorting(sortOrder);
        }
        super.setBackEndSorting(sortOrder);
    }

    @Override
    public void setInMemorySorting(SerializableComparator<T> comparator) {
        if (this.mapper != null) {
            this.mapper.setInMemorySorting((Comparator<T>)comparator);
        }
        super.setInMemorySorting(comparator);
    }

    protected <F> void setFilter(F filter) {
        if (this.mapper != null) {
            this.mapper.setFilter(filter);
        }
    }

    public boolean hasExpandedItems() {
        return this.mapper.hasExpandedItems();
    }

    protected HierarchyMapper<T, ?> getHierarchyMapper() {
        return this.mapper;
    }

    private JsonValue generateJsonForExpandedOrCollapsedItem(T item) {
        JsonObject json = Json.createObject();
        json.put("key", this.getKeyMapper().key(item));
        return json;
    }

    private class KeyMapperWrapper<V>
    extends KeyMapper<T> {
        private T object;

        private KeyMapperWrapper() {
        }

        @Override
        public String key(T o) {
            this.object = o;
            try {
                String string = super.key(o);
                return string;
            }
            finally {
                this.object = null;
            }
        }

        @Override
        protected String createKey() {
            return Optional.ofNullable((ValueProvider)HierarchicalDataCommunicator.this.uniqueKeyProviderSupplier.get()).map(provider -> (String)provider.apply(this.object)).orElse(super.createKey());
        }
    }
}

