/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.maven.InvocationRequestBuilder;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

@Mojo(name="generate-maven-sbom", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class GenerateMavenBOMMojo
extends AbstractMojo {
    private static final String GROUP = "org.cyclonedx";
    private static final String ARTIFACT = "cyclonedx-maven-plugin";
    private static final String VERSION = "2.7.10";
    private static final String GOAL = "makeAggregateBom";
    private static final String PROJECT_TYPE = "projectType";
    private static final String SCHEMA_VERSION = "schemaVersion";
    private static final String INCLUDE_BOM_SERIAL_NUMBER = "includeBomSerialNumber";
    private static final String INCLUDE_COMPILE_SCOPE = "includeCompileScope";
    private static final String INCLUDE_PROVIDED_SCOPE = "includeProvidedScope";
    private static final String INCLUDE_RUNTIME_SCOPE = "includeRuntimeScope";
    private static final String INCLUDE_TEST_SCOPE = "includeTestScope";
    private static final String INCLUDE_SYSTEM_SCOPE = "includeSystemScope";
    private static final String INCLUDE_LICENSE_TEXT = "includeLicenseText";
    private static final String OUTPUT_REACTOR_PROJECTS = "outputReactorProjects";
    private static final String OUTPUT_FORMAT = "outputFormat";
    private static final String OUTPUT_NAME = "outputName";
    private static final String OUTPUT_DIRECTORY = "outputDirectory";
    private static final String EXCLUDE_TYPES = "excludeTypes";
    private static final String EXCLUDE_ARTIFACT_ID = "excludeArtifactId";
    private static final String EXCLUDE_GROUP_ID = "excludeGroupId";
    private static final String EXCLUDE_TEST_PROJECT = "excludeTestProject";
    private static final String CYCLONEDX_VERBOSE = "cyclonedx.verbose";
    private static final String VERBOSE = "verbose";
    @Parameter(property="projectType", defaultValue="application")
    private String projectType;
    @Parameter(property="schemaVersion", defaultValue="1.4")
    private String schemaVersion;
    @Parameter(property="includeBomSerialNumber", defaultValue="true")
    private boolean includeBomSerialNumber;
    @Parameter(property="includeCompileScope", defaultValue="true")
    private boolean includeCompileScope;
    @Parameter(property="includeProvidedScope", defaultValue="true")
    private boolean includeProvidedScope;
    @Parameter(property="includeRuntimeScope", defaultValue="true")
    private boolean includeRuntimeScope;
    @Parameter(property="includeTestScope", defaultValue="false")
    private boolean includeTestScope;
    @Parameter(property="includeSystemScope", defaultValue="true")
    private boolean includeSystemScope;
    @Parameter(property="includeLicenseText", defaultValue="false")
    private boolean includeLicenseText;
    @Parameter(property="outputReactorProjects", defaultValue="true")
    private boolean outputReactorProjects;
    @Parameter(property="outputFormat", defaultValue="json")
    private String outputFormat;
    @Parameter(property="outputName", defaultValue="bom")
    private String outputName;
    @Parameter(property="outputDirectory", defaultValue="${project.build.outputDirectory}/resources")
    private String outputDirectory;
    @Parameter(property="excludeTypes")
    private String[] excludeTypes;
    @Parameter(property="excludeArtifactId")
    private String[] excludeArtifactId;
    @Parameter(property="excludeGroupId")
    private String[] excludeGroupId;
    @Parameter(property="excludeTestProject", defaultValue="false")
    private boolean excludeTestProject;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        InvocationRequestBuilder requestBuilder = new InvocationRequestBuilder();
        InvocationRequest request = requestBuilder.groupId(GROUP).artifactId(ARTIFACT).version(VERSION).goal(GOAL).createInvocationRequest();
        Properties properties = new Properties();
        properties.setProperty(PROJECT_TYPE, this.projectType);
        properties.setProperty(SCHEMA_VERSION, this.schemaVersion);
        properties.setProperty(INCLUDE_BOM_SERIAL_NUMBER, String.valueOf(this.includeBomSerialNumber));
        properties.setProperty(INCLUDE_COMPILE_SCOPE, String.valueOf(this.includeCompileScope));
        properties.setProperty(INCLUDE_PROVIDED_SCOPE, String.valueOf(this.includeProvidedScope));
        properties.setProperty(INCLUDE_RUNTIME_SCOPE, String.valueOf(this.includeRuntimeScope));
        properties.setProperty(INCLUDE_TEST_SCOPE, String.valueOf(this.includeTestScope));
        properties.setProperty(INCLUDE_SYSTEM_SCOPE, String.valueOf(this.includeSystemScope));
        properties.setProperty(INCLUDE_LICENSE_TEXT, String.valueOf(this.includeLicenseText));
        properties.setProperty(OUTPUT_REACTOR_PROJECTS, String.valueOf(this.outputReactorProjects));
        properties.setProperty(OUTPUT_FORMAT, this.outputFormat);
        properties.setProperty(OUTPUT_NAME, this.outputName);
        properties.setProperty(OUTPUT_DIRECTORY, this.outputDirectory);
        properties.setProperty(EXCLUDE_TYPES, String.join((CharSequence)",", this.excludeTypes));
        properties.setProperty(EXCLUDE_ARTIFACT_ID, String.join((CharSequence)",", this.excludeArtifactId));
        properties.setProperty(EXCLUDE_GROUP_ID, String.join((CharSequence)",", this.excludeGroupId));
        properties.setProperty(EXCLUDE_TEST_PROJECT, String.valueOf(this.excludeTestProject));
        properties.setProperty(CYCLONEDX_VERBOSE, String.valueOf(this.verbose));
        request.setProperties(properties);
        DefaultInvoker invoker = new DefaultInvoker();
        try {
            InvocationResult result = invoker.execute(request);
            if (result.getExitCode() != 0) {
                throw new MojoFailureException("Maven SBOM generation failed.", (Throwable)result.getExecutionException());
            }
        }
        catch (MavenInvocationException e) {
            throw new MojoExecutionException("Error during Maven SBOM generation", (Exception)((Object)e));
        }
    }
}

