/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.base;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.utils.LookupImpl;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Set;

public interface PluginAdapterBase {
    public File applicationProperties();

    default public Lookup createLookup(ClassFinder classFinder) {
        return Lookup.compose((Lookup)Lookup.of((Object)classFinder, (Class[])new Class[]{ClassFinder.class}), (Lookup)new LookupImpl(classFinder));
    }

    public boolean eagerServerLoad();

    public File frontendDirectory();

    public File generatedFolder();

    public File generatedTsFolder();

    public ClassFinder getClassFinder();

    public Set<File> getJarFiles();

    public boolean isJarProject();

    public String getUseDeprecatedV14Bootstrapping();

    public boolean isDebugEnabled();

    default public boolean isUseDeprecatedV14Bootstrapping() {
        String useDeprecatedV14Bootstrapping = this.getUseDeprecatedV14Bootstrapping();
        if (useDeprecatedV14Bootstrapping == null) {
            return false;
        }
        if (useDeprecatedV14Bootstrapping.isEmpty()) {
            return true;
        }
        return Boolean.parseBoolean(useDeprecatedV14Bootstrapping);
    }

    public File javaSourceFolder();

    public File javaResourceFolder();

    public void logDebug(CharSequence var1);

    public void logInfo(CharSequence var1);

    public void logWarn(CharSequence var1);

    public void logWarn(CharSequence var1, Throwable var2);

    public void logError(CharSequence var1, Throwable var2);

    public URI nodeDownloadRoot() throws URISyntaxException;

    public boolean nodeAutoUpdate();

    public String nodeVersion();

    public File npmFolder();

    public File openApiJsonFile();

    public boolean pnpmEnable();

    public boolean useGlobalPnpm();

    public boolean productionMode();

    public Path projectBaseDirectory();

    public boolean requireHomeNodeExec();

    public File servletResourceOutputDirectory();

    public File webpackOutputDirectory();

    public String buildFolder();
}

