/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.polymertemplate;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.polymertemplate.IdMapper;
import com.vaadin.flow.component.polymertemplate.InjectablePolymerElementInitializer;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.component.polymertemplate.TemplateDataAnalyzer;
import com.vaadin.flow.component.polymertemplate.TemplateParser;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.ReflectionCache;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import com.vaadin.flow.server.VaadinService;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

@Deprecated
public class TemplateInitializer {
    private static final ConcurrentHashMap<TemplateParser, ReflectionCache<PolymerTemplate<?>, TemplateDataAnalyzer.PolymerParserData>> CACHE = new ConcurrentHashMap();
    private static final ReflectionCache<PolymerTemplate<?>, Map<String, Class<? extends Component>>> USES_CACHE = new ReflectionCache(TemplateInitializer::extractUsesMap);
    private final PolymerTemplate<?> template;
    private final Class<? extends PolymerTemplate<?>> templateClass;
    private final TemplateDataAnalyzer.PolymerParserData parserData;
    private IdMapper idMapper;

    public TemplateInitializer(PolymerTemplate<?> template, TemplateParser parser, VaadinService service) {
        this.template = template;
        this.idMapper = new IdMapper(template);
        boolean productionMode = service.getDeploymentConfiguration().isProductionMode();
        this.templateClass = ((Object)template).getClass();
        TemplateDataAnalyzer.PolymerParserData data = null;
        if (productionMode) {
            ReflectionCache cache = CACHE.computeIfAbsent(parser, analyzer -> new ReflectionCache((SerializableFunction & Serializable)clazz -> new TemplateDataAnalyzer((Class<? extends PolymerTemplate<?>>)clazz, (TemplateParser)analyzer, service).parseTemplate()));
            data = (TemplateDataAnalyzer.PolymerParserData)((Object)cache.get(this.templateClass));
        }
        if (data == null) {
            data = new TemplateDataAnalyzer(this.templateClass, parser, service).parseTemplate();
        }
        this.parserData = data;
    }

    public void initChildElements() {
        this.idMapper.reset();
        this.mapComponents();
        this.createSubTemplates();
    }

    public Set<String> getTwoWayBindingPaths() {
        return this.parserData.getTwoWayBindingPaths();
    }

    private void doRequestAttachCustomElement(String id, String tag, JsonArray path) {
        if (this.idMapper.isMapped(id)) {
            return;
        }
        Element element = new Element(tag);
        VirtualChildrenList list = (VirtualChildrenList)this.getElement().getNode().getFeature(VirtualChildrenList.class);
        list.append(element.getNode(), "subTemplate", (JsonValue)path);
        this.attachComponentIfUses(element);
    }

    public static Optional<Class<? extends Component>> getUsesClass(Class<? extends PolymerTemplate<?>> templateType, String tagName) {
        return Optional.ofNullable(((Map)USES_CACHE.get(templateType)).get(tagName.toLowerCase(Locale.ROOT)));
    }

    private void attachComponentIfUses(Element element) {
        TemplateInitializer.getUsesClass(this.templateClass, element.getTag()).ifPresent(componentClass -> Component.from((Element)element, (Class)componentClass));
    }

    private void mapComponents() {
        this.parserData.forEachInjectedField((field, id, tag) -> this.idMapper.mapComponentOrElement(field, id, tag, element -> {
            InjectablePolymerElementInitializer initializer = new InjectablePolymerElementInitializer((Element)element, (Class<? extends Component>)this.templateClass);
            initializer.accept(this.parserData.getAttributes(id));
            this.attachComponentIfUses((Element)element);
        }));
    }

    private Element getElement() {
        return this.template.getElement();
    }

    private void createSubTemplates() {
        this.parserData.forEachSubTemplate(data -> this.doRequestAttachCustomElement(data.getId(), data.getTag(), data.getPath()));
    }

    private static Map<String, Class<? extends Component>> extractUsesMap(Class<PolymerTemplate<?>> templateType) {
        HashMap<String, Class<? extends Component>> map = new HashMap<String, Class<? extends Component>>();
        BiConsumer<String, Class> add = (tag, type) -> {
            Class previous = map.put((String)tag, (Class<? extends Component>)type);
            if (previous != null && previous != type) {
                throw new IllegalStateException(templateType + " has multiple @Uses classes with the tag name " + tag + ": " + type.getName() + " and " + previous.getName());
            }
        };
        AnnotationReader.getAnnotationValuesFor(templateType, Uses.class, Uses::value).forEach(usedType -> AnnotationReader.getAnnotationValueFor((Class)usedType, Tag.class, Tag::value).map(tag -> tag.toLowerCase(Locale.ROOT)).ifPresent(tag -> add.accept((String)tag, (Class)usedType)));
        return map;
    }
}

