/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.function.SerializableBiPredicate;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;

public class AbstractFieldSupport<C extends Component, T>
implements Serializable {
    private final T defaultValue;
    private final C component;
    private final SerializableBiPredicate<T, T> valueEquals;
    private final SerializableConsumer<T> setPresentationValue;
    private T bufferedValue;
    private boolean presentationUpdateInProgress;
    private boolean valueSetFromPresentationUpdate;
    private T pendingValueFromPresentation;

    public AbstractFieldSupport(C component, T defaultValue, SerializableBiPredicate<T, T> valueEquals, SerializableConsumer<T> setPresentationValue) {
        this.component = component;
        this.defaultValue = defaultValue;
        this.bufferedValue = defaultValue;
        this.valueEquals = valueEquals;
        this.setPresentationValue = setPresentationValue;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<C, T>> listener) {
        ComponentEventListener<ComponentEvent> componentListener = event -> {
            AbstractField.ComponentValueChangeEvent valueChangeEvent = (AbstractField.ComponentValueChangeEvent)event;
            listener.valueChanged(valueChangeEvent);
        };
        return ComponentUtil.addListener(this.component, AbstractField.ComponentValueChangeEvent.class, componentListener);
    }

    private AbstractField.ComponentValueChangeEvent<C, T> createValueChange(T oldValue, boolean fromClient) {
        return new AbstractField.ComponentValueChangeEvent<C, T>(this.component, (HasValue)this.component, oldValue, fromClient);
    }

    public T getValue() {
        return this.bufferedValue;
    }

    public T getEmptyValue() {
        return this.defaultValue;
    }

    public void setValue(T value) {
        this.setValue(value, false, false);
    }

    public boolean valueEquals(T value1, T value2) {
        return Objects.equals(value1, value2);
    }

    public void setModelValue(T newModelValue, boolean fromClient) {
        if (this.presentationUpdateInProgress) {
            this.valueSetFromPresentationUpdate = true;
            this.pendingValueFromPresentation = newModelValue;
            return;
        }
        this.setValue(newModelValue, true, fromClient);
    }

    private void setValue(T newValue, boolean fromInternal, boolean fromClient) {
        if (fromClient && ((HasValue)this.component).isReadOnly()) {
            this.applyValue(this.bufferedValue);
            return;
        }
        T oldValue = this.getValue();
        if (this.valueEquals.test(newValue, oldValue)) {
            return;
        }
        this.bufferedValue = newValue;
        if (!fromInternal) {
            boolean pendingInternalUpdated;
            try {
                pendingInternalUpdated = this.applyValue(newValue);
            }
            catch (RuntimeException e) {
                this.bufferedValue = oldValue;
                throw e;
            }
            if (pendingInternalUpdated) {
                if (this.valueEquals.test(this.pendingValueFromPresentation, oldValue)) {
                    this.bufferedValue = oldValue;
                    return;
                }
                this.bufferedValue = this.pendingValueFromPresentation;
            }
        }
        ComponentUtil.fireEvent(this.component, this.createValueChange(oldValue, fromClient));
    }

    private boolean applyValue(T value) {
        this.presentationUpdateInProgress = true;
        this.valueSetFromPresentationUpdate = false;
        try {
            this.setPresentationValue.accept(value);
        }
        finally {
            this.presentationUpdateInProgress = false;
        }
        return this.valueSetFromPresentationUpdate;
    }
}

