/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.polymertemplate;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.component.polymertemplate.TemplateDataAnalyzer;
import com.vaadin.flow.component.polymertemplate.TemplateParser;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.ReflectionCache;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import com.vaadin.flow.server.VaadinService;
import elemental.json.JsonArray;
import elemental.json.JsonValue;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public class TemplateInitializer {
    private static final ConcurrentHashMap<TemplateParser, ReflectionCache<PolymerTemplate<?>, TemplateDataAnalyzer.ParserData>> CACHE = new ConcurrentHashMap();
    private static final ReflectionCache<PolymerTemplate<?>, Map<String, Class<? extends Component>>> USES_CACHE = new ReflectionCache(TemplateInitializer::extractUsesMap);
    private final PolymerTemplate<?> template;
    private final Class<? extends PolymerTemplate<?>> templateClass;
    private final TemplateDataAnalyzer.ParserData parserData;
    private final Map<String, Element> registeredElementIdToInjected = new HashMap<String, Element>();

    public TemplateInitializer(PolymerTemplate<?> template, TemplateParser parser, VaadinService service) {
        this.template = template;
        boolean productionMode = service.getDeploymentConfiguration().isProductionMode();
        this.templateClass = template.getClass();
        TemplateDataAnalyzer.ParserData data = null;
        if (productionMode) {
            ReflectionCache cache = CACHE.computeIfAbsent(parser, analyzer -> new ReflectionCache(clazz -> new TemplateDataAnalyzer((Class<? extends PolymerTemplate<?>>)clazz, (TemplateParser)analyzer, service).parseTemplate()));
            data = (TemplateDataAnalyzer.ParserData)cache.get(this.templateClass);
        }
        if (data == null) {
            data = new TemplateDataAnalyzer(this.templateClass, parser, service).parseTemplate();
        }
        this.parserData = data;
    }

    public void initChildElements() {
        this.registeredElementIdToInjected.clear();
        this.mapComponents();
        this.createSubTemplates();
    }

    public Set<String> getTwoWayBindingPaths() {
        return this.parserData.getTwoWayBindingPaths();
    }

    private void doRequestAttachCustomElement(String id, String tag, JsonArray path) {
        if (this.registeredElementIdToInjected.containsKey(id)) {
            return;
        }
        this.getShadowRoot();
        Element element = new Element(tag);
        VirtualChildrenList list = this.getElement().getNode().getFeature(VirtualChildrenList.class);
        list.append(element.getNode(), "subTemplate", (JsonValue)path);
        this.attachComponentIfUses(element);
    }

    public static Optional<Class<? extends Component>> getUsesClass(Class<? extends PolymerTemplate<?>> templateType, String tagName) {
        return Optional.ofNullable(USES_CACHE.get(templateType).get(tagName.toLowerCase(Locale.ROOT)));
    }

    private void attachComponentIfUses(Element element) {
        TemplateInitializer.getUsesClass(this.templateClass, element.getTag()).ifPresent(componentClass -> Component.from(element, componentClass));
    }

    private ShadowRoot getShadowRoot() {
        return this.getElement().getShadowRoot().orElseGet(() -> this.getElement().attachShadow());
    }

    private void mapComponents() {
        this.parserData.forEachInjectedField(this::tryMapComponentOrElement);
    }

    private void tryMapComponentOrElement(Field field, String id, String tag) {
        Element element = this.getElementById(id).orElse(null);
        if (element == null) {
            this.injectClientSideElement(tag, id, field);
        } else {
            this.injectServerSideElement(element, field);
        }
    }

    private void injectServerSideElement(Element element, Field field) {
        if (this.getElement().equals(element)) {
            throw new IllegalArgumentException("Cannot map the root element of the template. This is always mapped to the template instance itself (" + this.templateClass.getName() + ')');
        }
        if (element != null) {
            this.injectTemplateElement(element, field);
        }
    }

    private void injectClientSideElement(String tagName, String id, Field field) {
        Class<?> fieldType = field.getType();
        Tag tag = fieldType.getAnnotation(Tag.class);
        if (tag != null && !tagName.equalsIgnoreCase(tag.value())) {
            String msg = String.format("Class '%s' has field '%s' whose type '%s' is annotated with tag '%s' but the element defined in the HTML template with id '%s' has tag name '%s'", this.templateClass.getName(), field.getName(), fieldType.getName(), tag.value(), id, tagName);
            throw new IllegalStateException(msg);
        }
        this.attachExistingElementById(tagName, id, field);
    }

    private Optional<Element> getElementById(String id) {
        return this.getShadowRoot().getChildren().flatMap(this::flattenChildren).filter(element -> id.equals(element.getAttribute("id"))).findFirst();
    }

    private Stream<Element> flattenChildren(Element node) {
        if (node.getChildCount() > 0) {
            return node.getChildren().flatMap(this::flattenChildren);
        }
        return Stream.of(node);
    }

    private void attachExistingElementById(String tagName, String id, Field field) {
        if (tagName == null) {
            throw new IllegalArgumentException("Tag name parameter cannot be null");
        }
        Element element = this.registeredElementIdToInjected.get(id);
        if (element == null) {
            element = new Element(tagName);
            VirtualChildrenList list = this.getElement().getNode().getFeature(VirtualChildrenList.class);
            list.append(element.getNode(), "@id", id);
            this.registeredElementIdToInjected.put(id, element);
        }
        this.injectTemplateElement(element, field);
    }

    private Element getElement() {
        return this.template.getElement();
    }

    private void injectTemplateElement(Element element, Field field) {
        Class<?> fieldType = field.getType();
        if (Component.class.isAssignableFrom(fieldType)) {
            Component component;
            this.attachComponentIfUses(element);
            Optional<Component> wrappedComponent = element.getComponent();
            if (wrappedComponent.isPresent()) {
                component = wrappedComponent.get();
            } else {
                Class<?> componentType = fieldType;
                component = Component.from(element, componentType);
            }
            ReflectTools.setJavaFieldValue(this.template, field, component);
        } else if (Element.class.isAssignableFrom(fieldType)) {
            ReflectTools.setJavaFieldValue(this.template, field, element);
        } else {
            String msg = String.format("The field '%s' in '%s' has an @'%s' annotation but the field type '%s' does not extend neither '%s' nor '%s'", field.getName(), this.templateClass.getName(), Id.class.getSimpleName(), fieldType.getName(), Component.class.getSimpleName(), Element.class.getSimpleName());
            throw new IllegalArgumentException(msg);
        }
    }

    private void createSubTemplates() {
        this.parserData.forEachSubTemplate(data -> this.doRequestAttachCustomElement(data.getId(), data.getTag(), data.getPath()));
    }

    private static Map<String, Class<? extends Component>> extractUsesMap(Class<PolymerTemplate<?>> templateType) {
        HashMap<String, Class<? extends Component>> map = new HashMap<String, Class<? extends Component>>();
        BiConsumer<String, Class> add = (tag, type) -> {
            Class previous = map.put((String)tag, (Class<? extends Component>)type);
            if (previous != null && previous != type) {
                throw new IllegalStateException(templateType + " has multiple @Uses classes with the tag name " + tag + ": " + type.getName() + " and " + previous.getName());
            }
        };
        AnnotationReader.getAnnotationValuesFor(templateType, Uses.class, Uses::value).forEach(usedType -> AnnotationReader.getAnnotationValueFor(usedType, Tag.class, Tag::value).map(tag -> tag.toLowerCase(Locale.ROOT)).ifPresent(tag -> add.accept((String)tag, (Class)usedType)));
        return map;
    }
}

