/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.function;

import com.vaadin.flow.shared.communication.PushMode;
import java.io.Serializable;
import java.util.Properties;
import java.util.function.Function;

public interface DeploymentConfiguration
extends Serializable {
    public boolean isProductionMode();

    public boolean isRequestTiming();

    public boolean isXsrfProtectionEnabled();

    public boolean isSyncIdCheckEnabled();

    public int getHeartbeatInterval();

    public boolean isSendUrlsAsParameters();

    public boolean isCloseIdleSessions();

    public PushMode getPushMode();

    public String getPushURL();

    public Properties getInitParameters();

    public <T> T getApplicationOrSystemProperty(String var1, T var2, Function<String, T> var3);

    default public String getStringProperty(String propertyName, String defaultValue) {
        return this.getApplicationOrSystemProperty(propertyName, defaultValue, Function.identity());
    }

    default public boolean getBooleanProperty(String propertyName, boolean defaultValue) throws IllegalArgumentException {
        String booleanString = this.getStringProperty(propertyName, null);
        if (booleanString == null) {
            return defaultValue;
        }
        if (booleanString.isEmpty()) {
            return true;
        }
        boolean parsedBoolean = Boolean.parseBoolean(booleanString);
        if (Boolean.toString(parsedBoolean).equalsIgnoreCase(booleanString)) {
            return parsedBoolean;
        }
        throw new IllegalArgumentException(String.format("Property named '%s' is boolean, but contains incorrect value '%s' that is not boolean '%s'", propertyName, booleanString, parsedBoolean));
    }

    public String getUIClassName();

    public String getClassLoaderName();

    default public String getDevelopmentFrontendPrefix() {
        return "context://frontend/";
    }

    default public String getEs6FrontendPrefix() {
        return this.useCompiledFrontendResources() ? this.getStringProperty("frontend.url.es6", "context://frontend-es6/") : this.getDevelopmentFrontendPrefix();
    }

    default public String getEs5FrontendPrefix() {
        return this.useCompiledFrontendResources() ? this.getStringProperty("frontend.url.es5", "context://frontend-es5/") : this.getDevelopmentFrontendPrefix();
    }

    default public boolean areWebJarsEnabled() {
        return !this.getBooleanProperty("disable.webjars", this.useCompiledFrontendResources());
    }

    default public boolean useCompiledFrontendResources() {
        return this.isProductionMode() && !this.getBooleanProperty("original.frontend.resources", false);
    }

    default public boolean disableAutomaticServletRegistration() {
        return this.getBooleanProperty("disable.automatic.servlet.registration", false);
    }

    default public boolean isBrotli() {
        return this.getBooleanProperty("brotli", false);
    }
}

