/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.DebouncePhase;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.DomEvent;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.internal.ConstantPoolKey;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class ElementListenerMap
extends NodeMap {
    public static final String ALWAYS_TRUE_FILTER = "1";
    private Map<String, List<DomEventListenerWrapper>> listeners;

    public ElementListenerMap(StateNode node) {
        super(node);
    }

    public DomListenerRegistration add(String eventType, DomEventListener listener) {
        assert (eventType != null);
        assert (listener != null);
        if (!this.contains(eventType)) {
            assert (this.listeners == null || !this.listeners.containsKey(eventType));
            ArrayList listenerList = new ArrayList(1);
            if (this.listeners == null) {
                this.listeners = Collections.singletonMap(eventType, listenerList);
            } else {
                if (this.listeners.size() == 1 && !(this.listeners instanceof HashMap)) {
                    this.listeners = new HashMap<String, List<DomEventListenerWrapper>>(this.listeners);
                }
                this.listeners.put(eventType, listenerList);
            }
        }
        DomEventListenerWrapper listenerWrapper = new DomEventListenerWrapper(this, eventType, listener);
        this.listeners.get(eventType).add(listenerWrapper);
        this.updateEventSettings(eventType);
        return listenerWrapper;
    }

    private Collection<DomEventListenerWrapper> getWrappers(String eventType) {
        if (this.listeners == null) {
            return Collections.emptyList();
        }
        List<DomEventListenerWrapper> typeListeners = this.listeners.get(eventType);
        if (typeListeners == null) {
            return Collections.emptyList();
        }
        return typeListeners;
    }

    private Map<String, ExpressionSettings> collectEventExpressions(String eventType) {
        HashMap<String, ExpressionSettings> expressions = new HashMap<String, ExpressionSettings>();
        boolean hasUnfilteredListener = false;
        boolean hasFilteredListener = false;
        Function<String, ExpressionSettings> ensureExpression = expression -> expressions.computeIfAbsent((String)expression, key -> new ExpressionSettings());
        Collection<DomEventListenerWrapper> wrappers = this.getWrappers(eventType);
        for (DomEventListenerWrapper wrapper : wrappers) {
            if (wrapper.eventDataExpressions != null) {
                wrapper.eventDataExpressions.forEach(ensureExpression::apply);
            }
            String filter = wrapper.getFilter();
            int timeout = wrapper.debounceTimeout;
            if (timeout > 0 && filter == null) {
                filter = ALWAYS_TRUE_FILTER;
            }
            if (filter == null) {
                hasUnfilteredListener = true;
                continue;
            }
            hasFilteredListener = true;
            ensureExpression.apply(filter).addDebouncePhases(timeout, wrapper.debouncePhases);
        }
        if (hasFilteredListener && hasUnfilteredListener) {
            ensureExpression.apply(ALWAYS_TRUE_FILTER).addDebouncePhases(0, Collections.singleton(DebouncePhase.LEADING));
        }
        return expressions;
    }

    private void updateEventSettings(String eventType) {
        Map<String, ExpressionSettings> eventSettings = this.collectEventExpressions(eventType);
        JsonObject eventSettingsJson = JsonUtils.createObject(eventSettings, ExpressionSettings::toJson);
        ConstantPoolKey constantPoolKey = new ConstantPoolKey((JsonValue)eventSettingsJson);
        this.put(eventType, constantPoolKey);
    }

    private void removeListener(String eventType, DomEventListenerWrapper wrapper) {
        if (this.listeners == null) {
            return;
        }
        Collection listenerList = this.listeners.get(eventType);
        if (listenerList != null) {
            listenerList.remove(wrapper);
            if (listenerList.isEmpty()) {
                if (this.listeners.size() == 1) {
                    assert (this.listeners.containsKey(eventType));
                    this.listeners = null;
                } else {
                    this.listeners.remove(eventType);
                }
                this.remove(eventType);
            }
        }
    }

    public void fireEvent(DomEvent event) {
        if (this.listeners == null) {
            return;
        }
        boolean isElementEnabled = event.getSource().isEnabled();
        List<DomEventListenerWrapper> typeListeners = this.listeners.get(event.getType());
        if (typeListeners == null) {
            return;
        }
        ArrayList<DomEventListener> listeners = new ArrayList<DomEventListener>();
        for (DomEventListenerWrapper wrapper : typeListeners) {
            if (!isElementEnabled && !DisabledUpdateMode.ALWAYS.equals((Object)wrapper.mode) || !wrapper.matchesFilter(event.getEventData()) || !wrapper.matchesPhase(event.getPhase())) continue;
            listeners.add(wrapper.origin);
        }
        listeners.forEach(listener -> listener.handleEvent(event));
    }

    Set<String> getExpressions(String name) {
        assert (name != null);
        return this.collectEventExpressions(name).keySet();
    }

    public DisabledUpdateMode getPropertySynchronizationMode(String propertyName) {
        assert (propertyName != null);
        if (this.listeners == null) {
            return null;
        }
        return this.listeners.values().stream().flatMap(Collection::stream).filter(wrapper -> ((DomEventListenerWrapper)wrapper).isPropertySynchronized(propertyName)).map(wrapper -> ((DomEventListenerWrapper)wrapper).mode).reduce(DisabledUpdateMode::mostPermissive).orElse(null);
    }

    private static class DomEventListenerWrapper
    implements DomListenerRegistration {
        private final String type;
        private final DomEventListener origin;
        private final ElementListenerMap listenerMap;
        private DisabledUpdateMode mode = DisabledUpdateMode.ONLY_WHEN_ENABLED;
        private Set<String> eventDataExpressions;
        private String filter;
        private int debounceTimeout = 0;
        private EnumSet<DebouncePhase> debouncePhases = null;
        private List<SerializableRunnable> unregisterHandlers;

        private DomEventListenerWrapper(ElementListenerMap listenerMap, String type, DomEventListener origin) {
            this.listenerMap = listenerMap;
            this.type = type;
            this.origin = origin;
        }

        @Override
        public void remove() {
            if (this.unregisterHandlers != null) {
                this.unregisterHandlers.forEach(Runnable::run);
            }
            this.listenerMap.removeListener(this.type, this);
        }

        @Override
        public DomListenerRegistration addEventData(String eventData) {
            if (eventData == null) {
                throw new IllegalArgumentException("The event data expression must not be null");
            }
            if (this.eventDataExpressions == null) {
                this.eventDataExpressions = Collections.singleton(eventData);
            } else {
                if (this.eventDataExpressions.size() == 1) {
                    Set<String> oldExpressions = this.eventDataExpressions;
                    this.eventDataExpressions = new HashSet<String>(4);
                    this.eventDataExpressions.addAll(oldExpressions);
                }
                this.eventDataExpressions.add(eventData);
            }
            this.listenerMap.updateEventSettings(this.type);
            return this;
        }

        @Override
        public DomListenerRegistration setDisabledUpdateMode(DisabledUpdateMode disabledUpdateMode) {
            if (disabledUpdateMode == null) {
                throw new IllegalArgumentException("RPC comunication control mode for disabled element must not be null");
            }
            this.mode = disabledUpdateMode;
            return this;
        }

        @Override
        public DomListenerRegistration setFilter(String filter) {
            this.filter = filter;
            this.listenerMap.updateEventSettings(this.type);
            return this;
        }

        @Override
        public String getFilter() {
            return this.filter;
        }

        boolean matchesFilter(JsonObject eventData) {
            if (this.filter == null) {
                return true;
            }
            if (eventData == null) {
                return false;
            }
            return eventData.getBoolean(this.filter);
        }

        @Override
        public DomListenerRegistration debounce(int timeout, DebouncePhase firstPhase, DebouncePhase ... additionalPhases) {
            if (timeout < 0) {
                throw new IllegalArgumentException("Timeout cannot be negative");
            }
            this.debounceTimeout = timeout;
            this.debouncePhases = timeout == 0 ? null : EnumSet.of(firstPhase, additionalPhases);
            this.listenerMap.updateEventSettings(this.type);
            return this;
        }

        public boolean matchesPhase(DebouncePhase phase) {
            if (this.debouncePhases == null) {
                return phase == DebouncePhase.LEADING;
            }
            return this.debouncePhases.contains((Object)phase);
        }

        @Override
        public DomListenerRegistration onUnregister(SerializableRunnable unregisterHandler) {
            if (this.unregisterHandlers == null) {
                this.unregisterHandlers = new ArrayList<SerializableRunnable>(1);
            }
            this.unregisterHandlers.add(Objects.requireNonNull(unregisterHandler, "Unregister handler cannot be null"));
            return this;
        }

        private boolean isPropertySynchronized(String propertyName) {
            return this.eventDataExpressions != null && this.eventDataExpressions.contains("}" + propertyName);
        }
    }

    private static class ExpressionSettings
    implements Serializable {
        private Map<Integer, Set<DebouncePhase>> debounceSettings = new HashMap<Integer, Set<DebouncePhase>>();

        private ExpressionSettings() {
        }

        public void addDebouncePhases(int timeout, Set<DebouncePhase> phases) {
            if (phases == null) {
                phases = EnumSet.noneOf(DebouncePhase.class);
            }
            this.debounceSettings.merge(timeout, phases, (phases1, phases2) -> {
                EnumSet merge = EnumSet.copyOf(phases1);
                merge.addAll(phases2);
                return merge;
            });
        }

        public JsonValue toJson() {
            if (this.debounceSettings.isEmpty()) {
                return Json.create((boolean)false);
            }
            if (this.debounceSettings.size() == 1 && this.debounceSettings.containsKey(0)) {
                return Json.create((boolean)true);
            }
            return (JsonValue)this.debounceSettings.entrySet().stream().map(entry -> Stream.concat(Stream.of(Json.create((double)((Integer)entry.getKey()).intValue())), ((Set)entry.getValue()).stream().map(DebouncePhase::getIdentifier).map(Json::create)).collect(JsonUtils.asArray())).collect(JsonUtils.asArray());
        }
    }
}

