/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.shared.BrowserDetails;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;

public class WebBrowser
implements Serializable {
    private int screenHeight = -1;
    private int screenWidth = -1;
    private String browserApplication = null;
    private Locale locale;
    private String address;
    private boolean secureConnection;
    private int timezoneOffset = 0;
    private int rawTimezoneOffset = 0;
    private int dstSavings;
    private boolean dstInEffect;
    private String timeZoneId;
    private boolean touchDevice;
    private BrowserDetails browserDetails;
    private long clientServerTimeDelta;

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public String getBrowserApplication() {
        return this.browserApplication;
    }

    public String getAddress() {
        return this.address;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isSecureConnection() {
        return this.secureConnection;
    }

    public boolean isFirefox() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isFirefox();
    }

    public boolean isIE() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isIE();
    }

    public boolean isEdge() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isEdge();
    }

    public boolean isSafari() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isSafari();
    }

    public boolean isOpera() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isOpera();
    }

    public boolean isChrome() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isChrome();
    }

    public int getBrowserMajorVersion() {
        if (this.browserDetails == null) {
            return -1;
        }
        return this.browserDetails.getBrowserMajorVersion();
    }

    public int getBrowserMinorVersion() {
        if (this.browserDetails == null) {
            return -1;
        }
        return this.browserDetails.getBrowserMinorVersion();
    }

    public boolean isLinux() {
        return this.browserDetails.isLinux();
    }

    public boolean isMacOSX() {
        return this.browserDetails.isMacOSX();
    }

    public boolean isWindows() {
        return this.browserDetails.isWindows();
    }

    public boolean isWindowsPhone() {
        return this.browserDetails.isWindowsPhone();
    }

    public boolean isAndroid() {
        return this.browserDetails.isAndroid();
    }

    public boolean isIOS() {
        return this.browserDetails.isIOS();
    }

    public boolean isIPhone() {
        return this.browserDetails.isIPhone();
    }

    public boolean isIPad() {
        return this.browserDetails.isIPad();
    }

    public boolean isChromeOS() {
        return this.browserDetails.isChromeOS();
    }

    public int getTimezoneOffset() {
        return this.timezoneOffset;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public int getRawTimezoneOffset() {
        return this.rawTimezoneOffset;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public boolean isDSTInEffect() {
        return this.dstInEffect;
    }

    public Date getCurrentDate() {
        return new Date(new Date().getTime() + this.clientServerTimeDelta);
    }

    public boolean isTouchDevice() {
        return this.touchDevice;
    }

    void updateClientSideDetails(String sw, String sh, String tzo, String rtzo, String dstSavings, String dstInEffect, String tzId, String curDate, boolean touchDevice) {
        if (sw != null) {
            try {
                this.screenHeight = Integer.parseInt(sh);
                this.screenWidth = Integer.parseInt(sw);
            }
            catch (NumberFormatException e) {
                this.screenWidth = -1;
                this.screenHeight = -1;
            }
        }
        if (tzo != null) {
            try {
                this.timezoneOffset = -Integer.parseInt(tzo) * 60 * 1000;
            }
            catch (NumberFormatException e) {
                this.timezoneOffset = 0;
            }
        }
        if (rtzo != null) {
            try {
                this.rawTimezoneOffset = -Integer.parseInt(rtzo) * 60 * 1000;
            }
            catch (NumberFormatException e) {
                this.rawTimezoneOffset = 0;
            }
        }
        if (dstSavings != null) {
            try {
                this.dstSavings = Integer.parseInt(dstSavings) * 60 * 1000;
            }
            catch (NumberFormatException e) {
                this.dstSavings = 0;
            }
        }
        if (dstInEffect != null) {
            this.dstInEffect = Boolean.parseBoolean(dstInEffect);
        }
        this.timeZoneId = tzId == null || "undefined".equals(tzId) ? null : tzId;
        if (curDate != null) {
            try {
                long curTime = Long.parseLong(curDate);
                this.clientServerTimeDelta = curTime - new Date().getTime();
            }
            catch (NumberFormatException e) {
                this.clientServerTimeDelta = 0L;
            }
        }
        this.touchDevice = touchDevice;
    }

    public void updateRequestDetails(VaadinRequest request) {
        this.locale = request.getLocale();
        this.address = request.getRemoteAddr();
        this.secureConnection = request.isSecure();
        String agent = request.getHeader("User-Agent");
        if (agent != null) {
            this.browserApplication = agent;
            this.browserDetails = new BrowserDetails(agent);
        }
        if (request.getParameter("v-sw") != null) {
            this.updateClientSideDetails(request.getParameter("v-sw"), request.getParameter("v-sh"), request.getParameter("v-tzo"), request.getParameter("v-rtzo"), request.getParameter("v-dstd"), request.getParameter("v-dston"), request.getParameter("v-tzid"), request.getParameter("v-curdate"), request.getParameter("v-td") != null);
        }
    }

    public boolean isTooOldToFunctionProperly() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isTooOldToFunctionProperly();
    }

    public boolean isEs6Supported() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isEs6Supported();
    }

    public boolean isEs5AdapterNeeded() {
        if (this.browserDetails == null) {
            return false;
        }
        return this.browserDetails.isEs5AdapterNeeded();
    }
}

