/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceWriter;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.servlet.ServletContext;

public class StreamResourceHandler
implements Serializable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response, StreamResource streamResource) throws IOException {
        StreamResourceWriter writer;
        session.lock();
        try {
            ServletContext context = ((VaadinServletRequest)request).getServletContext();
            response.setContentType((String)streamResource.getContentTypeResolver().apply(streamResource, context));
            response.setCacheTime(streamResource.getCacheTime());
            writer = streamResource.getWriter();
            if (writer == null) {
                throw new IOException("Stream resource produces null input stream");
            }
        }
        finally {
            session.unlock();
        }
        try (OutputStream outputStream = response.getOutputStream();){
            writer.accept(outputStream, session);
        }
    }
}

