/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.MessageDigestUtil;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class ConstantPoolKey
implements Serializable {
    private final JsonValue json;
    private final String id;

    public ConstantPoolKey(JsonValue json) {
        assert (json != null);
        this.json = json;
        this.id = ConstantPoolKey.calculateHash(json);
    }

    public String getId() {
        return this.id;
    }

    public void export(JsonObject clientConstantPoolUpdate) {
        assert (this.id.equals(ConstantPoolKey.calculateHash(this.json))) : "Json value has been changed";
        clientConstantPoolUpdate.put(this.id, this.json);
    }

    private static String calculateHash(JsonValue json) {
        byte[] digest = MessageDigestUtil.sha256(json.toJson());
        ByteBuffer truncatedDigest = ByteBuffer.wrap(digest, 0, 8);
        ByteBuffer base64Bytes = Base64.getEncoder().encode(truncatedDigest);
        return StandardCharsets.US_ASCII.decode(base64Bytes).toString();
    }
}

