/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.server.DependencyFilter;
import com.vaadin.flow.server.WebBrowser;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleDependencyFilter
implements DependencyFilter {
    private final String mainBundlePath;
    private final Map<String, Set<String>> importContainedInBundles;
    private boolean isES6;

    public BundleDependencyFilter(WebBrowser browser, String mainBundlePath, Map<String, Set<String>> importContainedInBundles) {
        this.mainBundlePath = Objects.requireNonNull(mainBundlePath, "Main bundle name cannot be null");
        this.importContainedInBundles = Objects.requireNonNull(importContainedInBundles, "Import to bundle mapping cannot be null");
        this.isES6 = browser.isEs6Supported();
    }

    @Override
    public List<Dependency> filter(List<Dependency> dependencies, DependencyFilter.FilterContext filterContext) {
        if (filterContext.getBrowser().isEs6Supported() != this.isES6) {
            return dependencies;
        }
        LinkedHashSet fragments = new LinkedHashSet(dependencies.size());
        LinkedHashSet<Dependency> notFragments = new LinkedHashSet<Dependency>(dependencies.size());
        for (Dependency dependency : dependencies) {
            Set<String> bundleUrls = this.importContainedInBundles.get(this.clearFlowProtocols(dependency.getUrl()));
            if (bundleUrls != null) {
                if (bundleUrls.size() > 1) {
                    BundleDependencyFilter.getLogger().warn("Dependency '{}' is contained in multiple fragments: '{}', this may lead to performance degradation", (Object)dependency, bundleUrls);
                }
                bundleUrls.stream().map(BundleDependencyFilter::createBundleDependency).forEach(fragments::add);
                continue;
            }
            notFragments.add(dependency);
        }
        ArrayList<Dependency> fragmentsFirst = new ArrayList<Dependency>();
        if (!fragments.isEmpty()) {
            Dependency mainBundle = BundleDependencyFilter.createBundleDependency(this.mainBundlePath);
            fragments.remove(mainBundle);
            fragmentsFirst.add(mainBundle);
            fragmentsFirst.addAll(fragments);
        }
        fragmentsFirst.addAll(notFragments);
        return fragmentsFirst;
    }

    private String clearFlowProtocols(String url) {
        return url.replace("context://", "").replace("frontend://", "").replace("base://", "");
    }

    private static Dependency createBundleDependency(String bundleUrl) {
        return new Dependency(Dependency.Type.HTML_IMPORT, bundleUrl, LoadMode.EAGER);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)BundleDependencyFilter.class.getName());
    }
}

