/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.dom.Element;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public final class PropertyDescriptors {
    private static final BiFunction<Object, Object, Object> NULL_TO_DEFAULT = new BiFunction<Object, Object, Object>(){

        @Override
        public Object apply(Object rawValue, Object defaultValue) {
            if (rawValue == null) {
                return defaultValue;
            }
            return rawValue;
        }
    };
    private static final BiFunction<Object, Object, Optional<Object>> DEFAULT_TO_EMPTY = new BiFunction<Object, Object, Optional<Object>>(){

        @Override
        public Optional<Object> apply(Object rawValue, Object defaultValue) {
            if (Objects.equals(rawValue, defaultValue)) {
                return Optional.empty();
            }
            return Optional.ofNullable(rawValue);
        }
    };

    private PropertyDescriptors() {
    }

    public static PropertyDescriptor<String, String> propertyWithDefault(String name, String defaultValue) {
        return new PropertyDescriptorImpl<String, String>(name, defaultValue, (element, value) -> element.setProperty(name, (String)value), element -> element.removeProperty(name), element -> element.getProperty(name, defaultValue), PropertyDescriptors.nullToDefault());
    }

    public static PropertyDescriptor<Integer, Integer> propertyWithDefault(String name, Integer defaultValue) {
        return new PropertyDescriptorImpl<Integer, Integer>(name, defaultValue, (element, value) -> element.setProperty(name, value.intValue()), element -> element.removeProperty(name), element -> element.getProperty(name, defaultValue), PropertyDescriptors.nullToDefault());
    }

    public static PropertyDescriptor<Double, Double> propertyWithDefault(String name, Double defaultValue) {
        return new PropertyDescriptorImpl<Double, Double>(name, defaultValue, (element, value) -> element.setProperty(name, (double)value), element -> element.removeProperty(name), element -> element.getProperty(name, defaultValue), PropertyDescriptors.nullToDefault());
    }

    public static PropertyDescriptor<Boolean, Boolean> propertyWithDefault(String name, Boolean defaultValue) {
        return new PropertyDescriptorImpl<Boolean, Boolean>(name, defaultValue, (element, value) -> element.setProperty(name, (boolean)value), element -> element.removeProperty(name), element -> element.getProperty(name, defaultValue), PropertyDescriptors.nullToDefault());
    }

    public static PropertyDescriptor<String, String> attributeWithDefault(String name, String defaultValue) {
        return PropertyDescriptors.attributeWithDefault(name, defaultValue, true);
    }

    public static PropertyDescriptor<String, String> attributeWithDefault(String name, String defaultValue, boolean removeDefault) {
        return PropertyDescriptors.attribute(name, defaultValue, removeDefault, PropertyDescriptors.nullToDefault());
    }

    public static PropertyDescriptor<String, Optional<String>> optionalAttributeWithDefault(String name, String defaultValue) {
        return PropertyDescriptors.optionalAttributeWithDefault(name, defaultValue, true);
    }

    public static PropertyDescriptor<String, Optional<String>> optionalAttributeWithDefault(String name, String defaultValue, boolean removeDefault) {
        return PropertyDescriptors.attribute(name, defaultValue, removeDefault, PropertyDescriptors.defaultToEmpty());
    }

    private static <T> PropertyDescriptor<String, T> attribute(String name, String defaultValue, boolean removeDefault, BiFunction<String, String, T> returnWrapper) {
        return new PropertyDescriptorImpl(name, defaultValue, (element, value) -> element.setAttribute(name, (String)value), removeDefault ? element -> element.removeAttribute(name) : element -> element.setAttribute(name, defaultValue), element -> element.getAttribute(name), returnWrapper);
    }

    private static <T> BiFunction<T, T, Optional<T>> defaultToEmpty() {
        return DEFAULT_TO_EMPTY;
    }

    private static <T> BiFunction<T, T, T> nullToDefault() {
        return NULL_TO_DEFAULT;
    }

    private static final class PropertyDescriptorImpl<S, G>
    implements PropertyDescriptor<S, G> {
        private String name;
        private S defaultValue;
        private Consumer<Element> remover;
        private Function<Element, S> getter;
        private BiFunction<S, S, G> returnWrapper;
        private BiConsumer<Element, S> setter;

        private PropertyDescriptorImpl(String name, S defaultValue, BiConsumer<Element, S> setter, Consumer<Element> remover, Function<Element, S> getter, BiFunction<S, S, G> returnWrapper) {
            assert (name != null);
            assert (defaultValue != null);
            assert (setter != null);
            assert (remover != null);
            assert (getter != null);
            this.name = name;
            this.defaultValue = defaultValue;
            this.setter = setter;
            this.remover = remover;
            this.getter = getter;
            this.returnWrapper = returnWrapper;
        }

        @Override
        public void set(Element element, S value) {
            assert (element != null);
            if (value == null) {
                throw new IllegalArgumentException("Cannot set " + this.name + " to null");
            }
            if (this.defaultValue.equals(value)) {
                this.remover.accept(element);
            } else {
                this.setter.accept(element, value);
            }
        }

        @Override
        public G get(Element element) {
            assert (element != null);
            S rawValue = this.getter.apply(element);
            return this.returnWrapper.apply(rawValue, this.defaultValue);
        }

        @Override
        public String getPropertyName() {
            return this.name;
        }
    }
}

