/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.internal.KeyboardEvent;
import java.util.Arrays;
import java.util.EnumSet;

public class KeyEventListener<E extends KeyboardEvent>
implements ComponentEventListener<E> {
    private final ComponentEventListener<E> listener;
    private final Key key;
    private final EnumSet<KeyModifier> modifiers;

    public KeyEventListener(ComponentEventListener<E> listener, Key key, KeyModifier ... modifiers) {
        this.listener = listener;
        this.key = key;
        this.modifiers = modifiers.length > 0 ? EnumSet.of(modifiers[0], (Enum[])Arrays.copyOfRange(modifiers, 1, modifiers.length)) : EnumSet.noneOf(KeyModifier.class);
    }

    @Override
    public void onComponentEvent(E event) {
        if (this.key.getKeys().stream().anyMatch(((KeyboardEvent)event).getKey()::matches) && ((KeyboardEvent)event).getModifiers().containsAll(this.modifiers)) {
            this.listener.onComponentEvent(event);
        }
    }
}

