/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyDownEvent;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutEvent;
import com.vaadin.flow.component.ShortcutEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.ExecutionContext;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class ShortcutRegistration
implements Registration,
Serializable {
    static final String LISTEN_ON_COMPONENTS_SHOULD_NOT_CONTAIN_NULL = "listenOnComponents should not contain null!";
    static final String LISTEN_ON_COMPONENTS_SHOULD_NOT_HAVE_DUPLICATE_ENTRIES = "listenOnComponents should not have duplicate entries!";
    static final String ELEMENT_LOCATOR_JS = "const listenOn=this;const delegate=%1$s;if (delegate) {delegate.addEventListener('keydown', function(event) {if (%2$s) {const new_event = new event.constructor(event.type, event);listenOn.dispatchEvent(new_event);%3$sevent.stopPropagation();}});} else {throw \"Shortcut listenOn element not found with JS locator string '%1$s'\"}";
    private boolean allowDefaultBehavior = false;
    private boolean allowEventPropagation = false;
    static final String LISTEN_ON_INITIALIZED = "_initialized_listen_on_for_component";
    private Set<Key> modifiers = new HashSet<Key>(2);
    private Key primaryKey = null;
    private StateTree.ExecutionRegistration executionRegistration;
    private CompoundRegistration lifecycleRegistration;
    private Component lifecycleOwner;
    private CompoundRegistration[] listenOnAttachListenerRegistrations;
    private CompoundRegistration[] shortcutListenerRegistrations;
    private Component[] listenOnComponents;
    private boolean shortcutActive = false;
    private SerializableSupplier<Component[]> listenOnSuppliers;
    private AtomicBoolean isDirty = new AtomicBoolean(false);
    private ShortcutEventListener eventListener;
    private List<Registration> registrations = new ArrayList<Registration>();
    private final SerializableConsumer<ExecutionContext> beforeClientResponseConsumer = executionContext -> {
        if (this.listenOnComponents == null) {
            this.initListenOnComponent();
        }
        this.addListenOnDetachListeners();
        boolean reinit = false;
        for (Component component : this.listenOnComponents) {
            if (!component.getUI().isPresent() || !component.getUI().get().isClosing()) continue;
            reinit = true;
            break;
        }
        if (reinit) {
            this.removeAllListenerRegistrations();
            this.initListenOnComponent();
            this.addListenOnDetachListeners();
        }
        for (int i = 0; i < this.listenOnComponents.length; ++i) {
            this.updateHandlerListenerRegistration(i);
        }
        this.markClean();
    };

    ShortcutRegistration(Component lifecycleOwner, SerializableSupplier<Component[]> listenOnSuppliers, ShortcutEventListener eventListener, Key key) {
        if (Key.isModifier(key)) {
            throw new IllegalArgumentException(String.format("Parameter 'key' cannot belong to %s", KeyModifier.class.getSimpleName()));
        }
        Objects.requireNonNull(listenOnSuppliers, "listenOnSuppliers may not be null!");
        this.eventListener = eventListener;
        this.listenOnSuppliers = listenOnSuppliers;
        this.setLifecycleOwner(lifecycleOwner);
        this.addKey(key);
    }

    public ShortcutRegistration withModifiers(KeyModifier ... keyModifiers) {
        this.modifiers.clear();
        this.prepareForClientResponse();
        for (KeyModifier keyModifier : keyModifiers) {
            this.addKey(keyModifier);
        }
        return this;
    }

    public ShortcutRegistration withAlt() {
        this.addKey(KeyModifier.ALT);
        return this;
    }

    public ShortcutRegistration withCtrl() {
        this.addKey(KeyModifier.CONTROL);
        return this;
    }

    public ShortcutRegistration withMeta() {
        this.addKey(KeyModifier.META);
        return this;
    }

    public ShortcutRegistration withShift() {
        this.addKey(KeyModifier.SHIFT);
        return this;
    }

    public ShortcutRegistration allowBrowserDefault() {
        if (!this.allowDefaultBehavior) {
            this.allowDefaultBehavior = true;
            this.prepareForClientResponse();
        }
        return this;
    }

    public ShortcutRegistration allowEventPropagation() {
        if (!this.allowEventPropagation) {
            this.allowEventPropagation = true;
            this.prepareForClientResponse();
        }
        return this;
    }

    public ShortcutRegistration bindLifecycleTo(Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "component"));
        }
        this.setLifecycleOwner(component);
        return this;
    }

    public ShortcutRegistration listenOn(Component listenOnComponent) {
        return this.listenOn(new Component[]{listenOnComponent});
    }

    public ShortcutRegistration listenOn(Component ... listenOnComponents) {
        Objects.requireNonNull(listenOnComponents, "listenOnComponents must not be null!");
        if (Arrays.stream(listenOnComponents).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException(LISTEN_ON_COMPONENTS_SHOULD_NOT_CONTAIN_NULL);
        }
        if (this.hasDuplicate(listenOnComponents)) {
            throw new IllegalArgumentException(LISTEN_ON_COMPONENTS_SHOULD_NOT_HAVE_DUPLICATE_ENTRIES);
        }
        this.removeAllListenerRegistrations();
        Component[] copyOfListenOnComponents = Arrays.copyOf(listenOnComponents, listenOnComponents.length);
        this.listenOnSuppliers = () -> copyOfListenOnComponents;
        this.prepareForClientResponse();
        return this;
    }

    private boolean hasDuplicate(Component[] components) {
        HashSet<Component> set = new HashSet<Component>(components.length);
        for (Component component : components) {
            if (set.add(component)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
        if (this.executionRegistration != null) {
            this.executionRegistration.remove();
            this.executionRegistration = null;
        }
        if (this.lifecycleRegistration != null) {
            this.lifecycleRegistration.remove();
            this.lifecycleRegistration = null;
        }
        this.removeAllListenerRegistrations();
        this.lifecycleOwner = null;
        this.listenOnComponents = null;
        this.eventListener = null;
    }

    public boolean isShortcutActive() {
        return this.shortcutActive;
    }

    public Key getKey() {
        return this.primaryKey;
    }

    public Set<Key> getModifiers() {
        return Collections.unmodifiableSet(this.modifiers);
    }

    @Deprecated
    public boolean preventsDefault() {
        return !this.allowDefaultBehavior;
    }

    public boolean isBrowserDefaultAllowed() {
        return this.allowDefaultBehavior;
    }

    public void setBrowserDefaultAllowed(boolean browserDefaultAllowed) {
        if (this.allowDefaultBehavior != browserDefaultAllowed) {
            this.allowDefaultBehavior = browserDefaultAllowed;
            this.prepareForClientResponse();
        }
    }

    @Deprecated
    public boolean stopsPropagation() {
        return !this.allowEventPropagation;
    }

    public boolean isEventPropagationAllowed() {
        return this.allowEventPropagation;
    }

    public void setEventPropagationAllowed(boolean eventPropagationAllowed) {
        if (this.allowEventPropagation != eventPropagationAllowed) {
            this.allowEventPropagation = eventPropagationAllowed;
            this.prepareForClientResponse();
        }
    }

    @Deprecated
    public Component getOwner() {
        if (this.listenOnComponents == null) {
            return null;
        }
        if (this.listenOnComponents.length <= 0 || this.listenOnComponents[0] == null) {
            throw new IllegalStateException("listenOnComponents must not be empty!");
        }
        return this.listenOnComponents[0];
    }

    public Component[] getOwners() {
        if (this.listenOnComponents == null) {
            return new Component[0];
        }
        return this.listenOnComponents;
    }

    public Component getLifecycleOwner() {
        return this.lifecycleOwner;
    }

    boolean isDirty() {
        return this.isDirty.get();
    }

    private void setLifecycleOwner(Component owner) {
        assert (owner != null);
        if (this.lifecycleRegistration != null) {
            this.lifecycleRegistration.remove();
        }
        this.registerLifecycleOwner(owner);
    }

    private void addKey(Key key) {
        assert (key != null);
        HashableKey hashableKey = new HashableKey(key);
        if (Key.isModifier(key)) {
            if (!this.modifiers.contains(hashableKey)) {
                this.modifiers.add(hashableKey);
                this.prepareForClientResponse();
            }
        } else if (this.primaryKey == null || !this.primaryKey.equals(hashableKey)) {
            this.primaryKey = hashableKey;
            this.prepareForClientResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareForClientResponse() {
        assert (this.lifecycleOwner != null);
        ShortcutRegistration shortcutRegistration = this;
        synchronized (shortcutRegistration) {
            if (this.isDirty.get()) {
                return;
            }
            this.isDirty.set(true);
        }
        this.queueBeforeExecutionCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markClean() {
        ShortcutRegistration shortcutRegistration = this;
        synchronized (shortcutRegistration) {
            if (!this.isDirty.get()) {
                return;
            }
            this.isDirty.set(false);
            this.executionRegistration = null;
        }
    }

    private String filterText() {
        return ShortcutRegistration.generateEventKeyFilter(this.primaryKey) + " && " + ShortcutRegistration.generateEventModifierFilter(this.modifiers);
    }

    private void updateHandlerListenerRegistration(int listenOnIndex) {
        Component component = this.listenOnComponents[listenOnIndex];
        assert (component != null);
        if (this.shortcutListenerRegistrations == null) {
            this.shortcutListenerRegistrations = new CompoundRegistration[this.listenOnComponents.length];
        }
        if (this.shortcutListenerRegistrations[listenOnIndex] == null) {
            if (component.getUI().isPresent()) {
                this.shortcutListenerRegistrations[listenOnIndex] = new CompoundRegistration(new Registration[0]);
                Registration keyDownRegistration = ComponentUtil.addListener(component, KeyDownEvent.class, event -> this.fireShortcutEvent(component), domRegistration -> {
                    this.shortcutListenerRegistrations[listenOnIndex].addRegistration((Registration)domRegistration);
                    this.configureHandlerListenerRegistration(listenOnIndex);
                });
                this.shortcutListenerRegistrations[listenOnIndex].addRegistration(keyDownRegistration);
                this.setupKeydownEventDelegateIfNeeded(component);
            }
        } else {
            this.configureHandlerListenerRegistration(listenOnIndex);
        }
    }

    private void fireShortcutEvent(Component component) {
        if (this.ancestorsOrSelfAreVisible(this.lifecycleOwner) && this.lifecycleOwner.getElement().isEnabled()) {
            this.invokeShortcutEventListener(component);
        }
    }

    private boolean ancestorsOrSelfAreVisible(Component component) {
        if (!component.isVisible()) {
            return false;
        }
        Optional<Component> parent = component.getParent();
        if (parent.isPresent()) {
            return this.ancestorsOrSelfAreVisible(parent.get());
        }
        return true;
    }

    private void configureHandlerListenerRegistration(int listenOnIndex) {
        if (this.shortcutListenerRegistrations[listenOnIndex] != null) {
            Optional<Registration> registration = this.shortcutListenerRegistrations[listenOnIndex].registrations.stream().filter(r -> r instanceof DomListenerRegistration).findFirst();
            registration.ifPresent(r -> {
                DomListenerRegistration listenerRegistration = (DomListenerRegistration)r;
                String filterText = this.filterText();
                if (!this.allowDefaultBehavior) {
                    filterText = filterText + " && (event.preventDefault() || true)";
                }
                if (!this.allowEventPropagation) {
                    filterText = filterText + " && (event.stopPropagation() || true)";
                }
                listenerRegistration.setFilter(filterText);
                this.shortcutActive = true;
            });
        }
    }

    private void invokeShortcutEventListener(Component component) {
        ShortcutEvent event = new ShortcutEvent(component, this.lifecycleOwner, this.primaryKey, this.modifiers.stream().map(k -> (KeyModifier)((HashableKey)k).key).collect(Collectors.toSet()));
        this.eventListener.onShortcut(event);
    }

    private void registerLifecycleOwner(Component owner) {
        assert (owner != null);
        this.lifecycleOwner = owner;
        Registration attachRegistration = owner.addAttachListener(e -> this.queueBeforeExecutionCallback());
        Registration detachRegistration = owner.addDetachListener(e -> this.removeLifecycleOwnerRegistrations());
        this.lifecycleRegistration = new CompoundRegistration(attachRegistration, detachRegistration);
    }

    private Component[] registerOwnerListeners() {
        assert (this.listenOnSuppliers != null);
        this.listenOnComponents = (Component[])this.listenOnSuppliers.get();
        if (this.listenOnComponents == null) {
            throw new IllegalStateException(String.format("Could not register shortcut listener for %s. %s<%s> supplied a null value.", this.toString(), SerializableSupplier.class.getSimpleName(), Component.class.getSimpleName()));
        }
        this.listenOnAttachListenerRegistrations = new CompoundRegistration[this.listenOnComponents.length];
        for (int i = 0; i < this.listenOnComponents.length; ++i) {
            Component component = this.listenOnComponents[i];
            int listenOnIndex = i;
            if (component == null) {
                throw new IllegalStateException(String.format("Could not register shortcut listener for %s. %s<%s> supplied a null value.", this.toString(), SerializableSupplier.class.getSimpleName(), Component.class.getSimpleName()));
            }
            if (!(component instanceof UI)) {
                this.listenOnAttachListenerRegistrations[i] = new CompoundRegistration(new Registration[0]);
                this.listenOnAttachListenerRegistrations[i].addRegistration(component.addAttachListener(attachEvent -> this.updateHandlerListenerRegistration(listenOnIndex)));
                this.listenOnAttachListenerRegistrations[i].addRegistration(component.addDetachListener(detachEvent -> this.removeLifecycleOwnerRegistrations()));
            }
            if (!component.getUI().isPresent()) continue;
            this.updateHandlerListenerRegistration(listenOnIndex);
        }
        return this.listenOnComponents;
    }

    private void removeAllListenerRegistrations() {
        if (this.listenOnAttachListenerRegistrations != null) {
            for (CompoundRegistration listenOnAttachListenerRegistration : this.listenOnAttachListenerRegistrations) {
                if (listenOnAttachListenerRegistration == null) continue;
                listenOnAttachListenerRegistration.remove();
            }
            this.listenOnAttachListenerRegistrations = null;
        }
        this.removeLifecycleOwnerRegistrations();
        this.listenOnComponents = null;
    }

    private void removeListenOnDetachListeners() {
        this.registrations.forEach(Registration::remove);
        this.registrations.clear();
    }

    private void removeLifecycleOwnerRegistrations() {
        if (this.shortcutListenerRegistrations != null) {
            for (CompoundRegistration shortcutListenerRegistration : this.shortcutListenerRegistrations) {
                if (shortcutListenerRegistration == null) continue;
                shortcutListenerRegistration.remove();
            }
            this.shortcutListenerRegistrations = null;
        }
        this.shortcutActive = false;
        this.removeListenOnDetachListeners();
    }

    private void queueBeforeExecutionCallback() {
        if (this.lifecycleOwner == null || !this.lifecycleOwner.getUI().isPresent()) {
            return;
        }
        if (this.executionRegistration != null) {
            this.executionRegistration.remove();
        }
        this.executionRegistration = this.lifecycleOwner.getUI().get().beforeClientResponse(this.lifecycleOwner, this.beforeClientResponseConsumer);
    }

    private static String generateEventModifierFilter(Collection<Key> modifiers) {
        List realMods = modifiers.stream().filter(Key::isModifier).collect(Collectors.toList());
        return Arrays.stream(KeyModifier.values()).map(modifier -> {
            boolean modifierRequired = realMods.stream().anyMatch(mod -> mod.matches(modifier.getKeys().get(0)));
            return (modifierRequired ? "" : "!") + "event.getModifierState('" + modifier.getKeys().get(0) + "')";
        }).collect(Collectors.joining(" && "));
    }

    private static String generateEventKeyFilter(Key key) {
        assert (key != null);
        String keyList = "[" + key.getKeys().stream().map(s -> "'" + s + "'").collect(Collectors.joining(",")) + "]";
        return "(" + keyList + ".indexOf(event.code) !== -1 || " + keyList + ".indexOf(event.key) !== -1)";
    }

    private void setupKeydownEventDelegateIfNeeded(Component listenOn) {
        String elementLocatorJs = (String)ComponentUtil.getData(listenOn, "_element_locator_js_key");
        if (elementLocatorJs != null) {
            String filterText = this.filterText();
            String preventDefault = this.allowDefaultBehavior ? "" : "event.preventDefault();";
            String jsExpression = String.format(ELEMENT_LOCATOR_JS, elementLocatorJs, filterText, preventDefault);
            String expressionHash = StringUtil.getHash(jsExpression);
            Set<String> expressions = this.getOrInitListenData(listenOn);
            if (expressions.contains(expressionHash)) {
                return;
            }
            expressions.add(expressionHash);
            listenOn.getElement().executeJs(jsExpression, new Serializable[0]);
        }
    }

    private Set<String> getOrInitListenData(Component listenOn) {
        Object componentData = ComponentUtil.getData(listenOn, LISTEN_ON_INITIALIZED);
        if (componentData != null) {
            return (Set)componentData;
        }
        HashSet<String> expressionHash = new HashSet<String>();
        ComponentUtil.setData(listenOn, LISTEN_ON_INITIALIZED, expressionHash);
        listenOn.addDetachListener(event -> ComponentUtil.setData((Component)event.getSource(), LISTEN_ON_INITIALIZED, null));
        return expressionHash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(Arrays.stream(this.listenOnComponents).map(component -> component.getClass().getSimpleName()).collect(Collectors.joining(",")));
        builder.append("]");
        return String.format("%s [key = %s, modifiers = %s, owner = %s, listenOn = %s, default = %s, propagation = %s]", this.getClass().getSimpleName(), this.primaryKey != null ? this.primaryKey.getKeys().get(0) : "null", Arrays.toString(this.modifiers.stream().map(k -> k.getKeys().get(0)).toArray()), this.lifecycleOwner != null ? this.lifecycleOwner.getClass().getSimpleName() : "null", builder.toString(), this.allowDefaultBehavior, this.allowEventPropagation);
    }

    private void initListenOnComponent() {
        this.listenOnComponents = this.registerOwnerListeners();
    }

    private void addListenOnDetachListeners() {
        if (!this.registrations.isEmpty()) {
            return;
        }
        for (Component component : this.listenOnComponents) {
            Registration registration = component.addDetachListener(event -> this.removeAllListenerRegistrations());
            this.registrations.add(registration);
        }
    }

    private static class CompoundRegistration
    implements Registration {
        private Set<Registration> registrations;

        CompoundRegistration(Registration ... registrations) {
            this.registrations = new HashSet<Registration>(Arrays.asList(registrations));
        }

        void addRegistration(Registration registration) {
            if (registration != null) {
                this.registrations.add(registration);
            }
        }

        @Override
        public void remove() {
            if (this.registrations != null) {
                this.registrations.forEach(Registration::remove);
                this.registrations = null;
            }
        }
    }

    private static class HashableKey
    implements Key {
        private Key key;
        private Integer hashcode;

        HashableKey(Key key) {
            assert (key != null);
            this.key = key;
        }

        public int hashCode() {
            if (this.hashcode == null) {
                this.hashcode = Arrays.hashCode(this.key.getKeys().stream().map(String::toLowerCase).sorted(String::compareTo).toArray(String[]::new));
            }
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof HashableKey) {
                HashableKey other = (HashableKey)obj;
                return this.key.matches(other.getKeys().get(0));
            }
            return false;
        }

        @Override
        public List<String> getKeys() {
            return this.key.getKeys();
        }
    }
}

