/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.webcomponent.WebComponentUI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import com.vaadin.flow.theme.Theme;
import com.vaadin.flow.theme.ThemeDefinition;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;

public class WebComponentBootstrapHandler
extends BootstrapHandler {
    private static final String REQ_PARAM_URL = "url";
    private static final String PATH_PREFIX = "/web-component/web-component";
    private static final Pattern PATH_PATTERN = Pattern.compile(".*/web-component/web-component-(ui|bootstrap)\\.(js|html)$");

    public WebComponentBootstrapHandler() {
    }

    protected WebComponentBootstrapHandler(BootstrapHandler.PageBuilder pageBuilder) {
        super(pageBuilder);
    }

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty()) {
            return false;
        }
        return PATH_PATTERN.matcher(pathInfo).find();
    }

    protected String getRequestUrl(VaadinRequest request) {
        return ((VaadinServletRequest)request).getRequestURL().toString();
    }

    @Override
    protected BootstrapHandler.BootstrapContext createAndInitUI(Class<? extends UI> uiClass, VaadinRequest request, VaadinResponse response, VaadinSession session) {
        if (!this.canHandleRequest(request)) {
            throw new IllegalStateException("Unexpected request URL '" + this.getRequestUrl(request) + "' in the bootstrap handler for web component UI which should handle path " + PATH_PATTERN.toString());
        }
        String serviceUrl = this.getServiceUrl(request, response);
        BootstrapHandler.BootstrapContext context = super.createAndInitUI(WebComponentUI.class, request, response, session);
        JsonObject config = context.getApplicationParameters();
        String pushURL = context.getSession().getConfiguration().getPushURL();
        if (pushURL == null) {
            pushURL = serviceUrl;
        } else {
            try {
                URI uri = new URI(serviceUrl);
                pushURL = uri.resolve(new URI(pushURL)).toASCIIString();
            }
            catch (URISyntaxException exception) {
                throw new IllegalStateException(String.format("Can't resolve pushURL '%s' based on the service URL '%s'", pushURL, serviceUrl), exception);
            }
        }
        PushConfiguration pushConfiguration = context.getUI().getPushConfiguration();
        pushConfiguration.setPushUrl(pushURL);
        assert (serviceUrl.endsWith("/"));
        config.put("serviceUrl", serviceUrl);
        config.put("webComponentMode", true);
        WebComponentConfigurationRegistry registry = WebComponentConfigurationRegistry.getInstance(request.getService().getContext());
        JsonArray tags = registry.getConfigurations().stream().map(conf -> Json.create((String)conf.getTag())).collect(JsonUtils.asArray());
        config.put("webcomponents", (JsonValue)tags);
        return context;
    }

    @Override
    protected BootstrapHandler.BootstrapContext createBootstrapContext(VaadinRequest request, VaadinResponse response, UI ui, Function<VaadinRequest, String> callback) {
        return new WebComponentBootstrapContext(request, response, ui, callback);
    }

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        if (session.getService().getDeploymentConfiguration().isCompatibilityMode()) {
            return super.synchronizedHandleRequest(session, request, response);
        }
        Class<? extends UI> uiClass = WebComponentBootstrapHandler.getUIClass(request);
        BootstrapHandler.BootstrapContext context = this.createAndInitUI(uiClass, request, response, session);
        HandlerHelper.setResponseNoCacheHeaders(response::setHeader, response::setDateHeader);
        String serviceUrl = this.getServiceUrl(request, response);
        Document document = this.getPageBuilder().getBootstrapPage(context);
        this.writeBootstrapPage(response, document.head(), serviceUrl);
        return true;
    }

    private void writeBootstrapPage(VaadinResponse response, org.jsoup.nodes.Element head, String serviceUrl) throws IOException {
        this.writeBootstrapPage("text/javascript; charset=utf-8", response, head, serviceUrl);
    }

    protected void writeBootstrapPage(String contentType, VaadinResponse response, org.jsoup.nodes.Element head, String serviceUrl) throws IOException {
        response.setContentType(contentType);
        ArrayList<Element> elementsForShadows = new ArrayList<Element>();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(response.getOutputStream(), StandardCharsets.UTF_8));){
            String varName = "headElem";
            writer.append("var ").append(varName).append("=null;");
            for (org.jsoup.nodes.Element element : head.children()) {
                if (WebComponentBootstrapHandler.elementShouldNotBeTransferred(element)) {
                    WebComponentBootstrapHandler.getElementForShadowDom(element).ifPresent(elementsForShadows::add);
                    continue;
                }
                writer.append(varName).append("=");
                writer.append("document.createElement('").append(element.tagName()).append("');");
                this.transferAttribute(writer, varName, element, serviceUrl);
                String elementHtml = element.html();
                if (elementHtml != null && elementHtml.length() > 0) {
                    writer.append(varName).append(".innerHTML=\"").append(WebComponentBootstrapHandler.inlineHTML(elementHtml)).append("\";");
                }
                writer.append("document.head.appendChild(").append(varName).append(");");
            }
        }
        WebComponentConfigurationRegistry.getInstance(response.getService().getContext()).setShadowDomElements(elementsForShadows);
    }

    private static boolean elementShouldNotBeTransferred(org.jsoup.nodes.Element element) {
        if ("base".equals(element.tagName()) || "meta".equals(element.tagName()) || "style".equals(element.tagName())) {
            return true;
        }
        return "script".equals(element.tagName()) && element.attr("src").contains("webcomponents-loader.js");
    }

    private static Optional<Element> getElementForShadowDom(org.jsoup.nodes.Element element) {
        if ("style".equals(element.tagName())) {
            return ElementUtil.fromJsoup((Node)element);
        }
        return Optional.empty();
    }

    private void transferAttribute(Writer writer, String elementRef, org.jsoup.nodes.Element element, String basePath) throws IOException {
        for (Attribute attribute : element.attributes()) {
            writer.append(elementRef).append(".setAttribute('").append(attribute.getKey()).append("',");
            if (attribute.getValue() == null) {
                writer.append("''");
            } else {
                String path = attribute.getValue();
                if ("src".equals(attribute.getKey())) {
                    path = this.modifyPath(basePath, path);
                }
                writer.append("\"").append(path).append("\"");
            }
            writer.append(");");
        }
    }

    protected String modifyPath(String basePath, String path) throws UnsupportedEncodingException {
        int vaadinIndex = path.indexOf("VAADIN/");
        String suffix = path;
        if (vaadinIndex > 0) {
            suffix = suffix.substring(vaadinIndex);
        }
        return URI.create(this.checkURL(basePath + suffix)).toString();
    }

    private String checkURL(String url) {
        if (url == null) {
            return null;
        }
        if (url.contains("\"")) {
            throw new IllegalStateException("URL '" + url + "' may not contain double quotes");
        }
        return url;
    }

    private static String inlineHTML(String html) {
        return html.replace("\\", "\\\\").replace("\"", "\\\"").replace("//<![CDATA[", "/*<![CDATA[*/").replace("//]]>", "/*]]>*/").replaceAll("\\s{2,}", "").replace("\t", "").replace("\n", "").replace("\r", "");
    }

    protected String getServiceUrl(VaadinRequest request, VaadinResponse response) {
        String url = request.getParameter(REQ_PARAM_URL);
        if (url == null) {
            url = this.getRequestUrl(request);
        }
        return url.substring(0, url.indexOf(PATH_PREFIX) + 1).replaceFirst("^.*://", "//");
    }

    private static class WebComponentBootstrapContext
    extends BootstrapHandler.BootstrapContext {
        private WebComponentBootstrapContext(VaadinRequest request, VaadinResponse response, UI ui, Function<VaadinRequest, String> callback) {
            super(request, response, ui.getInternals().getSession(), ui, callback);
            this.setInitTheme(false);
        }

        @Override
        public <T extends Annotation> Optional<T> getPageConfigurationAnnotation(Class<T> annotationType) {
            WebComponentConfigurationRegistry registry = WebComponentConfigurationRegistry.getInstance(this.getRequest().getService().getContext());
            return registry.getEmbeddedApplicationAnnotation(annotationType);
        }

        @Override
        protected Optional<ThemeDefinition> getTheme() {
            Optional<Theme> optionalTheme = this.getPageConfigurationAnnotation(Theme.class);
            return optionalTheme.map(ThemeDefinition::new);
        }

        @Override
        protected Optional<PwaRegistry> getPwaRegistry() {
            return Optional.empty();
        }
    }
}

