/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIOUtils {
    private FileIOUtils() {
    }

    public static boolean writeIfChanged(File file, List<String> content) throws IOException {
        return FileIOUtils.writeIfChanged(file, content.stream().collect(Collectors.joining("\n")));
    }

    public static boolean writeIfChanged(File file, String content) throws IOException {
        String existingFileContent = FileIOUtils.getExistingFileContent(file);
        if (content.equals(existingFileContent)) {
            FileIOUtils.log().debug("skipping writing to file '{}' because content matches", (Object)file);
            return false;
        }
        FileIOUtils.log().debug("writing to file '{}' because content does not match", (Object)file);
        FileUtils.forceMkdirParent((File)file);
        FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
        return true;
    }

    private static Logger log() {
        return LoggerFactory.getLogger(FileIOUtils.class);
    }

    private static String getExistingFileContent(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
    }

    public static File getProjectFolderFromClasspath() {
        try {
            URL url = FileIOUtils.class.getClassLoader().getResource(".");
            if (url != null && url.getProtocol().equals("file")) {
                return FileIOUtils.getProjectFolderFromClasspath(url);
            }
        }
        catch (Exception e) {
            FileIOUtils.log().warn("Unable to determine project folder using classpath", (Throwable)e);
        }
        return null;
    }

    static File getProjectFolderFromClasspath(URL rootFolder) throws URISyntaxException {
        Path path = Path.of(rootFolder.toURI());
        if (path.endsWith(Path.of("target", "classes"))) {
            return path.getParent().getParent().toFile();
        }
        return null;
    }

    public static boolean isProbablyTemporaryFile(File file) {
        return file.getName().endsWith("~");
    }
}

