/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom.impl;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.impl.ClassAttributeHandler;
import com.vaadin.flow.dom.impl.StyleAttributeHandler;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public abstract class CustomAttribute
implements Serializable {
    private static final Map<String, CustomAttribute> customAttributes;

    public static Optional<CustomAttribute> get(String name) {
        return Optional.ofNullable(customAttributes.get(name));
    }

    public static Set<String> getNames() {
        return customAttributes.keySet();
    }

    public abstract boolean hasAttribute(Element var1);

    public abstract String getAttribute(Element var1);

    public abstract void setAttribute(Element var1, String var2);

    public abstract void removeAttribute(Element var1);

    static {
        HashMap<String, CustomAttribute> map = new HashMap<String, CustomAttribute>();
        map.put("class", new ClassAttributeHandler());
        map.put("style", new StyleAttributeHandler());
        customAttributes = Collections.unmodifiableMap(map);
    }
}

