/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import com.vaadin.flow.router.internal.ParameterInfo;
import com.vaadin.flow.router.internal.PathUtil;
import com.vaadin.flow.router.internal.RouteFormat;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.server.AmbiguousRouteConfigurationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;

final class RouteSegment
implements Serializable {
    private String name;
    private String template;
    private ParameterInfo info;
    private Pattern pattern;
    private RouteTarget target;
    private Map<String, RouteSegment> staticSegments;
    private Map<String, RouteSegment> parameterSegments;
    private Map<String, RouteSegment> optionalSegments;
    private Map<String, RouteSegment> varargsSegments;
    private Map<String, RouteSegment> allSegments;
    private final boolean isRoot;
    private boolean isMainRouteSegment;

    private RouteSegment(String segmentTemplate, boolean isRoot) {
        this.template = segmentTemplate;
        this.isRoot = isRoot;
        if (RouteFormat.isParameter(segmentTemplate)) {
            this.info = new ParameterInfo(segmentTemplate);
            this.getRegex().ifPresent(s -> {
                this.pattern = Pattern.compile(s);
            });
            this.name = this.info.getName();
        } else {
            this.name = segmentTemplate;
        }
    }

    public RouteSegment(RouteSegment original) {
        this.name = original.name;
        this.template = original.template;
        this.info = original.info;
        this.pattern = original.pattern;
        this.target = original.target;
        this.isRoot = original.isRoot;
        this.isMainRouteSegment = original.isMainRouteSegment;
        original.getStaticSegments().entrySet().forEach(e -> this.addSegment(new RouteSegment((RouteSegment)e.getValue()), this.getStaticSegments()));
        original.getParameterSegments().entrySet().forEach(e -> this.addSegment(new RouteSegment((RouteSegment)e.getValue()), this.getParameterSegments()));
        original.getOptionalSegments().entrySet().forEach(e -> this.addSegment(new RouteSegment((RouteSegment)e.getValue()), this.getOptionalSegments()));
        original.getVarargsSegments().entrySet().forEach(e -> this.addSegment(new RouteSegment((RouteSegment)e.getValue()), this.getVarargsSegments()));
    }

    static RouteSegment createRoot() {
        return new RouteSegment("", true);
    }

    String getName() {
        return this.name;
    }

    String getTemplate() {
        return this.template;
    }

    boolean hasTarget() {
        return this.target != null;
    }

    RouteTarget getTarget() {
        return this.target;
    }

    boolean isParameter() {
        return this.info != null;
    }

    Optional<String> getRegex() {
        return this.isParameter() ? this.info.getRegex() : Optional.empty();
    }

    boolean isOptional() {
        return this.isParameter() && this.info.isOptional();
    }

    boolean isVarargs() {
        return this.isParameter() && this.info.isVarargs();
    }

    boolean isMandatory() {
        return !this.isOptional() && !this.isVarargs();
    }

    boolean isEligible(String value) {
        if (!this.isParameter()) {
            return Objects.equals(this.getName(), value);
        }
        if (this.pattern == null) {
            return true;
        }
        return this.pattern.matcher(value).matches();
    }

    LinkedHashMap<String, RouteTarget> getRoutes() {
        Map<String, RouteSegment> leafSegments = this.getLeafStaticSegments();
        String mainRoutePath = null;
        RouteTarget mainRouteTarget = null;
        for (Map.Entry<String, RouteSegment> entry : leafSegments.entrySet()) {
            if (!entry.getValue().isMainRouteSegment) continue;
            mainRoutePath = entry.getKey();
            mainRouteTarget = entry.getValue().target;
            break;
        }
        LinkedHashMap<String, RouteTarget> result = new LinkedHashMap<String, RouteTarget>();
        if (mainRoutePath != null) {
            result.put(mainRoutePath, mainRouteTarget);
        }
        this.getLeafSegments().forEach((path, segment) -> result.put((String)path, segment.target));
        return result;
    }

    void removeSubRoute(String template) {
        this.removeSubRoute(PathUtil.getSegmentsList(template));
    }

    void addSubRoute(String template, RouteTarget target) {
        this.addSubRoute(PathUtil.getSegmentsList(template), target);
    }

    NavigationRouteTarget getNavigationRouteTarget(String url) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        RouteTarget routeTarget = url == null ? null : this.findRouteTarget(PathUtil.getSegmentsList(url), parameters);
        return new NavigationRouteTarget(url, routeTarget, parameters);
    }

    String formatTemplate(String template, Function<RouteSegment, String> parameterFormat) {
        if (template == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        this.matchSegmentTemplates(template, routeSegment -> result.add(routeSegment.isParameter() ? (String)parameterFormat.apply((RouteSegment)routeSegment) : routeSegment.getName()), null);
        if (result.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)"/", result);
    }

    private LinkedHashMap<String, RouteSegment> getLeafSegments() {
        LinkedHashMap<String, RouteSegment> result = new LinkedHashMap<String, RouteSegment>();
        if (this.target != null) {
            result.put("", this);
        }
        this.collectLeafSegments(result, this.getStaticSegments());
        this.collectLeafSegments(result, this.getParameterSegments());
        this.collectLeafSegments(result, this.getOptionalSegments());
        this.collectLeafSegments(result, this.getVarargsSegments());
        return result;
    }

    private Map<String, RouteSegment> getLeafStaticSegments() {
        HashMap<String, RouteSegment> result = new HashMap<String, RouteSegment>();
        if (this.target != null) {
            result.put("", this);
        }
        for (Map.Entry<String, RouteSegment> segmentEntry : this.getStaticSegments().entrySet()) {
            RouteSegment segment = segmentEntry.getValue();
            Iterator<Map.Entry<String, RouteSegment>> iterator = segment.getLeafStaticSegments().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, RouteSegment> targetEntry;
                String key;
                result.put(segmentEntry.getKey() + (String)((key = (targetEntry = iterator.next()).getKey()).isEmpty() ? "" : "/" + key), targetEntry.getValue());
            }
        }
        return result;
    }

    private void collectLeafSegments(Map<String, RouteSegment> result, Map<String, RouteSegment> children) {
        for (Map.Entry<String, RouteSegment> segmentEntry : children.entrySet()) {
            RouteSegment segment = segmentEntry.getValue();
            Iterator<Map.Entry<String, RouteSegment>> iterator = segment.getLeafSegments().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, RouteSegment> targetEntry;
                String key;
                result.put(segmentEntry.getKey() + (String)((key = (targetEntry = iterator.next()).getKey()).isEmpty() ? "" : "/" + key), targetEntry.getValue());
            }
        }
    }

    private RouteSegment getFirstLeafSegment() {
        if (this.target != null) {
            return this;
        }
        Map<String, RouteSegment> segments = this.getAllSegments();
        assert (!segments.isEmpty());
        RouteSegment first = segments.values().iterator().next();
        return first.getFirstLeafSegment();
    }

    private void removeSubRoute(List<String> segmentPatterns) {
        RouteSegment routeSegment;
        String segmentPattern = null;
        Map<String, RouteSegment> children = null;
        if (segmentPatterns.isEmpty()) {
            routeSegment = this;
        } else {
            segmentPattern = segmentPatterns.get(0);
            children = this.getChildren(segmentPattern);
            routeSegment = children.get(segmentPattern);
        }
        if (routeSegment != null) {
            if (segmentPatterns.size() > 1) {
                routeSegment.removeSubRoute(segmentPatterns.subList(1, segmentPatterns.size()));
            } else {
                routeSegment.target = null;
            }
            if (routeSegment.isEmpty() && routeSegment != this) {
                this.removeSegment(segmentPattern, children);
            }
        }
    }

    private void addSubRoute(List<String> segmentPatterns, RouteTarget target) {
        RouteSegment routeSegment;
        boolean isMainRoute = this.isEmpty() && this.isRoot;
        String segmentPattern = null;
        Map<String, RouteSegment> children = null;
        if (segmentPatterns.isEmpty()) {
            routeSegment = this;
        } else {
            segmentPattern = segmentPatterns.get(0);
            children = this.getChildren(segmentPattern);
            routeSegment = children.get(segmentPattern);
        }
        if (routeSegment == null) {
            if (RouteFormat.isVarargsParameter(segmentPattern) && segmentPatterns.size() > 1) {
                throw new IllegalArgumentException("A varargs url parameter can be defined only as the last path segment");
            }
            if (RouteFormat.isOptionalParameter(segmentPattern) && segmentPatterns.size() == 1 && this.hasTarget()) {
                throw this.ambigousOptionalTarget(target.getTarget(), this.getTarget().getTarget());
            }
            routeSegment = this.addSegment(segmentPattern, children);
        }
        routeSegment.setRouteTarget(segmentPatterns, target);
        if (isMainRoute) {
            RouteSegment firstSegment = this.getFirstLeafSegment();
            firstSegment.isMainRouteSegment = true;
        }
    }

    private void setRouteTarget(List<String> segmentPatterns, RouteTarget target) {
        if (segmentPatterns.size() > 1) {
            this.addSubRoute(segmentPatterns.subList(1, segmentPatterns.size()), target);
        } else if (!this.hasTarget()) {
            RouteSegment optional = this.getOptionalParameterWithTarget();
            if (optional != null) {
                throw optional.ambigousOptionalTarget(optional.getTarget().getTarget(), target.getTarget());
            }
            this.target = target;
        } else {
            throw this.ambigousTarget(target.getTarget());
        }
    }

    private RouteTarget findRouteTarget(List<String> segments, Map<String, String> parameters) {
        RouteTarget foundTarget;
        RouteSegment routeSegment;
        RouteSegment routeSegment2 = routeSegment = segments.isEmpty() ? this : this.getStaticSegments().get(segments.get(0));
        if (routeSegment != null && (foundTarget = routeSegment.getRouteTargetMatchingParameter(segments, parameters)) != null) {
            return foundTarget;
        }
        if (!segments.isEmpty()) {
            foundTarget = this.findRouteTarget(segments, parameters, this.getParameterSegments());
            if (foundTarget != null) {
                return foundTarget;
            }
            foundTarget = this.findRouteTarget(segments, parameters, this.getOptionalSegments());
            if (foundTarget != null) {
                return foundTarget;
            }
            foundTarget = this.findRouteTargetInOptionals(segments, parameters);
            if (foundTarget != null) {
                return foundTarget;
            }
            foundTarget = this.findRouteTarget(segments, parameters, this.getVarargsSegments());
            if (foundTarget != null) {
                return foundTarget;
            }
        }
        return null;
    }

    private RouteTarget findRouteTargetInOptionals(List<String> segments, Map<String, String> parameters) {
        for (RouteSegment parameter : this.getOptionalSegments().values()) {
            HashMap<String, String> outputParameters;
            RouteTarget foundTarget = parameter.findRouteTarget(segments, outputParameters = new HashMap<String, String>());
            if (foundTarget == null) continue;
            parameters.putAll(outputParameters);
            return foundTarget;
        }
        return null;
    }

    private RouteTarget findRouteTarget(List<String> segments, Map<String, String> parameters, Map<String, RouteSegment> children) {
        for (RouteSegment segment : children.values()) {
            RouteTarget foundTarget = segment.getRouteTargetMatchingParameter(segments, parameters);
            if (foundTarget == null) continue;
            return foundTarget;
        }
        return null;
    }

    private RouteTarget getRouteTargetMatchingParameter(List<String> segments, Map<String, String> parameters) {
        HashMap<String, String> outputParameters = new HashMap<String, String>();
        if (this.isVarargs()) {
            for (String value : segments) {
                if (this.isEligible(value)) continue;
                return null;
            }
            outputParameters.put(this.getName(), PathUtil.getPath(segments));
            segments = Collections.emptyList();
        } else if (this.isParameter()) {
            String value = segments.get(0);
            if (this.isEligible(value)) {
                outputParameters.put(this.getName(), value);
            } else {
                return null;
            }
        }
        segments = segments.size() <= 1 ? Collections.emptyList() : segments.subList(1, segments.size());
        RouteTarget foundTarget = this.getRouteTarget(segments, outputParameters);
        if (foundTarget != null) {
            parameters.putAll(outputParameters);
        }
        return foundTarget;
    }

    private RouteTarget getRouteTarget(List<String> segments, Map<String, String> outputParameters) {
        RouteSegment optionalChild;
        RouteTarget foundTarget = !segments.isEmpty() ? this.findRouteTarget(segments, outputParameters) : (this.hasTarget() ? this.getTarget() : ((optionalChild = this.getAnyOptionalOrVarargsParameterWithTarget()) != null ? optionalChild.getTarget() : null));
        return foundTarget;
    }

    void matchSegmentTemplates(String template, Consumer<RouteSegment> segmentProcessor, Consumer<RouteSegment> targetSegmentProcessor) {
        this.matchSegmentTemplates(template, PathUtil.getSegmentsList(template), segmentProcessor, targetSegmentProcessor);
    }

    private void matchSegmentTemplates(String template, List<String> segmentTemplates, Consumer<RouteSegment> segmentProcessor, Consumer<RouteSegment> targetSegmentProcessor) {
        if (segmentTemplates.isEmpty()) {
            return;
        }
        RouteSegment routeSegment = this.getAllSegments().get(segmentTemplates.get(0));
        if (routeSegment == null) {
            throw new IllegalArgumentException("Unregistered route template \"" + template + "\"");
        }
        if (segmentProcessor != null) {
            segmentProcessor.accept(routeSegment);
        }
        if (segmentTemplates.size() > 1) {
            routeSegment.matchSegmentTemplates(template, segmentTemplates.subList(1, segmentTemplates.size()), segmentProcessor, targetSegmentProcessor);
        } else {
            if (routeSegment.getTarget() == null) {
                throw new IllegalArgumentException("Unregistered route template \"" + template + "\"");
            }
            if (targetSegmentProcessor != null) {
                targetSegmentProcessor.accept(routeSegment);
            }
        }
    }

    void matchSegmentTemplatesWithParameters(String template, RouteParameters parameters, Consumer<RouteSegmentValue> segmentProcessor, Consumer<RouteSegment> targetSegmentProcessor) {
        List<String> segmentTemplates = PathUtil.getSegmentsList(template);
        if (segmentTemplates.isEmpty() && parameters.getParameterNames().isEmpty()) {
            return;
        }
        HashSet<String> parameterNames = new HashSet<String>(parameters.getParameterNames());
        RouteParameters finalParameters = parameters;
        this.matchSegmentTemplates(template, segmentTemplates, routeSegment -> {
            Optional<String> segmentValue = RouteSegment.getSegmentValue(routeSegment, finalParameters);
            if (routeSegment.isParameter()) {
                parameterNames.remove(routeSegment.getName());
            }
            if (segmentProcessor != null) {
                segmentProcessor.accept(new RouteSegmentValue((RouteSegment)routeSegment, segmentValue));
            }
        }, routeSegment -> {
            if (!parameterNames.isEmpty()) {
                throw new IllegalArgumentException("All provided RouteParameters must be used to process the template. Provide the exact required RouteParameters or a template that will use all RouteParameters");
            }
            if (targetSegmentProcessor != null) {
                targetSegmentProcessor.accept((RouteSegment)routeSegment);
            }
        });
    }

    private RouteSegment getAnyOptionalOrVarargsParameterWithTarget() {
        RouteSegment optionalParameter = this.getOptionalParameterWithTarget();
        if (optionalParameter != null) {
            return optionalParameter;
        }
        Iterator<RouteSegment> iterator = this.getOptionalSegments().values().iterator();
        if (iterator.hasNext()) {
            RouteSegment parameter = iterator.next();
            return parameter.getAnyOptionalOrVarargsParameterWithTarget();
        }
        Map<String, RouteSegment> varargsParameters = this.getVarargsSegments();
        if (!varargsParameters.isEmpty()) {
            return varargsParameters.values().iterator().next();
        }
        return null;
    }

    private RouteSegment getOptionalParameterWithTarget() {
        for (RouteSegment parameter : this.getOptionalSegments().values()) {
            if (!parameter.hasTarget()) continue;
            return parameter;
        }
        return null;
    }

    private RuntimeException ambigousOptionalTarget(Class<? extends Component> optionalTarget, Class<? extends Component> otherTarget) {
        String message = String.format("Navigation targets '%s' and '%s' have the same path and '%s' has an OptionalParameter that will never be used as optional.", otherTarget.getName(), optionalTarget.getName(), optionalTarget.getName());
        throw this.ambigousException(message);
    }

    private RuntimeException ambigousTarget(Class<? extends Component> target) {
        String messageFormat = this.isParameter() ? "Navigation targets must have unique routes, found navigation targets '%s' and '%s' with parameter have the same route." : "Navigation targets must have unique routes, found navigation targets '%s' and '%s' with the same route.";
        String message = String.format(messageFormat, this.getTarget().getTarget().getName(), target.getName());
        throw this.ambigousException(message);
    }

    private RuntimeException ambigousException(String message) {
        throw new AmbiguousRouteConfigurationException(message, this.getTarget().getTarget());
    }

    boolean isEmpty() {
        return this.target == null && this.getAllSegments().isEmpty();
    }

    private RouteSegment addSegment(String segmentTemplate, Map<String, RouteSegment> children) {
        RouteSegment routeSegment = new RouteSegment(segmentTemplate, false);
        this.addSegment(routeSegment, children);
        return routeSegment;
    }

    private void addSegment(RouteSegment routeSegment, Map<String, RouteSegment> children) {
        children.put(routeSegment.getTemplate(), routeSegment);
        this.getAllSegments().put(routeSegment.getTemplate(), routeSegment);
    }

    private void removeSegment(String segmentTemplate, Map<String, RouteSegment> children) {
        children.remove(segmentTemplate);
        this.getAllSegments().remove(segmentTemplate);
    }

    private Map<String, RouteSegment> getChildren(String segment) {
        Map<String, RouteSegment> result = RouteFormat.isVarargsParameter(segment) ? this.getVarargsSegments() : (RouteFormat.isOptionalParameter(segment) ? this.getOptionalSegments() : (RouteFormat.isParameter(segment) ? this.getParameterSegments() : this.getStaticSegments()));
        return result;
    }

    private Map<String, RouteSegment> getStaticSegments() {
        if (this.staticSegments == null) {
            this.staticSegments = new LinkedHashMap<String, RouteSegment>();
        }
        return this.staticSegments;
    }

    private Map<String, RouteSegment> getParameterSegments() {
        if (this.parameterSegments == null) {
            this.parameterSegments = new LinkedHashMap<String, RouteSegment>();
        }
        return this.parameterSegments;
    }

    private Map<String, RouteSegment> getOptionalSegments() {
        if (this.optionalSegments == null) {
            this.optionalSegments = new LinkedHashMap<String, RouteSegment>();
        }
        return this.optionalSegments;
    }

    private Map<String, RouteSegment> getVarargsSegments() {
        if (this.varargsSegments == null) {
            this.varargsSegments = new LinkedHashMap<String, RouteSegment>();
        }
        return this.varargsSegments;
    }

    private Map<String, RouteSegment> getAllSegments() {
        if (this.allSegments == null) {
            this.allSegments = new HashMap<String, RouteSegment>();
        }
        return this.allSegments;
    }

    private static Optional<String> getSegmentValue(RouteSegment routeSegment, RouteParameters parameters) {
        if (routeSegment.isVarargs()) {
            return RouteSegment.getVarargsValue(routeSegment, parameters);
        }
        if (routeSegment.isParameter()) {
            return RouteSegment.getParameterValue(routeSegment, parameters);
        }
        return Optional.of(routeSegment.getName());
    }

    private static Optional<String> getVarargsValue(RouteSegment routeSegment, RouteParameters parameters) {
        String parameterName = routeSegment.getName();
        List<String> args = parameters.getWildcard(parameterName);
        ArrayList<String> result = new ArrayList<String>(args.size());
        for (String value : args) {
            if (!routeSegment.isEligible(value)) {
                throw new IllegalArgumentException("Url varargs parameter `" + parameterName + "` has a specified value `" + value + "`, which is invalid according to the parameter definition `" + routeSegment.getTemplate() + "`");
            }
            result.add(value);
        }
        String path = PathUtil.getPath(result);
        return path.isEmpty() ? Optional.empty() : Optional.of(path);
    }

    private static Optional<String> getParameterValue(RouteSegment routeSegment, RouteParameters parameters) {
        String parameterName = routeSegment.getName();
        Optional<String> value = parameters.get(parameterName);
        if (!value.isPresent() && routeSegment.isMandatory()) {
            throw new IllegalArgumentException("Url parameter `" + parameterName + "` is mandatory but missing from the parameters argument.");
        }
        if (value.isPresent() && !routeSegment.isEligible(value.get())) {
            throw new IllegalArgumentException("Url parameter `" + parameterName + "` has specified value `" + value + "`, which is invalid according to the parameter definition `" + routeSegment.getTemplate() + "`");
        }
        return value;
    }

    static class RouteSegmentValue {
        final RouteSegment segment;
        final Optional<String> value;

        RouteSegmentValue(RouteSegment segment, Optional<String> value) {
            this.segment = segment;
            this.value = value;
        }
    }
}

