/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.router.InvalidLocationException;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.ErrorHandlerUtil;
import java.io.EOFException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class DefaultErrorHandler
implements ErrorHandler {
    private final Set<String> ignoredExceptions;

    protected DefaultErrorHandler(Set<String> ignoredExceptions) {
        this.ignoredExceptions = Set.copyOf(ignoredExceptions);
    }

    public DefaultErrorHandler() {
        this.ignoredExceptions = Set.of(SocketException.class.getName(), SocketTimeoutException.class.getName(), EOFException.class.getName(), "org.eclipse.jetty.io.EofException", "org.apache.catalina.connector.ClientAbortException");
    }

    @Override
    public void error(ErrorEvent event) {
        Throwable throwable = DefaultErrorHandler.findRelevantThrowable(event.getThrowable());
        if (this.shouldHandle(throwable)) {
            if (ErrorHandlerUtil.handleErrorByRedirectingToErrorView(throwable)) {
                return;
            }
            Marker marker = MarkerFactory.getMarker((String)"INVALID_LOCATION");
            if (throwable instanceof InvalidLocationException) {
                if (DefaultErrorHandler.getLogger().isWarnEnabled(marker)) {
                    DefaultErrorHandler.getLogger().warn(marker, "", throwable);
                }
            } else {
                DefaultErrorHandler.getLogger().error("", throwable);
            }
        }
    }

    protected boolean shouldHandle(Throwable t) {
        return DefaultErrorHandler.getLogger().isDebugEnabled() || !this.ignoredExceptions.contains(t.getClass().getName());
    }

    public static Throwable findRelevantThrowable(Throwable t) {
        return t;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)DefaultErrorHandler.class.getName());
    }
}

