/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.DevModeHandler;
import com.vaadin.flow.internal.DevModeHandlerManager;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.PwaRegistry;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.ServiceContextUriResolver;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.FaviconHandler;
import com.vaadin.flow.server.communication.IndexHtmlRequestHandler;
import com.vaadin.flow.server.communication.PushRequestHandler;
import com.vaadin.flow.server.communication.WebComponentProvider;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import jakarta.servlet.GenericServlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaadinServletService
extends VaadinService {
    private final VaadinServlet servlet;
    private final ServiceContextUriResolver contextResolver = new ServiceContextUriResolver();

    public VaadinServletService(VaadinServlet servlet, DeploymentConfiguration deploymentConfiguration) {
        super(deploymentConfiguration);
        this.servlet = servlet;
    }

    protected VaadinServletService() {
        this.servlet = null;
    }

    @Override
    protected List<RequestHandler> createRequestHandlers() throws ServiceException {
        List<RequestHandler> handlers = super.createRequestHandlers();
        handlers.add(0, new FaviconHandler());
        Mode mode = this.getDeploymentConfiguration().getMode();
        if (mode == Mode.DEVELOPMENT_FRONTEND_LIVERELOAD || mode == Mode.DEVELOPMENT_BUNDLE) {
            Optional<DevModeHandler> handlerManager = DevModeHandlerManager.getDevModeHandler(this);
            if (handlerManager.isPresent()) {
                DevModeHandler devModeHandler = handlerManager.get();
                handlers.stream().filter(WebComponentProvider.class::isInstance).findFirst().map(handlers::indexOf).ifPresentOrElse(idx -> handlers.add((int)idx, devModeHandler), () -> handlers.add(devModeHandler));
            } else if (mode == Mode.DEVELOPMENT_FRONTEND_LIVERELOAD) {
                VaadinServletService.getLogger().warn("no DevModeHandlerManager implementation found but dev server enabled. Include the com.vaadin.vaadin-dev-server dependency.");
            }
        }
        if (this.isAtmosphereAvailable()) {
            try {
                handlers.add(new PushRequestHandler(this));
            }
            catch (ServiceException e) {
                VaadinServletService.getLogger().warn("Error initializing Atmosphere. Push will not work.", (Throwable)e);
            }
        }
        this.addBootstrapHandler(handlers);
        return handlers;
    }

    private void addBootstrapHandler(List<RequestHandler> handlers) {
        handlers.add(0, new IndexHtmlRequestHandler());
        VaadinServletService.getLogger().debug("Using '{}' in client mode bootstrapping", (Object)IndexHtmlRequestHandler.class.getName());
    }

    public VaadinServlet getServlet() {
        return this.servlet;
    }

    @Override
    public String getMimeType(String resourceName) {
        return this.getServlet().getServletContext().getMimeType(resourceName);
    }

    @Override
    protected boolean requestCanCreateSession(VaadinRequest request) {
        return this.isOtherRequest(request);
    }

    private boolean isOtherRequest(VaadinRequest request) {
        String type = request.getParameter("v-r");
        return type == null || "init".equals(type) || "webcomponent-resync".equals(type);
    }

    public static HttpServletRequest getCurrentServletRequest() {
        return VaadinServletRequest.getCurrent();
    }

    public static VaadinServletResponse getCurrentResponse() {
        return VaadinServletResponse.getCurrent();
    }

    @Override
    public String getServiceName() {
        return this.getServlet().getServletName();
    }

    @Override
    public String getMainDivId(VaadinSession session, VaadinRequest request) {
        int hashCode;
        Object appId = null;
        try {
            URL appUrl = VaadinServlet.getApplicationUrl((HttpServletRequest)((VaadinServletRequest)request));
            appId = appUrl.getPath();
        }
        catch (MalformedURLException appUrl) {
            // empty catch block
        }
        if (appId == null || "".equals(appId) || "/".equals(appId)) {
            appId = "ROOT";
        }
        if ((hashCode = ((String)(appId = ((String)appId).replaceAll("[^a-zA-Z0-9]", ""))).hashCode()) < 0) {
            hashCode = -hashCode;
        }
        appId = (String)appId + "-" + hashCode;
        return appId;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)VaadinServletService.class.getName());
    }

    @Override
    protected RouteRegistry getRouteRegistry() {
        return ApplicationRouteRegistry.getInstance(this.getContext());
    }

    @Override
    protected PwaRegistry getPwaRegistry() {
        return Optional.ofNullable(this.getServlet()).filter(s -> s.getServletConfig() != null).map(GenericServlet::getServletContext).map(PwaRegistry::getInstance).orElse(null);
    }

    @Override
    public String resolveResource(String url) {
        Objects.requireNonNull(url, "Url cannot be null");
        return this.contextResolver.resolveVaadinUri(url);
    }

    @Override
    public URL getStaticResource(String path) {
        try {
            return VaadinServletService.getStaticResource(this.getServlet().getServletContext(), path);
        }
        catch (MalformedURLException e) {
            VaadinServletService.getLogger().warn("Error finding resource for '{}'", (Object)path, (Object)e);
            return null;
        }
    }

    @Override
    public URL getResource(String path) {
        return this.getResourceInServletContext(this.resolveResource(path));
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return this.getResourceInServletContextAsStream(this.resolveResource(path));
    }

    public URL getResourceInServletContext(String path) {
        ServletContext servletContext = this.getServlet().getServletContext();
        try {
            return servletContext.getResource(path);
        }
        catch (MalformedURLException e) {
            VaadinServletService.getLogger().warn("Error finding resource for '{}'", (Object)path, (Object)e);
            return null;
        }
    }

    private InputStream getResourceInServletContextAsStream(String path) {
        ServletContext servletContext = this.getServlet().getServletContext();
        return servletContext.getResourceAsStream(path);
    }

    @Override
    public String getContextRootRelativePath(VaadinRequest request) {
        assert (request instanceof VaadinServletRequest);
        Object servletPath = ((VaadinServletRequest)request).getServletPath();
        assert (servletPath != null);
        if (!((String)servletPath).endsWith("/")) {
            servletPath = (String)servletPath + "/";
        }
        return HandlerHelper.getCancelingRelativePath((String)servletPath) + "/";
    }

    @Override
    protected VaadinContext constructVaadinContext() {
        return new VaadinServletContext(this.getServlet().getServletContext());
    }

    @Override
    protected void setDefaultClassLoader() {
        this.setClassLoader(this.getServlet().getServletContext().getClassLoader());
    }

    static URL getStaticResource(ServletContext servletContext, String path) throws MalformedURLException {
        URL url = servletContext.getResource(path);
        if (url != null && Optional.ofNullable(servletContext.getServerInfo()).orElse("").contains("jetty/12.")) {
            try {
                if (!Files.exists(Path.of(url.toURI()), new LinkOption[0])) {
                    url = null;
                }
            }
            catch (URISyntaxException e) {
                url = null;
            }
        }
        return url;
    }
}

