/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.HasValueAndElement;
import com.vaadin.flow.component.internal.AbstractFieldSupport;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;

public abstract class AbstractField<C extends AbstractField<C, T>, T>
extends Component
implements HasValueAndElement<ComponentValueChangeEvent<C, T>, T> {
    private final AbstractFieldSupport<C, T> fieldSupport;

    public AbstractField(T defaultValue) {
        this.fieldSupport = this.createFieldSupport(defaultValue);
    }

    public AbstractField(Element element, T defaultValue) {
        super(element);
        this.fieldSupport = this.createFieldSupport(defaultValue);
    }

    private AbstractFieldSupport<C, T> createFieldSupport(T defaultValue) {
        AbstractField thisC = this;
        return new AbstractFieldSupport<AbstractField, T>(thisC, defaultValue, this::valueEquals, this::setPresentationValue);
    }

    @Override
    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super ComponentValueChangeEvent<C, T>> listener) {
        return this.fieldSupport.addValueChangeListener(listener);
    }

    @Override
    public void setValue(T value) {
        this.fieldSupport.setValue(value);
    }

    protected abstract void setPresentationValue(T var1);

    protected void setModelValue(T newModelValue, boolean fromClient) {
        this.fieldSupport.setModelValue(newModelValue, fromClient);
    }

    protected boolean valueEquals(T value1, T value2) {
        return this.fieldSupport.valueEquals(value1, value2);
    }

    @Override
    public boolean isEmpty() {
        return this.valueEquals(this.getValue(), this.getEmptyValue());
    }

    @Override
    public T getValue() {
        return this.fieldSupport.getValue();
    }

    @Override
    public T getEmptyValue() {
        return this.fieldSupport.getEmptyValue();
    }

    public static class ComponentValueChangeEvent<C extends Component, V>
    extends ComponentEvent<C>
    implements HasValue.ValueChangeEvent<V> {
        private final V oldValue;
        private final V value;
        private final HasValue<?, V> hasValue;

        public ComponentValueChangeEvent(C source, HasValue<?, V> hasValue, V oldValue, boolean fromClient) {
            super(source, fromClient);
            this.hasValue = hasValue;
            this.oldValue = oldValue;
            this.value = hasValue.getValue();
        }

        @Override
        public V getOldValue() {
            return this.oldValue;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public HasValue<?, V> getHasValue() {
            return this.hasValue;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[source=" + this.source + ", value = " + this.value + ", oldValue = " + this.oldValue + "]";
        }
    }
}

