/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.dau;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.ServiceDestroyEvent;
import com.vaadin.flow.server.ServiceDestroyListener;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinRequestInterceptor;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.dau.DAUCustomizer;
import com.vaadin.flow.server.dau.DAUUtils;
import com.vaadin.flow.server.dau.FlowDauIntegration;
import com.vaadin.flow.server.dau.UserIdentityContext;
import com.vaadin.flow.server.dau.UserIdentitySupplier;
import com.vaadin.pro.licensechecker.dau.DauIntegration;
import jakarta.servlet.http.Cookie;
import java.util.Optional;

public class DAUVaadinRequestInterceptor
implements VaadinRequestInterceptor,
VaadinServiceInitListener,
ServiceDestroyListener {
    private final String applicationName;
    private final UserIdentitySupplier userIdentitySupplier;

    public DAUVaadinRequestInterceptor(DeploymentConfiguration deploymentConfiguration, DAUCustomizer dauCustomizer) {
        this.applicationName = deploymentConfiguration.getApplicationName();
        this.userIdentitySupplier = dauCustomizer != null ? dauCustomizer.getUserIdentitySupplier() : null;
    }

    @Override
    public void requestStart(VaadinRequest request, VaadinResponse response) {
        if (!DAUUtils.isTrackableRequest(request)) {
            return;
        }
        Optional maybePresentCookie = DAUUtils.getTrackingCookie(request).flatMap(DAUUtils::parseCookie);
        if (maybePresentCookie.isPresent()) {
            DAUUtils.DauCookie dauCookie = (DAUUtils.DauCookie)maybePresentCookie.get();
            if (dauCookie.isActive() || FlowDauIntegration.shouldEnforce()) {
                this.trackUser(request, dauCookie.trackingHash());
            }
        } else if (response != null) {
            Cookie cookie = FlowDauIntegration.generateNewCookie(request);
            response.addCookie(cookie);
            if (FlowDauIntegration.shouldEnforce()) {
                this.trackUser(request, DAUUtils.parseCookie(cookie).orElseThrow().trackingHash());
            }
        }
    }

    private void trackUser(VaadinRequest request, String trackingHash) {
        VaadinSession vaadinSession = VaadinSession.getCurrent();
        String userIdentity = Optional.ofNullable(this.userIdentitySupplier).flatMap(supplier -> (Optional)supplier.apply(new UserIdentityContext(request, vaadinSession))).orElse(null);
        FlowDauIntegration.trackUser(request, trackingHash, userIdentity);
    }

    @Override
    public void handleException(VaadinRequest request, VaadinResponse response, VaadinSession vaadinSession, Exception t) {
    }

    @Override
    public void requestEnd(VaadinRequest request, VaadinResponse response, VaadinSession session) {
        request.removeAttribute(DAUUtils.ENFORCEMENT_EXCEPTION_KEY);
    }

    @Override
    public void serviceInit(ServiceInitEvent event) {
        event.getSource().addServiceDestroyListener(this);
        DauIntegration.startTracking((String)this.applicationName);
    }

    @Override
    public void serviceDestroy(ServiceDestroyEvent event) {
        DauIntegration.stopTracking();
    }
}

