/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom.impl;

import com.vaadin.flow.component.internal.ComponentTracker;
import com.vaadin.flow.dom.ChildElementConsumer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementStateProvider;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.dom.NodeVisitor;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.dom.impl.BasicElementStateProvider;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AttachExistingElementFeature;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.ShadowRootHost;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import java.io.Serializable;
import java.util.Optional;

public abstract class AbstractNodeStateProvider
implements ElementStateProvider {
    @Override
    public boolean supports(StateNode node) {
        for (Class<? extends NodeFeature> nsClass : this.getProviderFeatures()) {
            if (node.hasFeature(nsClass)) continue;
            return false;
        }
        return true;
    }

    protected abstract Class<? extends NodeFeature>[] getProviderFeatures();

    @Override
    public Node getParent(StateNode node) {
        StateNode parentNode = node.getParent();
        if (parentNode == null) {
            return null;
        }
        if (parentNode.hasFeature(ShadowRootHost.class)) {
            return ShadowRoot.get(parentNode);
        }
        return Element.get(node.getParent());
    }

    @Override
    public int getChildCount(StateNode node) {
        Optional<ElementChildrenList> maybeList = node.getFeatureIfInitialized(ElementChildrenList.class);
        if (maybeList.isPresent()) {
            return maybeList.get().size();
        }
        return 0;
    }

    @Override
    public Element getChild(StateNode node, int index) {
        assert (index >= 0);
        assert (index < this.getChildCount(node));
        return Element.get(AbstractNodeStateProvider.getChildrenFeature(node).get(index));
    }

    @Override
    public void insertChild(StateNode node, int index, Element child) {
        assert (index >= 0);
        assert (index <= this.getChildCount(node)) : "index " + index + " outside range " + this.getChildCount(node);
        AbstractNodeStateProvider.getChildrenFeature(node).add(index, child.getNode());
        if (child.getComponent().isPresent()) {
            ComponentTracker.trackAttach(child.getComponent().get());
        }
    }

    @Override
    public void removeChild(StateNode node, int index) {
        assert (index >= 0);
        assert (index < this.getChildCount(node));
        AbstractNodeStateProvider.getChildrenFeature(node).remove(index);
    }

    @Override
    public void removeAllChildren(StateNode node) {
        AbstractNodeStateProvider.getChildrenFeature(node).clear();
    }

    @Override
    public void removeChild(StateNode node, Element child) {
        ElementChildrenList childrenFeature = AbstractNodeStateProvider.getChildrenFeature(node);
        int pos = childrenFeature.indexOf(child.getNode());
        if (pos == -1) {
            throw new IllegalArgumentException("Trying to detach an element from parent that does not have it.");
        }
        childrenFeature.remove(pos);
    }

    @Override
    public void attachExistingElement(StateNode node, String tagName, Element previousSibling, ChildElementConsumer callback) {
        if (tagName == null) {
            throw new IllegalArgumentException("Tag name parameter cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback parameter cannot be null");
        }
        StateNode proposedNode = BasicElementStateProvider.createStateNode(tagName);
        node.runWhenAttached(ui -> ui.getInternals().getStateTree().beforeClientResponse(node, context -> {
            node.getFeature(AttachExistingElementFeature.class).register(this.getNode(node), previousSibling, proposedNode, callback);
            ui.getPage().executeJs("this.attachExistingElement($0, $1, $2, $3);", new Serializable[]{this.getNode(node), previousSibling, tagName, Integer.valueOf(proposedNode.getId())});
        }));
    }

    @Override
    public void appendVirtualChild(StateNode node, Element child, String type, String payload) {
        if (!node.hasFeature(VirtualChildrenList.class)) {
            throw new UnsupportedOperationException();
        }
        node.getFeature(VirtualChildrenList.class).append(child.getNode(), type, payload);
    }

    protected void visitDescendants(Node<?> node, NodeVisitor visitor) {
        node.getChildren().forEach(child -> child.accept(visitor));
        node.getNode().getFeatureIfInitialized(VirtualChildrenList.class).ifPresent(list -> list.iterator().forEachRemaining(child -> this.acceptVirtualChild((StateNode)child, visitor)));
    }

    private void acceptVirtualChild(StateNode node, NodeVisitor visitor) {
        if (ShadowRoot.isShadowRoot(node)) {
            ShadowRoot.get(node).accept(visitor);
        } else {
            Element.get(node).accept(visitor);
        }
    }

    protected abstract Node<?> getNode(StateNode var1);

    private static ElementChildrenList getChildrenFeature(StateNode node) {
        return node.getFeature(ElementChildrenList.class);
    }
}

