/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.menu;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.MenuData;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteParameterData;
import com.vaadin.flow.router.internal.ParameterInfo;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.frontend.DevBundleUtils;
import com.vaadin.flow.server.menu.AvailableViewInfo;
import com.vaadin.flow.server.menu.RouteParamType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

public class MenuRegistry {
    public static final String FILE_ROUTES_JSON_NAME = "file-routes.json";
    public static final String FILE_ROUTES_JSON_PROD_PATH = "META-INF/VAADIN/file-routes.json";

    public static Map<String, AvailableViewInfo> collectMenuItems() {
        Map<String, AvailableViewInfo> menuRoutes = MenuRegistry.getMenuItems(true);
        MenuRegistry.filterMenuItems(menuRoutes);
        return menuRoutes;
    }

    public static List<AvailableViewInfo> collectMenuItemsList() {
        return MenuRegistry.collectMenuItemsList(Locale.forLanguageTag("en-US"));
    }

    public static List<AvailableViewInfo> collectMenuItemsList(Locale locale) {
        return MenuRegistry.collectMenuItems().entrySet().stream().map(entry -> {
            AvailableViewInfo value = (AvailableViewInfo)entry.getValue();
            return new AvailableViewInfo(value.title(), value.rolesAllowed(), value.loginRequired(), MenuRegistry.getMenuLink((AvailableViewInfo)entry.getValue(), (String)entry.getKey()), value.lazy(), value.register(), value.menu(), value.children(), value.routeParameters(), value.flowLayout(), value.detail());
        }).sorted(MenuRegistry.getMenuOrderComparator(locale != null ? Collator.getInstance(locale) : Collator.getInstance())).toList();
    }

    public static Map<String, AvailableViewInfo> getMenuItems(boolean filterClientViews) {
        RouteConfiguration routeConfiguration = RouteConfiguration.forApplicationScope();
        HashMap<String, AvailableViewInfo> menuRoutes = new HashMap<String, AvailableViewInfo>(MenuRegistry.collectClientMenuItems(filterClientViews, VaadinService.getCurrent().getDeploymentConfiguration()));
        MenuRegistry.collectAndAddServerMenuItems(routeConfiguration, menuRoutes);
        return menuRoutes;
    }

    public static void collectAndAddServerMenuItems(RouteConfiguration routeConfiguration, Map<String, AvailableViewInfo> menuRoutes) {
        List<RouteData> registeredAccessibleMenuRoutes = routeConfiguration.getRegisteredAccessibleMenuRoutes();
        MenuRegistry.addMenuRoutes(menuRoutes, registeredAccessibleMenuRoutes);
    }

    public static void collectAndAddServerMenuItems(RouteConfiguration routeConfiguration, List<BeforeEnterListener> accessControls, Map<String, AvailableViewInfo> menuRoutes) {
        List<RouteData> registeredAccessibleMenuRoutes = routeConfiguration.getRegisteredAccessibleMenuRoutes(accessControls);
        MenuRegistry.addMenuRoutes(menuRoutes, registeredAccessibleMenuRoutes);
    }

    private static void addMenuRoutes(Map<String, AvailableViewInfo> menuRoutes, List<RouteData> registeredAccessibleMenuRoutes) {
        for (RouteData route : registeredAccessibleMenuRoutes) {
            String title = MenuRegistry.getTitle(route.getNavigationTarget());
            String url = MenuRegistry.getRouteUrl(route);
            Map<String, RouteParamType> parameters = MenuRegistry.getParameters(route);
            menuRoutes.put(url, new AvailableViewInfo(title, null, false, url, false, false, route.getMenuData(), null, parameters, false, null));
        }
    }

    private static String getRouteUrl(RouteData route) {
        if (route.getRouteParameters() != null && !route.getRouteParameters().isEmpty()) {
            Object editUrl = "/" + route.getTemplate();
            for (RouteParameterData param2 : route.getRouteParametersList().stream().filter(param -> param.isOptional() || param.isVarargs()).toList()) {
                editUrl = ((String)editUrl).replace("/" + param2.getTemplate(), "");
            }
            if (((String)editUrl).isEmpty()) {
                editUrl = "/";
            }
            return editUrl;
        }
        return "/" + route.getTemplate();
    }

    public static String getTitle(Class<? extends Component> target) {
        return Optional.ofNullable(target.getAnnotation(PageTitle.class)).map(PageTitle::value).orElse(target.getSimpleName());
    }

    private static Map<String, RouteParamType> getParameters(RouteData route) {
        HashMap<String, RouteParamType> parameters = new HashMap<String, RouteParamType>();
        route.getRouteParameters().forEach((paramTemplate, param) -> {
            ParameterInfo parameterInfo = new ParameterInfo(param.getTemplate());
            parameters.put(param.getTemplate(), RouteParamType.getType(parameterInfo));
        });
        return parameters;
    }

    public static Map<String, AvailableViewInfo> collectClientMenuItems(boolean filterClientViews, AbstractConfiguration configuration) {
        VaadinRequest vaadinRequest = VaadinRequest.getCurrent();
        return MenuRegistry.collectClientMenuItems(filterClientViews, configuration, vaadinRequest);
    }

    public static List<String> getClientRoutes(boolean filterClientViews, AbstractConfiguration configuration) {
        VaadinRequest vaadinRequest = VaadinRequest.getCurrent();
        return new ArrayList<String>(MenuRegistry.collectClientMenuItems(filterClientViews, configuration, vaadinRequest).keySet());
    }

    public static Map<String, AvailableViewInfo> collectClientMenuItems(boolean filterClientViews, AbstractConfiguration configuration, VaadinRequest vaadinRequest) {
        VaadinService vaadinService = Optional.ofNullable(vaadinRequest).map(VaadinRequest::getService).orElseGet(VaadinService::getCurrent);
        HashMap<String, AvailableViewInfo> configurations = new HashMap<String, AvailableViewInfo>();
        MenuRegistry.collectClientMenuItems(configuration).forEach(viewInfo -> MenuRegistry.collectClientViews("", viewInfo, configurations));
        if (filterClientViews && !configurations.isEmpty()) {
            MenuRegistry.filterClientViews(configurations, vaadinService);
        }
        return configurations;
    }

    public static boolean hasHillaMainLayout(AbstractConfiguration configuration) {
        List<AvailableViewInfo> viewInfos = MenuRegistry.collectClientMenuItems(configuration);
        return viewInfos.size() == 1 && MenuRegistry.isMainLayout(viewInfos.iterator().next());
    }

    private static boolean isMainLayout(AvailableViewInfo viewInfo) {
        return (viewInfo.route() == null || viewInfo.route().isBlank()) && viewInfo.children() != null;
    }

    private static List<AvailableViewInfo> collectClientMenuItems(AbstractConfiguration configuration) {
        if (configuration.isProductionMode()) {
            return FileRoutesCache.INSTANCE.get(configuration);
        }
        return MenuRegistry.loadClientMenuItems(configuration);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<AvailableViewInfo> loadClientMenuItems(AbstractConfiguration configuration) {
        Objects.requireNonNull(configuration);
        URL viewsJsonAsResource = MenuRegistry.getViewsJsonAsResource(configuration);
        if (viewsJsonAsResource != null) {
            try (InputStream source = viewsJsonAsResource.openStream();){
                if (source == null) return Collections.emptyList();
                ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                List list = (List)mapper.readValue(source, (TypeReference)new TypeReference<List<AvailableViewInfo>>(){});
                return list;
            }
            catch (IOException e) {
                LoggerFactory.getLogger(MenuRegistry.class).warn("Failed load {} from {}", new Object[]{FILE_ROUTES_JSON_NAME, viewsJsonAsResource.getPath(), e});
                return Collections.emptyList();
            }
        }
        LoggerFactory.getLogger(MenuRegistry.class).debug("No {} found under {} directory. Skipping client route registration.", (Object)FILE_ROUTES_JSON_NAME, (Object)(configuration.isProductionMode() ? "'META-INF/VAADIN'" : "'frontend/generated'"));
        return Collections.emptyList();
    }

    private static void collectClientViews(String basePath, AvailableViewInfo viewConfig, Map<String, AvailableViewInfo> configurations) {
        String path;
        String string = viewConfig.route() == null || viewConfig.route().isEmpty() ? basePath : (path = viewConfig.route().startsWith("/") ? basePath + viewConfig.route() : basePath + "/" + viewConfig.route());
        if (viewConfig.menu() == null) {
            viewConfig = MenuRegistry.copyAvailableViewInfo(viewConfig, new MenuData(viewConfig.title(), null, false, null, null));
        }
        configurations.put(path, viewConfig);
        if (viewConfig.children() != null) {
            viewConfig.children().forEach(child -> MenuRegistry.collectClientViews(path, child, configurations));
        }
    }

    private static AvailableViewInfo copyAvailableViewInfo(AvailableViewInfo source, MenuData newMenuData) {
        return new AvailableViewInfo(source.title(), source.rolesAllowed(), source.loginRequired(), source.route(), source.lazy(), source.register(), newMenuData, source.children(), source.routeParameters(), source.flowLayout(), source.detail());
    }

    public static URL getViewsJsonAsResource(AbstractConfiguration configuration) {
        boolean isProductionMode = configuration.isProductionMode();
        if (isProductionMode) {
            return MenuRegistry.getClassLoader().getResource(FILE_ROUTES_JSON_PROD_PATH);
        }
        try {
            Path fileRoutes = configuration.getFrontendFolder().toPath().resolve("generated/").resolve(FILE_ROUTES_JSON_NAME);
            if (fileRoutes.toFile().exists()) {
                return fileRoutes.toUri().toURL();
            }
            return DevBundleUtils.findBundleFile(configuration.getProjectFolder(), configuration.getBuildFolder(), FILE_ROUTES_JSON_NAME);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(MenuRegistry.class).warn("Failed to find {} in frontend/generated or dev-bundle folder", (Object)FILE_ROUTES_JSON_NAME, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static void filterClientViews(Map<String, AvailableViewInfo> configurations, VaadinService vaadinService) {
        HashSet<String> clientEntries = new HashSet<String>(configurations.keySet());
        for (String key : clientEntries) {
            if (!configurations.containsKey(key)) continue;
            AvailableViewInfo viewInfo = configurations.get(key);
            boolean routeValid = vaadinService.getInstantiator().getMenuAccessControl().canAccessView(viewInfo);
            if (routeValid) continue;
            configurations.remove(key);
            if (viewInfo.children() == null || viewInfo.children().isEmpty()) continue;
            MenuRegistry.removeChildren(configurations, viewInfo, key);
        }
    }

    private static void removeChildren(Map<String, AvailableViewInfo> configurations, AvailableViewInfo viewInfo, String parentPath) {
        for (AvailableViewInfo child : viewInfo.children()) {
            configurations.remove(parentPath + "/" + child.route());
            if (child.children() == null) continue;
            MenuRegistry.removeChildren(configurations, child, parentPath + "/" + child.route());
        }
    }

    private static boolean hasRequiredParameter(AvailableViewInfo viewInfo) {
        Map<String, RouteParamType> routeParameters = viewInfo.routeParameters();
        return routeParameters != null && !routeParameters.isEmpty() && routeParameters.values().stream().anyMatch(paramType -> paramType == RouteParamType.REQUIRED);
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static boolean hasClientRoute(String route) {
        return MenuRegistry.hasClientRoute(route, false);
    }

    public static void clearFileRoutesCache() {
        FileRoutesCache.INSTANCE.clear();
    }

    public static boolean hasClientRoute(String route, boolean excludeLayouts) {
        if (route == null) {
            return false;
        }
        route = route.isEmpty() ? route : (route.startsWith("/") ? route : "/" + route);
        return MenuRegistry.getClientRoutes(excludeLayouts).containsKey(route);
    }

    public static Map<String, AvailableViewInfo> getClientRoutes(boolean excludeLayouts) {
        if (VaadinSession.getCurrent() == null) {
            return Collections.emptyMap();
        }
        Map<String, AvailableViewInfo> clientItems = MenuRegistry.collectClientMenuItems(true, VaadinSession.getCurrent().getConfiguration());
        if (excludeLayouts) {
            clientItems = clientItems.entrySet().stream().filter(entry -> ((AvailableViewInfo)entry.getValue()).children() == null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return clientItems;
    }

    private static Comparator<AvailableViewInfo> getMenuOrderComparator(Collator collator) {
        return (o1, o2) -> {
            int ordersCompareTo = Optional.ofNullable(o1.menu()).map(MenuData::getOrder).orElse((Double)Double.MAX_VALUE).compareTo(Optional.ofNullable(o2.menu()).map(MenuData::getOrder).orElse((Double)Double.MAX_VALUE));
            return ordersCompareTo != 0 ? ordersCompareTo : collator.compare(o1.route(), o2.route());
        };
    }

    private static String getMenuLink(AvailableViewInfo info, String defaultMenuLink) {
        if (info.routeParameters() == null || info.routeParameters().isEmpty()) {
            return defaultMenuLink.startsWith("/") ? defaultMenuLink : "/" + defaultMenuLink;
        }
        Set<String> parameterNames = info.routeParameters().keySet();
        return Stream.of(defaultMenuLink.split("/")).filter(part -> parameterNames.stream().noneMatch(part::startsWith)).collect(Collectors.joining("/"));
    }

    private static void filterMenuItems(Map<String, AvailableViewInfo> menuRoutes) {
        for (String path : new HashSet<String>(menuRoutes.keySet())) {
            if (!menuRoutes.containsKey(path)) continue;
            AvailableViewInfo viewInfo = menuRoutes.get(path);
            if (viewInfo.menu().isExclude() || MenuRegistry.hasRequiredParameter(viewInfo)) {
                menuRoutes.remove(path);
                if (viewInfo.children() == null) continue;
                MenuRegistry.removeChildren(menuRoutes, viewInfo, path);
                continue;
            }
            if (viewInfo.menu().getIcon() != null || viewInfo.menu().title() != null || viewInfo.title() != null) continue;
            menuRoutes.remove(path);
        }
    }

    private static enum FileRoutesCache {
        INSTANCE;

        private List<AvailableViewInfo> cachedResource;

        private List<AvailableViewInfo> get(AbstractConfiguration configuration) {
            if (this.cachedResource == null) {
                this.cachedResource = MenuRegistry.loadClientMenuItems(configuration);
            }
            return this.cachedResource;
        }

        private void clear() {
            this.cachedResource = null;
        }
    }
}

