/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.server.auth.AccessCheckResult;
import com.vaadin.flow.server.auth.AccessPathChecker;
import com.vaadin.flow.server.auth.NavigationAccessChecker;
import com.vaadin.flow.server.auth.NavigationContext;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutePathAccessChecker
implements NavigationAccessChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutePathAccessChecker.class);
    private final AccessPathChecker accessPathChecker;

    public RoutePathAccessChecker(AccessPathChecker accessPathChecker) {
        this.accessPathChecker = Objects.requireNonNull(accessPathChecker, "access path checker is mandatory");
    }

    @Override
    public AccessCheckResult check(NavigationContext context) {
        if (context.isErrorHandling()) {
            return context.neutral();
        }
        String path = context.getLocation().getPath();
        boolean hasPathAccess = this.accessPathChecker.hasAccess(path, context.getPrincipal(), context::hasRole);
        LOGGER.debug("Access to view '{}' with path '{}' is {}", new Object[]{context.getNavigationTarget().getName(), path, hasPathAccess ? "allowed" : "denied"});
        if (hasPathAccess) {
            return context.allow();
        }
        return context.deny("Access to '" + path + "' is denied by security rules.");
    }
}

