/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.internal.JavaScriptBootstrapUI;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.internal.NavigationStateRenderer;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaScriptNavigationStateRenderer
extends NavigationStateRenderer {
    static final String NOT_SUPPORT_FORWARD_BEFORELEAVE = "BeforeLeaveEvent.forwardTo() is not supported. You can use the combination between BeforeLeaveEvent.postpone() and UI.getPage().setLocation(\"{}\") in order to forward to other location";
    static final String NOT_SUPPORT_REROUTE = "BeforeEvent.rerouteTo() with a client side route is not supported";
    private String clientForwardRoute;
    private BeforeLeaveEvent.ContinueNavigationAction continueNavigationAction;

    public JavaScriptNavigationStateRenderer(NavigationState navigationState) {
        super(navigationState);
    }

    public String getClientForwardRoute() {
        return this.clientForwardRoute;
    }

    @Override
    public int handle(NavigationEvent event) {
        this.continueNavigationAction = event.getUI().getInternals().getContinueNavigationAction();
        return super.handle(event);
    }

    @Override
    protected Optional<Integer> handleTriggeredBeforeEvent(NavigationEvent event, BeforeEvent beforeEvent) {
        if (beforeEvent.hasUnknownForward()) {
            if (beforeEvent instanceof BeforeLeaveEvent) {
                JavaScriptNavigationStateRenderer.getLogger().warn(NOT_SUPPORT_FORWARD_BEFORELEAVE, (Object)beforeEvent.getUnknownForward());
            } else {
                this.clientForwardRoute = beforeEvent.getUnknownForward();
                return Optional.of(200);
            }
        }
        if (beforeEvent.hasUnknownReroute()) {
            JavaScriptNavigationStateRenderer.getLogger().warn(NOT_SUPPORT_REROUTE);
        }
        return super.handleTriggeredBeforeEvent(event, beforeEvent);
    }

    @Override
    protected boolean shouldPushHistoryState(NavigationEvent event) {
        if (NavigationTrigger.CLIENT_SIDE.equals((Object)event.getTrigger())) {
            return true;
        }
        return super.shouldPushHistoryState(event);
    }

    @Override
    protected void pushHistoryState(NavigationEvent event) {
        super.pushHistoryState(event);
        if (event.getUI() instanceof JavaScriptBootstrapUI) {
            JavaScriptBootstrapUI jsUI = (JavaScriptBootstrapUI)event.getUI();
            if (this.continueNavigationAction != null && JavaScriptBootstrapUI.ClientViewPlaceholder.class.isAssignableFrom(this.getNavigationState().getNavigationTarget())) {
                jsUI.navigateToClient(event.getLocation().getPathWithQueryParameters());
            }
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)JavaScriptNavigationStateRenderer.class.getName());
    }
}

