/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.shared.util.SharedUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

public class ReflectTools
implements Serializable {
    private static final Pattern GETTER_STARTS = Pattern.compile("^(get)\\p{Lu}");
    private static final Pattern IS_STARTS = Pattern.compile("^(is)\\p{Lu}");
    private static final Pattern SETTER_STARTS = Pattern.compile("^set\\p{Lu}");
    private static final Pattern SETTER_GETTER_STARTS = Pattern.compile("^(set|get|is)");
    static final String CREATE_INSTANCE_FAILED = "Unable to create an instance of '%s'. Make sure it has a no-arg constructor";
    static final String CREATE_INSTANCE_FAILED_FOR_NON_STATIC_MEMBER_CLASS = "Cannot instantiate '%s'. Make sure the class is static if it is an inner class.";
    static final String CREATE_INSTANCE_FAILED_ACCESS_EXCEPTION = "Unable to create an instance of '%s'. Make sure the class is public and that is has a public no-arg constructor.";
    static final String CREATE_INSTANCE_FAILED_NO_PUBLIC_NOARG_CONSTRUCTOR = "Unable to create an instance of '%s'. Make sure the class has a public no-arg constructor.";
    static final String CREATE_INSTANCE_FAILED_LOCAL_CLASS = "Cannot instantiate local class '%s'. Move class declaration outside the method.";
    static final String CREATE_INSTANCE_FAILED_CONSTRUCTOR_THREW_EXCEPTION = "Unable to create an instance of '%s'. The constructor threw an exception.";
    private static final Predicate<Method> IS_SYNTHETIC = Method::isSynthetic;

    public static Method findMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) throws ExceptionInInitializerError {
        try {
            return cls.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static Object getJavaFieldValue(Object object, Field field) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), object.getClass());
            Method getter = pd.getReadMethod();
            if (getter != null) {
                return getter.invoke(object, (Object[])null);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field.get(object);
    }

    public static Object getJavaFieldValue(Object object, Field field, Class<?> propertyType) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        try {
            Method getter;
            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), object.getClass());
            if (propertyType.isAssignableFrom(pd.getPropertyType()) && (getter = pd.getReadMethod()) != null) {
                return getter.invoke(object, (Object[])null);
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (!propertyType.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException();
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field.get(object);
    }

    public static void setJavaFieldValue(Object object, Field field, Object value) throws IllegalArgumentException {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to assign the new value to the field " + field.getName() + " in " + object.getClass().getName() + ". Make sure the field type and value type are compatible.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to assign the new value to the field " + field.getName() + " in " + object.getClass().getName() + ". Make sure the field is not final.", e);
        }
    }

    public static Class<?> convertPrimitiveType(Class<?> type) {
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                type = Boolean.class;
            } else if (type.equals(Integer.TYPE)) {
                type = Integer.class;
            } else if (type.equals(Float.TYPE)) {
                type = Float.class;
            } else if (type.equals(Double.TYPE)) {
                type = Double.class;
            } else if (type.equals(Byte.TYPE)) {
                type = Byte.class;
            } else if (type.equals(Character.TYPE)) {
                type = Character.class;
            } else if (type.equals(Short.TYPE)) {
                type = Short.class;
            } else if (type.equals(Long.TYPE)) {
                type = Long.class;
            }
        }
        return type;
    }

    public static Serializable getPrimitiveDefaultValue(Class<?> primitiveType) {
        if (primitiveType.equals(Integer.TYPE)) {
            return Integer.valueOf(0);
        }
        if (primitiveType.equals(Double.TYPE)) {
            return Double.valueOf(0.0);
        }
        if (primitiveType.equals(Boolean.TYPE)) {
            return Boolean.valueOf(false);
        }
        if (primitiveType.equals(Float.TYPE)) {
            return Float.valueOf(0.0f);
        }
        if (primitiveType.equals(Byte.TYPE)) {
            return Byte.valueOf((byte)0);
        }
        if (primitiveType.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        if (primitiveType.equals(Short.TYPE)) {
            return Short.valueOf((short)0);
        }
        if (primitiveType.equals(Long.TYPE)) {
            return Long.valueOf(0L);
        }
        if (!primitiveType.isPrimitive()) {
            throw new IllegalArgumentException("Provided type " + primitiveType + " is not primitive");
        }
        throw new IllegalStateException("Unexpected primitive type: " + primitiveType);
    }

    public static boolean isSetter(Method method) {
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] argTypes = method.getParameterTypes();
        return returnType == Void.TYPE && argTypes.length == 1 && ReflectTools.isSetterName(methodName);
    }

    public static boolean isSetterName(String methodName) {
        return SETTER_STARTS.matcher(methodName).find();
    }

    public static boolean isGetterName(String methodName, boolean isBoolean) {
        return GETTER_STARTS.matcher(methodName).find() || IS_STARTS.matcher(methodName).find() && isBoolean;
    }

    public static boolean isGetter(Method method) {
        String methodName = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] argTypes = method.getParameterTypes();
        return returnType != Void.TYPE && argTypes.length == 0 && ReflectTools.isGetterName(methodName, returnType == Boolean.TYPE);
    }

    public static Stream<Method> getGetterMethods(Class<?> type) {
        return Stream.of(type.getMethods()).filter(IS_SYNTHETIC.negate()).filter(ReflectTools::isGetter).filter(ReflectTools::isNotObjectMethod);
    }

    public static Stream<Method> getSetterMethods(Class<?> type) {
        return Stream.of(type.getMethods()).filter(IS_SYNTHETIC.negate()).filter(ReflectTools::isSetter);
    }

    public static boolean isNotObjectMethod(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        return declaringClass != Object.class;
    }

    public static String getPropertyName(Method method) {
        String methodName = method.getName();
        assert (ReflectTools.isGetter(method) || ReflectTools.isSetter(method)) : "Method is not a valid getter or setter: " + methodName;
        String propertyName = SETTER_GETTER_STARTS.matcher(methodName).replaceFirst("");
        return SharedUtil.firstToLower(propertyName);
    }

    public static Type getPropertyType(Method method) {
        if (!ReflectTools.isGetter(method) && !ReflectTools.isSetter(method)) {
            throw new IllegalArgumentException("Method is not a valid getter or setter: " + method);
        }
        if (ReflectTools.isGetter(method)) {
            return method.getGenericReturnType();
        }
        return method.getGenericParameterTypes()[0];
    }

    public static <T> T createInstance(Class<T> cls) {
        return ReflectTools.createProxyInstance(cls, cls);
    }

    public static <T> T createProxyInstance(Class<T> proxyClass, Class<?> originalClass) {
        ReflectTools.checkClassAccessibility(originalClass);
        try {
            Optional<Constructor> constructor = Stream.of(proxyClass.getConstructors()).filter(ctor -> ctor.getParameterCount() == 0).findFirst();
            if (constructor.isPresent()) {
                return proxyClass.cast(constructor.get().newInstance(new Object[0]));
            }
            constructor = Stream.of(proxyClass.getConstructors()).filter(ctor -> ctor.getParameterCount() == 1).filter(ctor -> ctor.isVarArgs()).findFirst();
            if (constructor.isPresent()) {
                Class<?> paramType = constructor.get().getParameterTypes()[0];
                return proxyClass.cast(constructor.get().newInstance(Array.newInstance(paramType.getComponentType(), 0)));
            }
        }
        catch (InstantiationException e) {
            if (originalClass.isMemberClass() && !Modifier.isStatic(originalClass.getModifiers())) {
                throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED_FOR_NON_STATIC_MEMBER_CLASS, originalClass.getName()), e);
            }
            throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED, originalClass.getName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED_ACCESS_EXCEPTION, originalClass.getName()), e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED, originalClass.getName()), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED_CONSTRUCTOR_THREW_EXCEPTION, originalClass.getName()), e);
        }
        throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED_NO_PUBLIC_NOARG_CONSTRUCTOR, originalClass.getName()));
    }

    public static void checkClassAccessibility(Class<?> clazz) {
        if (clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED_FOR_NON_STATIC_MEMBER_CLASS, clazz.getName()));
        }
        if (clazz.isLocalClass()) {
            throw new IllegalArgumentException(String.format(CREATE_INSTANCE_FAILED_LOCAL_CLASS, clazz.getName()));
        }
    }

    public static Type createParameterizedType(final Class<?> rawType, final Type subType) {
        return new ParameterizedType(){

            @Override
            public Type getRawType() {
                return rawType;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{subType};
            }
        };
    }

    public static Class<?> getGenericInterfaceType(Class<?> clazz, Class<?> interfaceType) {
        Type type = GenericTypeReflector.getTypeParameter(clazz, interfaceType.getTypeParameters()[0]);
        if (type instanceof Class || type instanceof ParameterizedType) {
            return GenericTypeReflector.erase((Type)type);
        }
        return null;
    }

    public static Optional<Method> getGetter(Class<? extends Object> beanClass, String propertyName) {
        return ReflectTools.getGetterMethods(beanClass).filter(method -> propertyName.equals(ReflectTools.getPropertyName(method))).findFirst();
    }

    public static boolean isCheckedException(Class<?> exceptionClass) {
        return !RuntimeException.class.isAssignableFrom(exceptionClass) && !Error.class.isAssignableFrom(exceptionClass);
    }

    public static Method getFunctionalMethod(Class<?> functionalClass) {
        assert (functionalClass.getAnnotation(FunctionalInterface.class) != null);
        Method[] methods = functionalClass.getMethods();
        if (methods.length == 1) {
            return methods[0];
        }
        List filteredMethods = Stream.of(methods).filter(method -> !Modifier.isStatic(method.getModifiers()) && !method.isDefault()).collect(Collectors.toList());
        assert (filteredMethods.size() == 1);
        return (Method)filteredMethods.get(0);
    }

    public static List<Integer> getConstantIntValues(Class<?> clazz) {
        ArrayList<Integer> integerConstants = new ArrayList<Integer>();
        for (Field field : ReflectTools.getConstants(clazz)) {
            if (!field.getType().equals(Integer.TYPE)) continue;
            try {
                integerConstants.add(field.getInt(null));
            }
            catch (IllegalAccessException e) {
                String msg = String.format("Received access exception for public field '%s' in class '%s'", field.getName(), clazz.getSimpleName());
                assert (false) : msg;
                LoggerFactory.getLogger((String)ReflectTools.class.getName()).warn(msg, (Throwable)e);
            }
        }
        return integerConstants;
    }

    public static Class<?> findCommonBaseType(Class<?> a, Class<?> b) {
        if (a.isInterface()) {
            throw new IllegalArgumentException("a cannot be an interface");
        }
        if (b.isInterface()) {
            throw new IllegalArgumentException("b cannot be an interface");
        }
        if (a.isPrimitive()) {
            throw new IllegalArgumentException("a cannot be a primitive type");
        }
        if (b.isPrimitive()) {
            throw new IllegalArgumentException("b cannot be a primitive type");
        }
        if (a.isAssignableFrom(b)) {
            return a;
        }
        if (b.isAssignableFrom(a)) {
            return b;
        }
        Class<?> currentClass = a;
        while (!currentClass.isAssignableFrom(b)) {
            currentClass = currentClass.getSuperclass();
        }
        return currentClass;
    }

    public static Optional<ClassLoader> findClosestCommonClassLoaderAncestor(ClassLoader classLoaderA, ClassLoader classLoaderB) {
        if (classLoaderA == null || classLoaderB == null) {
            return Optional.empty();
        }
        HashSet<ClassLoader> parents = new HashSet<ClassLoader>();
        ClassLoader parentA = classLoaderA;
        ClassLoader parentB = classLoaderB;
        while (parentA != null || parentB != null) {
            if (parentA != null) {
                if (parents.contains(parentA)) {
                    return Optional.of(parentA);
                }
                parents.add(parentA);
                parentA = parentA.getParent();
            }
            if (parentB == null) continue;
            if (parents.contains(parentB)) {
                return Optional.of(parentB);
            }
            parents.add(parentB);
            parentB = parentB.getParent();
        }
        return Optional.empty();
    }

    public static boolean hasAnnotation(AnnotatedElement element, String annotationFqn) {
        return ReflectTools.getAnnotation(element, annotationFqn).isPresent();
    }

    public static Object getAnnotationMethodValue(Annotation annotation, String methodName) {
        try {
            Method method = annotation.annotationType().getDeclaredMethod(methodName, new Class[0]);
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Couldn't invoke the method " + methodName + " on the annotation " + annotation.annotationType(), e);
        }
    }

    public static Optional<Annotation> getAnnotation(AnnotatedElement element, String annotationFqn) {
        for (Annotation annotation : element.getAnnotations()) {
            if (!annotation.annotationType().getName().equals(annotationFqn)) continue;
            return Optional.of(annotation);
        }
        return Optional.empty();
    }

    private static List<Field> getConstants(Class<?> staticFields) {
        Field[] declaredFields;
        ArrayList<Field> staticFinalFields = new ArrayList<Field>();
        for (Field field : declaredFields = staticFields.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
            staticFinalFields.add(field);
        }
        return staticFinalFields;
    }
}

