/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.webcomponent.WebComponentModulesWriter;
import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class FrontendWebComponentGenerator
implements Serializable {
    private final ClassFinder finder;

    public FrontendWebComponentGenerator(ClassFinder finder) {
        this.finder = finder;
    }

    public Set<File> generateWebComponents(File outputDirectory) {
        try {
            Class writerClass = this.finder.loadClass(WebComponentModulesWriter.class.getName());
            HashSet exporterRelatedClasses = new HashSet();
            this.finder.getSubTypesOf(WebComponentExporter.class.getName()).forEach(exporterRelatedClasses::add);
            this.finder.getSubTypesOf(WebComponentExporterFactory.class.getName()).forEach(exporterRelatedClasses::add);
            return WebComponentModulesWriter.DirectoryWriter.generateWebComponentsToDirectory(writerClass, exporterRelatedClasses, outputDirectory, false);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to locate a required class using custom class loader", e);
        }
    }
}

