/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla;

import com.github.javaparser.ast.expr.AnnotationExpr;
import dev.hilla.ExplicitNullableTypeCheckerHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Stream;

public class ExplicitNullableTypeChecker {
    public static boolean isRequired(AnnotatedElement element) {
        if (element instanceof Field && ((Field)element).getType().isPrimitive() || element instanceof Parameter && ((Parameter)element).getType().isPrimitive()) {
            return true;
        }
        Stream<Annotation> annotations = Stream.of(element.getAnnotations());
        if (element instanceof Field) {
            annotations = Stream.concat(annotations, Stream.of(((Field)element).getAnnotatedType().getAnnotations()));
        } else if (element instanceof Parameter) {
            annotations = Stream.concat(annotations, Stream.of(((Parameter)element).getAnnotatedType().getAnnotations()));
        }
        return annotations.anyMatch(annotation -> "nonnull".equalsIgnoreCase(annotation.annotationType().getSimpleName()));
    }

    public static boolean isRequired(List<AnnotationExpr> annotations) {
        return annotations != null && annotations.stream().anyMatch(annotation -> "nonnull".equalsIgnoreCase(annotation.getName().getIdentifier()));
    }

    public String checkValueForAnnotatedElement(Object value, AnnotatedElement annotatedElement) {
        if (!ExplicitNullableTypeChecker.isRequired(annotatedElement)) {
            return null;
        }
        if (annotatedElement instanceof Method) {
            return this.checkValueForType(value, ((Method)annotatedElement).getGenericReturnType());
        }
        return null;
    }

    String checkValueForType(Object value, Type expectedType) {
        return new ExplicitNullableTypeCheckerHelper().checkValueForType(value, expectedType);
    }
}

