/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.generator.typescript;

import dev.hilla.generator.GeneratorUtils;
import dev.hilla.generator.typescript.TypeParser;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class CodeGeneratorUtils {
    private CodeGeneratorUtils() {
    }

    static String getSimpleNameFromComplexType(String dataType, List<Map<String, String>> imports) {
        return TypeParser.parse(dataType).traverse().visit(new SimpleNameVisitor(imports)).finish().toString();
    }

    static String getSimpleNameFromImports(String dataType, List<Map<String, String>> imports) {
        if (imports != null) {
            for (Map<String, String> anImport : imports) {
                if (!Objects.equals(dataType, anImport.get("import"))) continue;
                return GeneratorUtils.firstNonBlank(anImport.get("importAs"), anImport.get("className"));
            }
        }
        if (GeneratorUtils.contains(dataType, "<") || GeneratorUtils.contains(dataType, "{") || GeneratorUtils.contains(dataType, "|")) {
            return CodeGeneratorUtils.getSimpleNameFromComplexType(dataType, imports);
        }
        return CodeGeneratorUtils.getSimpleNameFromQualifiedName(dataType);
    }

    static String getSimpleNameFromQualifiedName(String qualifiedName) {
        if (GeneratorUtils.contains(qualifiedName, ".")) {
            return GeneratorUtils.substringAfterLast(qualifiedName, ".");
        }
        return qualifiedName;
    }

    static class SimpleNameVisitor
    implements TypeParser.Visitor {
        private final List<Map<String, String>> imports;

        SimpleNameVisitor(List<Map<String, String>> imports) {
            this.imports = imports;
        }

        @Override
        public TypeParser.Node enter(TypeParser.Node node, TypeParser.Node parent) {
            String name = node.getName();
            if (name.contains(".")) {
                node.setName(CodeGeneratorUtils.getSimpleNameFromImports(name, this.imports));
            }
            return node;
        }
    }
}

